/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.bus.protocol;

import net.isger.brick.bus.protocol.SocketProtocol;
import net.isger.brick.bus.protocol.TextSocketDecoder;
import net.isger.brick.bus.protocol.TextSocketEncoder;
import net.isger.util.Decoder;
import net.isger.util.Encoder;
import net.isger.util.Strings;
import net.isger.util.anno.Alias;

@Alias(value="text.socket")
public class TextSocketProtocol
implements SocketProtocol {
    public static final String DELIMITER = "\n";
    @Alias(value="brick.encoding")
    private String encoding;
    private String sourceCharset;
    private String targetCharset;
    private String delimiter = "\n";
    private transient TextSocketEncoder encoder;
    private transient TextSocketDecoder decoder;

    public final void initial() {
        this.sourceCharset = Strings.empty((Object)this.sourceCharset, (String)this.encoding);
        this.targetCharset = Strings.empty((Object)this.targetCharset, (String)this.encoding);
        if (this.encoder == null) {
            this.encoder = this.createEncoder(this.sourceCharset, this.targetCharset, this.delimiter);
        }
        if (this.decoder == null) {
            this.decoder = this.createDecoder(this.targetCharset, this.sourceCharset, this.delimiter);
        }
    }

    protected TextSocketEncoder createEncoder(String sourceCharset, String targetCharset, String delimiter) {
        return new TextSocketEncoder(sourceCharset, targetCharset, delimiter);
    }

    protected TextSocketDecoder createDecoder(String sourceCharset, String targetCharset, String delimiter) {
        return new TextSocketDecoder(sourceCharset, targetCharset, delimiter);
    }

    @Override
    public Encoder getEncoder() {
        return this.encoder;
    }

    @Override
    public Decoder getDecoder() {
        return this.decoder;
    }

    public void destroy() {
    }
}

