/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.core;

import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.isger.brick.auth.AuthIdentity;
import net.isger.brick.core.Command;
import net.isger.brick.core.Console;
import net.isger.brick.core.Context;
import net.isger.brick.core.CoreHelper;
import net.isger.brick.stub.model.Meta;
import net.isger.brick.stub.model.Model;
import net.isger.util.Helpers;
import net.isger.util.Reflects;
import net.isger.util.Strings;
import net.isger.util.reflect.AssemblerAdapter;
import net.isger.util.reflect.BoundField;
import net.isger.util.reflect.ClassAssembler;
import net.isger.util.reflect.TypeToken;
import org.apache.avro.Schema;

public class BaseCommand
extends Command
implements Cloneable {
    public static final int HEADERS = 0;
    public static final int PARAMETERS = 1;
    public static final int FOOTERS = 2;
    public static final String CTRL_IDENTITY = "brick-identity";
    public static final String CTRL_MODULE = "brick-module";
    public static final String CTRL_OPERATE = "brick-operate";
    public static final String CTRL_PAYLOAD = "brick-payload";
    public static final String DRCT_RESULT = "brick-result";
    private ShellCommand shell;

    public BaseCommand() {
        this(null, true);
    }

    public BaseCommand(Command source) {
        this(source, true);
    }

    public BaseCommand(boolean hasShell) {
        this(null, hasShell);
    }

    private BaseCommand(Command source, boolean hasShell) {
        if (hasShell) {
            ShellCommand shell = null;
            if (source == null) {
                source = this;
            } else if (source instanceof BaseCommand) {
                shell = ((BaseCommand)source).shell;
            }
            this.makeShell(source, shell);
        }
    }

    public static BaseCommand getAction() {
        try {
            return Context.getAction().getCommand();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BaseCommand newAction() {
        try {
            return Context.getAction().newCommand();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BaseCommand mockAction() {
        try {
            return Context.getAction().mockCommand();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BaseCommand realAction() {
        try {
            return Context.getAction().realCommand();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BaseCommand cast(Command source) {
        if (source == null || source instanceof BaseCommand) {
            return (BaseCommand)source;
        }
        return new BaseCommand(source, true);
    }

    public final BaseCommand cast() {
        return this.infect(new BaseCommand(false));
    }

    public final <T extends BaseCommand> T infect(T command) {
        command.shell = this.shell;
        return command;
    }

    public Command getSource() {
        return this.shell.getSource();
    }

    @Override
    public Schema getSchema() {
        return this.shell.getSchema();
    }

    public Object get(String name) {
        return this.shell.get(name);
    }

    @Override
    public Object get(int index) {
        return this.shell.get(index);
    }

    public void put(String name, Object value) {
        this.shell.put(name, value);
    }

    @Override
    public void put(int index, Object value) {
        this.shell.put(index, value);
    }

    @Override
    public Map<CharSequence, ByteBuffer> getHeaders() {
        return this.shell.getHeaders();
    }

    @Override
    public void setHeaders(Map<CharSequence, ByteBuffer> value) {
        this.shell.setHeaders(value);
    }

    @Override
    public Map<CharSequence, ByteBuffer> getParameters() {
        return this.shell.getParameters();
    }

    @Override
    public void setParameters(Map<CharSequence, ByteBuffer> value) {
        this.shell.setParameters(value);
    }

    @Override
    public Map<CharSequence, ByteBuffer> getFooters() {
        return this.shell.getFooters();
    }

    @Override
    public void setFooters(Map<CharSequence, ByteBuffer> value) {
        this.shell.setFooters(value);
    }

    public Map<String, Object> getHeader() {
        return this.shell.getHeader();
    }

    public <T> T getHeader(CharSequence key) {
        return this.shell.getHeader(key);
    }

    public void setHeader(Map<String, Object> parameters) {
        this.shell.setHeader(parameters);
    }

    public void setHeader(Map<String, Object> parameters, boolean appended) {
        this.shell.setHeader(parameters, appended);
    }

    public void setHeader(CharSequence key, Object value) {
        this.shell.setHeader(key, value);
    }

    public void clearHeader() {
        this.shell.setHeader(null);
    }

    public Model getParameter(Model model) {
        return (Model)this.getParameter(model, null, false);
    }

    public Model getParameter(Model model, String namespace) {
        return (Model)this.getParameter(model, namespace, false);
    }

    public <T> T getParameter(Model model, boolean isBatch) {
        return this.getParameter(model, null, isBatch);
    }

    public <T> T getParameter(Model model, String namespace, boolean isBatch) {
        return (T)this.shell.getParameter(model, namespace, isBatch);
    }

    public <T> T getParameter(Class<T> type) {
        return this.getParameter(type, null, false);
    }

    public <T> T getParameter(Class<T> type, String namespace) {
        return this.getParameter(type, namespace, false);
    }

    public <T> T getParameter(Class<?> type, boolean isBatch) {
        return this.getParameter(type, null, isBatch);
    }

    public <T> T getParameter(Class<?> type, String namespace, boolean isBatch) {
        return this.getParameter(type, namespace, isBatch, null);
    }

    public <T> T getParameter(Class<T> type, ClassAssembler assembler) {
        return this.getParameter(type, null, false, assembler);
    }

    public <T> T getParameter(Class<?> type, boolean isBatch, ClassAssembler assembler) {
        return (T)this.shell.getParameter(type, null, isBatch, assembler);
    }

    public <T> T getParameter(Class<?> type, String namespace, boolean isBatch, ClassAssembler assembler) {
        return (T)this.shell.getParameter(type, namespace, isBatch, assembler);
    }

    public Map<String, Object> getParameter() {
        return this.shell.getParameter();
    }

    public <T> T getParameter(CharSequence key) {
        return this.getParameter(key, null, false, null);
    }

    public <T> T getParameter(CharSequence key, String namespace) {
        return this.getParameter(key, namespace, false, null);
    }

    public <T> T getParameter(CharSequence key, boolean isBatch) {
        return this.getParameter(key, null, isBatch, null);
    }

    public <T> T getParameter(CharSequence key, boolean isBatch, String suffix) {
        return this.getParameter(key, null, isBatch, suffix);
    }

    public <T> T getParameter(CharSequence key, String namespace, boolean isBatch) {
        return this.getParameter(key, namespace, isBatch, null);
    }

    public <T> T getParameter(CharSequence key, String namespace, boolean isBatch, String suffix) {
        return (T)this.shell.getParameter(key, namespace, isBatch, suffix);
    }

    public void setParameter(Map<String, ? extends Object> parameters) {
        this.shell.setParameter(parameters);
    }

    public void setParameter(Map<String, ? extends Object> parameters, boolean appended) {
        this.shell.setParameter(parameters, appended);
    }

    public void setParameter(CharSequence key, Object value) {
        this.shell.setParameter(key, value);
    }

    public void clearParameter() {
        this.shell.setParameter(null);
    }

    public Map<String, Object> getFooter() {
        return this.shell.getFooter();
    }

    public <T> T getFooter(CharSequence key) {
        return this.shell.getFooter(key);
    }

    public void setFooter(Map<String, Object> parameters) {
        this.shell.setFooter(parameters);
    }

    public void setFooter(Map<String, Object> parameters, boolean appended) {
        this.shell.setFooter(parameters, appended);
    }

    public void setFooter(CharSequence key, Object value) {
        this.shell.setFooter(key, value);
    }

    public void clearFooter() {
        this.shell.setFooter(null);
    }

    public Object get(int index, CharSequence key) {
        return this.shell.get(index, key);
    }

    public void set(int index, CharSequence key, Object value) {
        this.shell.set(index, key, value);
    }

    public String getPermission() {
        return this.getOperate();
    }

    public AuthIdentity getIdentity() {
        return this.shell.getIdentity();
    }

    public void setIdentity(AuthIdentity identity) {
        this.shell.setIdentity(identity);
    }

    public String getModule() {
        return this.shell.getModule();
    }

    public void setModule(String module) {
        this.shell.setModule(module);
    }

    public String getOperate() {
        return this.shell.getOperate();
    }

    public void setOperate(String operate) {
        this.shell.setOperate(operate);
    }

    public Object getPayload() {
        return this.shell.getPayload();
    }

    public void setPayload(Object payload) {
        this.shell.setPayload(payload);
    }

    public Object getResult() {
        return this.shell.getResult();
    }

    public void setResult(Object result) {
        this.shell.setResult(result);
    }

    public BaseCommand clone() {
        BaseCommand cmd;
        try {
            cmd = (BaseCommand)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
        Command source = this.getSource();
        if (source == this) {
            source = cmd;
        } else if (source instanceof BaseCommand) {
            source = ((BaseCommand)source).clone();
        }
        cmd.makeShell(source, this.shell);
        return cmd;
    }

    private void makeShell(Command source, ShellCommand shell) {
        this.shell = source == this ? new AutoCommand() : (source instanceof BaseCommand ? new ProxyCommand() : new ShellCommand());
        this.shell.source = source;
        if (shell == null) {
            shell = this.shell;
        }
        this.shell.mappings = Helpers.newMap((Map)shell.mappings, (Object[])new ByteBuffer[0]);
        this.shell.setHeaders(Helpers.newMap(shell.getHeaders(), (Object[])new CharSequence[0]));
        this.shell.setParameters(Helpers.newMap(shell.getParameters(), (Object[])new CharSequence[0]));
        this.shell.setFooters(Helpers.newMap(shell.getFooters(), (Object[])new CharSequence[0]));
    }

    private class AutoCommand
    extends ShellCommand {
        private AutoCommand() {
        }

        @Override
        protected Schema getSchema() {
            return BaseCommand.super.getSchema();
        }

        @Override
        protected Object get(String name) {
            return BaseCommand.super.get(name);
        }

        @Override
        protected Object get(int index) {
            return BaseCommand.super.get(index);
        }

        @Override
        protected void put(String name, Object value) {
            BaseCommand.super.put(name, value);
        }

        @Override
        protected void put(int index, Object value) {
            BaseCommand.super.put(index, value);
        }

        @Override
        protected Map<CharSequence, ByteBuffer> getHeaders() {
            return BaseCommand.super.getHeaders();
        }

        @Override
        protected void setHeaders(Map<CharSequence, ByteBuffer> value) {
            BaseCommand.super.setHeaders(value);
        }

        @Override
        protected Map<CharSequence, ByteBuffer> getParameters() {
            return BaseCommand.super.getParameters();
        }

        @Override
        protected void setParameters(Map<CharSequence, ByteBuffer> value) {
            BaseCommand.super.setParameters(value);
        }

        @Override
        protected Map<CharSequence, ByteBuffer> getFooters() {
            return BaseCommand.super.getFooters();
        }

        @Override
        protected void setFooters(Map<CharSequence, ByteBuffer> value) {
            BaseCommand.super.setFooters(value);
        }
    }

    private class ProxyCommand
    extends ShellCommand {
        private ProxyCommand() {
        }

        @Override
        protected BaseCommand getSource() {
            return (BaseCommand)super.getSource();
        }

        @Override
        protected Map<String, Object> gets(int index) {
            return this.getSource().shell.gets(index);
        }

        @Override
        protected void sets(int index, Map<String, ? extends Object> values, boolean appended) {
            this.getSource().shell.sets(index, values, appended);
        }

        @Override
        protected <T> T get(int index, CharSequence key) {
            return this.getSource().shell.get(index, key);
        }

        @Override
        protected void set(int index, CharSequence key, Object value) {
            this.getSource().shell.set(index, key, value);
        }
    }

    private class ShellCommand {
        private Command source;
        private Map<ByteBuffer, Object> mappings;

        private ShellCommand() {
        }

        protected Command getSource() {
            return this.source;
        }

        protected Schema getSchema() {
            return this.source.getSchema();
        }

        protected Object get(String name) {
            return this.source.get(name);
        }

        protected Object get(int index) {
            return this.source.get(index);
        }

        protected void put(String name, Object value) {
            this.source.put(name, value);
        }

        protected void put(int index, Object value) {
            this.source.put(index, value);
        }

        protected Map<CharSequence, ByteBuffer> getHeaders() {
            return this.source.getHeaders();
        }

        protected void setHeaders(Map<CharSequence, ByteBuffer> value) {
            this.source.setHeaders(value);
        }

        protected Map<CharSequence, ByteBuffer> getParameters() {
            return this.source.getParameters();
        }

        protected void setParameters(Map<CharSequence, ByteBuffer> value) {
            this.source.setParameters(value);
        }

        protected Map<CharSequence, ByteBuffer> getFooters() {
            return this.source.getFooters();
        }

        protected void setFooters(Map<CharSequence, ByteBuffer> value) {
            this.source.setFooters(value);
        }

        protected Map<String, Object> gets(int index) {
            Map indeces = (Map)this.get(index);
            HashMap<String, Object> result = new HashMap<String, Object>(indeces.size());
            for (Map.Entry entry : indeces.entrySet()) {
                ByteBuffer buffer = (ByteBuffer)entry.getValue();
                if (!this.mappings.containsKey(buffer)) continue;
                result.put(((CharSequence)entry.getKey()).toString(), this.mappings.get(buffer));
            }
            return result;
        }

        protected void sets(int index, Map<String, ? extends Object> values, boolean appended) {
            if (values == null) {
                values = new HashMap<String, Object>();
                appended = false;
            }
            Map indeces = (Map)this.get(index);
            if (!appended) {
                this.clear(indeces);
                if (index == 1) {
                    this.setPayload(null);
                }
            }
            for (Map.Entry<String, ? extends Object> entry : values.entrySet()) {
                this.set(indeces, (CharSequence)entry.getKey(), entry.getValue());
            }
        }

        protected <T> T get(int index, CharSequence key) {
            Map indeces = (Map)this.get(index);
            return (T)this.mappings.get(indeces.get(key));
        }

        protected void set(int index, CharSequence key, Object value) {
            Map buffers = (Map)this.get(index);
            this.set(buffers, key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void set(Map<CharSequence, ByteBuffer> indeces, CharSequence key, Object value) {
            ByteBuffer index = indeces.get(key);
            if (value == null) {
                if (index != null) {
                    indeces.remove(key);
                    this.mappings.remove(index);
                }
            } else {
                Map<CharSequence, ByteBuffer> map = indeces;
                synchronized (map) {
                    if (index == null) {
                        index = this.mapping(value);
                        indeces.put(key, index);
                        return;
                    }
                }
                this.mappings.put(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer mapping(Object value) {
            ByteBuffer index;
            Map<ByteBuffer, Object> map = this.mappings;
            synchronized (map) {
                while (this.mappings.containsKey(index = ByteBuffer.wrap(Helpers.makeUUID().getBytes()))) {
                }
                this.mappings.put(index, value);
            }
            return index;
        }

        private void clear(Map<CharSequence, ByteBuffer> indeces) {
            for (ByteBuffer index : indeces.values()) {
                this.mappings.remove(index);
            }
            indeces.clear();
        }

        public final Map<String, Object> getHeader() {
            return this.gets(0);
        }

        public final <T> T getHeader(CharSequence key) {
            return this.get(0, key);
        }

        public final void setHeader(Map<String, Object> headers) {
            this.sets(0, headers, true);
        }

        public final void setHeader(Map<String, Object> headers, boolean appended) {
            this.sets(0, headers, appended);
        }

        public final void setHeader(CharSequence key, Object value) {
            this.set(0, key, value);
        }

        public final Object getParameter(Model model, String namespace, boolean isBatch) {
            Model instance;
            Map pending;
            Map<String, Object> params = new HashMap<String, Object>();
            Object payload = this.getPayload();
            if (payload instanceof Map) {
                params.putAll((Map)payload);
            } else if (payload instanceof String && Strings.isNotEmpty((Object)payload) && (pending = (Map)Helpers.fromJson((String)((String)payload), Map.class)) != null) {
                params.putAll(pending);
            }
            params.putAll(this.getParameter());
            params = (Map)Helpers.coalesce((Object[])new Map[]{Helpers.getMap(params, (String)namespace), params});
            if (!isBatch) {
                instance = model.clone();
                instance.metaValue(params);
                return instance;
            }
            ArrayList<Model> result = new ArrayList<Model>();
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Object> values = new ArrayList<Object>();
            for (String name : model.metas().names()) {
                Object value = Helpers.getValues(params, (String)name);
                if (value == null) continue;
                names.add(name);
                values.add(value);
            }
            Object[] columns = names.toArray();
            for (Object[] row : Helpers.newGrid((boolean)true, (Object[])values.toArray())) {
                instance = model.clone();
                instance.metaValue(Reflects.toMap((Object[])columns, (Object[])row));
                result.add(instance);
            }
            return result;
        }

        public final Object getParameter(Class<?> type, String namespace, boolean isBatch, ClassAssembler assembler) {
            Map pending;
            HashMap<String, Object> params = new HashMap<String, Object>();
            Object payload = this.getPayload();
            if (payload instanceof Map) {
                params.putAll((Map)payload);
            } else if (payload instanceof String && Strings.isNotEmpty((Object)payload) && (pending = (Map)Helpers.fromJson((String)((String)payload), Map.class)) != null) {
                params.putAll(pending);
            }
            params.putAll(this.getParameter());
            params = (Map)Helpers.coalesce((Object[])new Map[]{Helpers.getMap(params, (String)namespace), params});
            if (assembler == null) {
                assembler = this.createAssembler(params);
            }
            if (Map.class.isAssignableFrom(type)) {
                return params;
            }
            if (!isBatch) {
                return Reflects.newInstance(type, params, (ClassAssembler)assembler);
            }
            ArrayList<Object> result = new ArrayList<Object>();
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Object> values = new ArrayList<Object>();
            Map fields = Reflects.getBoundFields(type);
            for (Map.Entry entry : fields.entrySet()) {
                BoundField field;
                Class rawClass;
                String name = (String)entry.getKey();
                Object value = Helpers.getValues(params, (String)name, (Class)(rawClass = assembler.assemble((field = (BoundField)((List)entry.getValue()).get(0)).getToken().getRawClass())));
                if (value == null) {
                    name = field.getAlias();
                    value = Helpers.getValues(params, (String)name, (Class)rawClass);
                }
                if (value == null) continue;
                names.add(name);
                values.add(value);
            }
            Object[] columns = names.toArray();
            for (Object[] row : Helpers.newGrid((boolean)true, (Object[])values.toArray())) {
                result.add(Reflects.newInstance(type, (Map)Reflects.toMap((Object[])columns, (Object[])row), (ClassAssembler)assembler));
            }
            return Helpers.toArray(type, (Object)result.toArray());
        }

        public final Object getParameter(CharSequence key, String namespace, boolean isBatch, String suffix) {
            Map pending;
            Map<String, Object> params = new HashMap<String, Object>();
            Object payload = this.getPayload();
            if (payload instanceof Map) {
                params.putAll((Map)payload);
            } else if (payload instanceof String && Strings.isNotEmpty((Object)payload) && (pending = (Map)Helpers.fromJson((String)((String)payload), Map.class)) != null) {
                params.putAll(pending);
            }
            params.putAll(this.getParameter());
            params = (Map)Helpers.coalesce((Object[])new Map[]{Helpers.getMap(params, (String)namespace), params});
            if (!isBatch) {
                return Helpers.getValue(params, (String)key.toString());
            }
            Object values = Helpers.getValues(params, (String)key.toString(), (String)suffix);
            return values == null || values.getClass().isArray() ? values : Helpers.newArray((Object)values);
        }

        protected ClassAssembler createAssembler(final Map<String, Object> params) {
            final Console console = CoreHelper.getConsole();
            return console == null ? null : new AssemblerAdapter(){

                public Class<?> assemble(Class<?> rawClass) {
                    Class clazz = Reflects.getClass(params.get("class"));
                    if (clazz != null && rawClass.isAssignableFrom(clazz)) {
                        rawClass = clazz;
                    } else if (rawClass.isInterface()) {
                        rawClass = console.getContainer().getInstance(Class.class, Strings.toColumnName((String)rawClass.getSimpleName()).replaceAll("[_]", ".") + ".class");
                    }
                    return rawClass;
                }

                public Object assemble(BoundField field, Object instance, Object value, Object ... args) {
                    TypeToken typeToken;
                    Class rawClass;
                    Map data = (Map)args[0];
                    Assemble assermble = ShellCommand.this.createAssemble(field);
                    if (value == Reflects.UNKNOWN) {
                        value = Helpers.getInstance((Map)data, (String)Strings.toFieldName((String)assermble.sourceColumn));
                    }
                    if (Collection.class.isAssignableFrom(rawClass = (typeToken = field.getToken()).getRawClass())) {
                        rawClass = (Class)Reflects.getActualType((Type)typeToken.getType());
                    } else if (rawClass.isArray()) {
                        rawClass = (Class)Reflects.getComponentType((Type)typeToken.getType());
                    }
                    rawClass = this.assemble(rawClass);
                    if (value != null && !(value instanceof Map)) {
                        HashMap params2 = new HashMap();
                        params2.put(assermble.targetField, value);
                        value = params2;
                    }
                    return Reflects.newInstance((Class)rawClass, (Map)value, (ClassAssembler)this);
                }
            };
        }

        private Assemble createAssemble(BoundField field) {
            Assemble assemble = new Assemble();
            assemble.meta = Meta.createMeta(field);
            if (assemble.meta.toModel() == null) {
                assemble.sourceColumn = assemble.meta.getName();
                assemble.targetField = (String)assemble.meta.getValue();
            } else {
                Map params = (Map)assemble.meta.getValue();
                Map source = (Map)params.get("source");
                assemble.sourceColumn = (String)source.get("name");
                Map target = (Map)params.get("target");
                assemble.targetField = Strings.toFieldName((String)((String)target.get("name")));
            }
            return assemble;
        }

        public final Map<String, Object> getParameter() {
            return this.gets(1);
        }

        public final void setParameter(Map<String, ? extends Object> parameters) {
            this.sets(1, parameters, true);
        }

        public final void setParameter(Map<String, ? extends Object> parameters, boolean appended) {
            this.sets(1, parameters, appended);
        }

        public final void setParameter(CharSequence key, Object value) {
            this.set(1, key, value);
        }

        public final Map<String, Object> getFooter() {
            return this.gets(2);
        }

        public final <T> T getFooter(CharSequence key) {
            return this.get(2, key);
        }

        public final void setFooter(Map<String, Object> footers) {
            this.sets(2, footers, true);
        }

        public final void setFooter(Map<String, Object> footers, boolean appended) {
            this.sets(2, footers, appended);
        }

        public final void setFooter(CharSequence key, Object value) {
            this.set(2, key, value);
        }

        public final AuthIdentity getIdentity() {
            return (AuthIdentity)this.getHeader(BaseCommand.CTRL_IDENTITY);
        }

        public final void setIdentity(AuthIdentity identity) {
            this.setHeader(BaseCommand.CTRL_IDENTITY, identity);
        }

        public final String getModule() {
            return (String)this.getHeader(BaseCommand.CTRL_MODULE);
        }

        public final void setModule(String module) {
            this.setHeader(BaseCommand.CTRL_MODULE, module);
        }

        public final String getOperate() {
            return (String)this.getHeader(BaseCommand.CTRL_OPERATE);
        }

        public final void setOperate(String operate) {
            this.setHeader(BaseCommand.CTRL_OPERATE, operate);
        }

        public final Object getPayload() {
            return this.getHeader(BaseCommand.CTRL_PAYLOAD);
        }

        public final void setPayload(Object payload) {
            this.setHeader(BaseCommand.CTRL_PAYLOAD, payload);
        }

        public final Object getResult() {
            return this.getFooter(BaseCommand.DRCT_RESULT);
        }

        public final void setResult(Object result) {
            this.setFooter(BaseCommand.DRCT_RESULT, result);
        }

        private class Assemble {
            Meta meta;
            String sourceColumn;
            String targetField;

            private Assemble() {
            }
        }
    }
}

