/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.isger.brick.auth.AuthCommand;
import net.isger.brick.auth.AuthModule;
import net.isger.brick.bus.BusCommand;
import net.isger.brick.bus.BusModule;
import net.isger.brick.cache.CacheCommand;
import net.isger.brick.cache.CacheModule;
import net.isger.brick.config.ModuleDescribe;
import net.isger.brick.core.Airfone;
import net.isger.brick.core.AirfoneMulticaster;
import net.isger.brick.core.BaseCommand;
import net.isger.brick.core.Command;
import net.isger.brick.core.Context;
import net.isger.brick.core.InternalContext;
import net.isger.brick.core.Module;
import net.isger.brick.core.PlaceholderConfigurer;
import net.isger.brick.core.Preparer;
import net.isger.brick.inject.ConstantStrategy;
import net.isger.brick.inject.Container;
import net.isger.brick.stub.StubCommand;
import net.isger.brick.stub.StubModule;
import net.isger.brick.task.TaskCommand;
import net.isger.brick.task.TaskModule;
import net.isger.brick.util.CommandOperator;
import net.isger.raw.Artifact;
import net.isger.raw.Depository;
import net.isger.raw.Prober;
import net.isger.raw.ProberMulticaster;
import net.isger.util.Asserts;
import net.isger.util.Dependency;
import net.isger.util.Helpers;
import net.isger.util.Manageable;
import net.isger.util.Reflects;
import net.isger.util.Strings;
import net.isger.util.anno.Alias;
import net.isger.util.anno.Ignore;
import net.isger.util.load.BaseLoader;
import net.isger.util.load.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Console
implements Manageable {
    private static final String SUFFIX_MODULE = ".module";
    private static final Logger LOG = LoggerFactory.getLogger(Console.class);
    private volatile transient boolean initialized;
    private transient Loader loader;
    private transient CommandOperator operator = new CommandOperator(this);
    @Ignore(mode=Ignore.Mode.INCLUDE)
    @Alias(value="system")
    private Container container;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    @Alias(value="system")
    private PlaceholderConfigurer configurer;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    @Alias(value="brick.name")
    private String name;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private Prober prober;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private Preparer preparer = new Preparer();
    private transient Dependency dependency = new Dependency();
    private transient Thread hook;
    private transient Airfone airfone;

    public final synchronized void initial() {
        if (this.initialized) {
            return;
        }
        this.hook = new Thread(new Runnable(){

            @Override
            public void run() {
                Console.this.hook = null;
                Console.this.destroy();
            }
        });
        Runtime.getRuntime().addShutdownHook(this.hook);
        Class describeClass = this.container.getInstance(Class.class, "brick.module.describe");
        Asserts.isAssignable(ModuleDescribe.class, (Class)describeClass, (String)"Invalid module describe [%s] in container", (Object[])new Object[]{describeClass});
        this.loader = new BaseLoader(describeClass);
        this.loadKernel();
        this.loadApp();
        try {
            Map<String, Module> modules = this.getModules();
            for (Object node : this.dependency.getNodes()) {
                modules.get(node).initial();
            }
        }
        catch (Throwable e) {
            throw Asserts.state((String)"Failure to initial module", (Object[])new Object[]{e});
        }
        this.initialized = true;
    }

    protected void loadKernel() {
        this.setupModule("cache", new CacheModule(), CacheCommand.class, new Object[0]);
        this.setupModule("auth", new AuthModule(), AuthCommand.class, "cache");
        this.setupModule("task", new TaskModule(), TaskCommand.class, "auth");
        this.setupModule("bus", new BusModule(), BusCommand.class, "task");
        this.setupModule("stub", new StubModule(), StubCommand.class, "auth");
        if (!Strings.matchsIgnoreCase((String)this.name, (String)"brick")) {
            this.loadKernel("brick");
        }
        this.loadKernel(this.name);
    }

    protected final void setupModule(String name, Module module) {
        this.setupModule(name, module, null, new Object[0]);
    }

    protected final void setupModule(String name, Module module, Class<? extends Command> commandClass, Object ... dependencies) {
        if (this.getModule(name) == null) {
            this.addModule(name, module, new Object[0]);
        }
        this.addDependencies(name, dependencies);
        if (commandClass != null) {
            this.addCommand(name, commandClass);
        }
    }

    protected final void loadKernel(String name) {
        Object config;
        for (Artifact artifact : Depository.getArtifacts((String)(name + "-config"), (Prober)this.prober)) {
            config = this.loadResource(artifact);
            if (config instanceof Collection) {
                this.loadConstants((Collection)config);
                continue;
            }
            if (!(config instanceof Map)) continue;
            this.loadConstants((Map)config);
        }
        for (Artifact artifact : Depository.getArtifacts((String)(name + "-kernel"), (Prober)this.prober)) {
            config = this.loadResource(artifact);
            if (config instanceof Collection) {
                this.loadModule((Collection)config);
                continue;
            }
            if (!(config instanceof Map)) continue;
            this.loadModule((Map)config);
        }
    }

    protected final void loadConstants(Collection<?> res) {
        for (Object config : res) {
            if (config instanceof String) {
                config = this.loadResource(config + "-constants");
            }
            if (!(config instanceof Map)) {
                LOG.warn("(!) Skipped invalid constants config {}", config);
                continue;
            }
            this.loadConstants((Map)config);
        }
    }

    protected final void loadConstants(Map<String, Object> config) {
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            Class clazz;
            Class<Object> type;
            Object value = entry.getValue();
            if (value instanceof Map) {
                value = BaseLoader.toLoad((Object)value);
            }
            if (Map.class.isAssignableFrom(type = value.getClass())) {
                type = Map.class;
            } else if (List.class.isAssignableFrom(type)) {
                type = List.class;
            } else if (CharSequence.class.isAssignableFrom(type) && (clazz = Reflects.getClass((Object)value)) != null) {
                ConstantStrategy.set(this.container, Class.class, entry.getKey(), clazz);
            }
            ConstantStrategy.set(this.container, type, entry.getKey(), value);
        }
    }

    protected final void loadModule(Collection<?> res) {
        for (Object config : res) {
            if (config instanceof String) {
                String name = (String)config;
                if (!((config = this.loadResource(name + "-module")) instanceof Map)) {
                    LOG.warn("(!) Skipped invalid module config {}", config);
                    continue;
                }
                HashMap<String, String> params = new HashMap<String, String>((Map)config);
                if (!params.containsKey("name")) {
                    params.put("name", name);
                }
            } else if (!(config instanceof Map)) {
                LOG.warn("(!) Skipped invalid module config {}", config);
                continue;
            }
            this.loadModule((Map)config);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected final void loadModule(Map<String, Object> res) {
        block3: {
            entity = (ModuleDescribe)this.loader.load(res, null);
            name = entity.getName();
            module = entity.getModule();
            if (!Strings.isEmpty((Object)name)) break block3;
            name = Helpers.getAliasName(module.getClass(), (String)"Module$");
            ** GOTO lbl-1000
        }
        if (module == null) {
            this.addDependencies(name, entity.getDependencies());
        } else lbl-1000:
        // 2 sources

        {
            this.addModule(name, module, entity.getDependencies());
        }
        type = entity.getCommand();
        if (type != null) {
            this.addCommand(name, type);
        }
    }

    protected void loadApp() {
        Object config;
        for (Map.Entry<String, Module> entry : this.getModules().entrySet()) {
            for (Artifact artifact : Depository.getArtifacts((String)(this.name + "-" + entry.getKey()), (Prober)this.prober)) {
                config = this.loadResource(artifact);
                if (config == null) continue;
                entry.getValue().load(config, null);
            }
        }
        config = this.loadResource(this.name);
        if (config instanceof Collection) {
            this.loadConfig((Collection)config);
        } else if (config instanceof Map) {
            this.loadConfig((Map)config);
        }
    }

    protected final void loadConfig(Collection<?> res) {
        for (Object config : res) {
            if (config instanceof String) {
                config = this.loadResource((String)config);
            }
            if (!(config instanceof Map)) {
                LOG.warn("(!) Skipped invalid config {}", config);
                continue;
            }
            this.loadConfig((Map)config);
        }
    }

    protected final void loadConfig(Map<String, Object> res) {
        for (Map.Entry<String, Object> entry : res.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            Module module = this.getModule(name);
            if (module != null) {
                module.load(value, null);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.warn("(!) Skipped the unexpected module configuration [{} : {}]", (Object)name, value);
        }
    }

    public Object loadResource(String res) {
        return this.loadResource(Depository.getArtifact((String)res, (Prober)this.prober));
    }

    private Object loadResource(Artifact artifact) {
        Object resource = null;
        if (artifact != null) {
            resource = artifact.transform(Object.class);
            if (this.configurer != null) {
                resource = this.configurer.displace(resource);
            }
        }
        return resource;
    }

    public final boolean hasReady() {
        return this.initialized;
    }

    public final Container getContainer() {
        return this.container;
    }

    public final Map<String, Module> getModules() {
        return this.container.getInstances(Module.class);
    }

    public final Module getModule() {
        return (Module)((InternalContext)Context.getAction()).getInternal("brick.core.module");
    }

    public final Module getModule(String name) {
        return this.container.getInstance(Module.class, name);
    }

    public final Module getModule(BaseCommand command) {
        String name;
        Module module;
        Class<?> type = command.getClass();
        if (type != BaseCommand.class && (module = this.getModule(type)) != null) {
            return module;
        }
        module = this.getModule(((Object)((Object)command.getSource())).getClass());
        if (module == null && Strings.isNotEmpty((Object)(name = command.getModule()))) {
            module = this.getModule(name);
        }
        return module;
    }

    public final Module getModule(Class<?> commandType) {
        if (!Command.class.isAssignableFrom(commandType) || Command.class.equals(commandType)) {
            return null;
        }
        String name = this.container.getInstance(String.class, commandType.getName() + SUFFIX_MODULE);
        if (Strings.isEmpty((Object)name)) {
            return this.getModule(commandType.getSuperclass());
        }
        return this.getModule(name);
    }

    public final String getModuleName(BaseCommand command) {
        String moduleName;
        Class<?> type = command.getClass();
        if (type != BaseCommand.class && (moduleName = this.getModuleName(type)) != null) {
            return moduleName;
        }
        moduleName = this.getModuleName(((Object)((Object)command.getSource())).getClass());
        if (moduleName == null) {
            moduleName = command.getModule();
        }
        return moduleName;
    }

    public final String getModuleName(Class<?> type) {
        if (!Command.class.isAssignableFrom(type) || Command.class.equals(type)) {
            return null;
        }
        String name = this.container.getInstance(String.class, type.getName() + SUFFIX_MODULE);
        if (name == null) {
            return this.getModuleName(type.getSuperclass());
        }
        return name;
    }

    public final void addProber(Prober prober) {
        this.prober = ProberMulticaster.add((Prober)this.prober, (Prober)prober);
    }

    public final void addDependencies(String name, Object ... dependencies) {
        this.addDependencies(name, Arrays.asList(dependencies));
    }

    public final void addDependencies(String name, List<Object> dependencies) {
        this.dependency.addNode((Object)name, dependencies);
    }

    public final void addModule(String name, Module module, Object ... dependencies) {
        this.addModule(name, module, Arrays.asList(dependencies));
    }

    public final void addModule(String name, Module module, List<Object> dependencies) {
        if (LOG.isDebugEnabled()) {
            LOG.info("Binding [{}] module [{}]", (Object)name, (Object)module);
        }
        if ((module = ConstantStrategy.set(this.container, Module.class, name, module)) != null) {
            LOG.warn("(!) Discard [{}] module [{}]", (Object)name, (Object)module);
        }
        this.addDependencies(name, dependencies);
    }

    public final void addCommand(String name, Class<? extends Command> type) {
        String oldName;
        String typeName = type.getName();
        if (LOG.isDebugEnabled()) {
            LOG.info("Binding [{}] command [{}]", (Object)name, (Object)typeName);
        }
        if (name.equals(oldName = ConstantStrategy.set(this.container, String.class, typeName + SUFFIX_MODULE, name))) {
            LOG.warn("(!) Discard [{}] command [{}]", (Object)oldName, (Object)typeName);
        }
    }

    public void addAirfone(Airfone airfone) {
        this.airfone = AirfoneMulticaster.add(this.airfone, airfone);
    }

    public void remove(Airfone airfone) {
        this.airfone = AirfoneMulticaster.remove(this.airfone, airfone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(Command command) {
        this.preparer.prepare(command);
        InternalContext context = (InternalContext)Context.getAction();
        try {
            BaseCommand cmd = context.getCommand();
            Module module = this.getModule(cmd);
            if (module == null) {
                this.operator.operate(cmd);
            } else {
                context.setInternal("brick.core.module", module);
                module.execute(cmd);
            }
        }
        finally {
            this.preparer.cleanup();
        }
    }

    public final synchronized void destroy() {
        if (!this.initialized) {
            return;
        }
        if (this.airfone != null) {
            while (!this.airfone.ack(1)) {
                Helpers.sleep((long)200L);
            }
        }
        Map<String, Module> modules = this.getModules();
        LinkedList nodes = new LinkedList(this.dependency.getNodes());
        Collections.reverse(nodes);
        for (Object node : nodes) {
            modules.get(node).destroy();
        }
        this.container.destroy();
        if (this.hook != null) {
            Runtime.getRuntime().removeShutdownHook(this.hook);
            this.hook = null;
        }
        this.initialized = false;
    }
}

