/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.isger.brick.auth.AuthPreparer;
import net.isger.brick.config.ModuleDescribe;
import net.isger.brick.core.Console;
import net.isger.brick.core.Preparer;
import net.isger.brick.inject.Container;
import net.isger.brick.inject.ContainerBuilder;
import net.isger.brick.inject.ContainerProvider;
import net.isger.brick.inject.ContainerProviderFactory;
import net.isger.brick.inject.InjectConductor;
import net.isger.brick.inject.InjectReserver;
import net.isger.brick.inject.Key;
import net.isger.raw.Prober;
import net.isger.raw.SuffixProber;
import net.isger.util.Asserts;
import net.isger.util.Callable;
import net.isger.util.Files;
import net.isger.util.Helpers;
import net.isger.util.Reflects;
import net.isger.util.Strings;
import net.isger.util.anno.Alias;
import net.isger.util.anno.Ignore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConsoleManager.class);
    private final Lock lock = new ReentrantLock();
    private final String name;
    private final String path;
    private final List<ContainerProvider> providers;
    private volatile transient boolean isChanged;
    private volatile transient Container bootstrap;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    @Alias(value="brick.reload")
    private boolean isReload;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    @Alias(value="system")
    private Console console;

    public ConsoleManager() {
        this("brick");
    }

    public ConsoleManager(String name) {
        this(name, null);
    }

    public ConsoleManager(String name, String path) {
        this.name = Strings.empty((Object)name, (String)"brick");
        this.path = Strings.empty((Object)path, (String)Files.getBasePath());
        this.providers = new ArrayList<ContainerProvider>();
        this.loadContainerProviders();
    }

    private void loadContainerProviders() {
        this.clearContainerProviders();
        ServiceLoader<ContainerProvider> loader = ServiceLoader.load(ContainerProvider.class, Reflects.getClassLoader((Object)this));
        Iterator<ContainerProvider> iterator = loader.iterator();
        while (iterator.hasNext()) {
            this.addContainerProvider(iterator.next());
        }
    }

    public final List<ContainerProvider> getContainerProviders() {
        return new ArrayList<ContainerProvider>(this.providers);
    }

    public final void setContainerProviders(List<ContainerProvider> providers) {
        this.loadContainerProviders();
        if (providers != null) {
            for (ContainerProvider provider : providers) {
                this.addContainerProvider(provider);
            }
        }
    }

    public final void addContainerProvider(ContainerProvider provider) {
        this.lock.lock();
        try {
            if (provider != null && !this.providers.contains(provider)) {
                this.providers.add(provider);
                this.isChanged = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public final void clearContainerProviders() {
        this.lock.lock();
        try {
            this.providers.clear();
            this.isChanged = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public final synchronized void load() {
        List<ContainerProvider> providers = this.getContainerProviders();
        if (this.console == null) {
            this.load(providers);
        } else if (this.isChanged || this.isReload) {
            if (this.isReload(providers)) {
                this.console.destroy();
                this.console = null;
                this.load(providers);
            }
            this.isChanged = false;
        }
    }

    public boolean isReload() {
        return this.isReload(this.getContainerProviders());
    }

    private boolean isReload(List<ContainerProvider> providers) {
        boolean isReload = false;
        for (ContainerProvider provider : providers) {
            if (!provider.isReload()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.info("Detected module provider [%s] needs to be reloaded", (Object)provider);
            }
            isReload = true;
            break;
        }
        return isReload;
    }

    private void load(List<ContainerProvider> providers) {
        if (this.bootstrap != null) {
            this.bootstrap.destroy();
            this.bootstrap = null;
        }
        this.bootstrap = this.createBootstrap();
        this.bootstrap.initial();
        Container container = this.createContainer(Helpers.sort(new ArrayList<ContainerProvider>(providers)));
        container.initial();
        container.inject(this);
        Asserts.throwState((this.console != null ? 1 : 0) != 0, (String)"The container does not provide effective supply for console", (Object[])new Object[0]);
        this.console.initial();
    }

    protected Container createBootstrap() {
        ContainerBuilder builder = new ContainerBuilder();
        builder.constant("brick.name", this.name);
        builder.constant("brick.path", this.path);
        builder.constant("brick.reload", Boolean.FALSE);
        ContainerProviderFactory.getProvider().register(builder);
        return builder.create("bootstrap");
    }

    private Container createContainer(List<ContainerProvider> providers) {
        ContainerBuilder builder = this.createBuilder();
        for (ContainerProvider provider : providers) {
            this.bootstrap.inject(provider);
            provider.register(builder);
        }
        builder.constant(InjectReserver.class, "bootstrap", new InjectReserver(){

            @Override
            public boolean contains(Key<?> key) {
                return ConsoleManager.this.bootstrap.contains(key.getType(), key.getName());
            }

            @Override
            public <T> T alternate(Key<T> key, InjectConductor conductor) {
                return ConsoleManager.this.bootstrap.getInstance(key.getType(), key.getName(), conductor);
            }
        });
        return builder.create("system");
    }

    protected ContainerBuilder createBuilder() {
        ContainerBuilder builder = new ContainerBuilder();
        builder.factory(Prober.class, new Callable<Prober>(){

            public Prober call(Object ... args) {
                return SuffixProber.create((String[])new String[]{((Container)args[0]).getInstance(String.class, "brick.raw")});
            }
        });
        builder.factory(Preparer.class, AuthPreparer.class);
        builder.constant("brick.module.describe", ModuleDescribe.class);
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Console getConsole() {
        ConsoleManager consoleManager = this;
        synchronized (consoleManager) {
            if (this.console == null) {
                this.load(this.getContainerProviders());
            }
        }
        return this.console;
    }
}

