/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.core;

import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import net.isger.brick.core.BaseCommand;
import net.isger.brick.core.Console;
import net.isger.util.anno.Ignore;

@Ignore
public abstract class Context {
    static final ThreadLocal<Context> ACTION = new ThreadLocal();
    private Map<String, Object> context = new ConcurrentHashMap<String, Object>();
    private Deque<BaseCommand> reals = new LinkedBlockingDeque<BaseCommand>();

    protected Context() {
        this(null);
    }

    protected Context(Map<String, Object> contextMap) {
        if (contextMap != null) {
            this.context.putAll(contextMap);
        }
    }

    public Map<String, Object> getContextMap() {
        return Collections.unmodifiableMap(this.context);
    }

    public Object get(String key) {
        return this.context.get(key);
    }

    public void set(String key, Object value) {
        if (value == null) {
            this.context.remove(key);
        } else {
            this.context.put(key, value);
        }
    }

    public void clear() {
        this.context.clear();
    }

    public abstract Console getConsole();

    public BaseCommand getCommand() {
        return null;
    }

    public BaseCommand newCommand() {
        BaseCommand cmd = this.getCommand();
        if (cmd != null) {
            cmd = cmd.clone();
        }
        return cmd;
    }

    public BaseCommand mockCommand() {
        BaseCommand cmd = this.getCommand();
        if (cmd != null) {
            this.reals.push(cmd);
            cmd = cmd.clone();
        }
        return cmd;
    }

    public BaseCommand realCommand() {
        BaseCommand cmd = this.reals.size() > 0 ? this.reals.pop() : this.getCommand();
        return cmd;
    }

    public static Context getAction() {
        return ACTION.get();
    }

    public static void setAction(Context context) {
        ACTION.set(context);
    }

    public static Object getAction(String key) {
        return Context.getAction().get(key);
    }

    public static void setAction(String key, Object value) {
        Context.getAction().set(key, value);
    }
}

