/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.core;

import net.isger.brick.cache.CacheModule;
import net.isger.brick.core.BaseCommand;
import net.isger.brick.core.Console;
import net.isger.brick.core.Context;
import net.isger.brick.core.Gate;
import net.isger.brick.core.GateCommand;
import net.isger.brick.core.GateModule;
import net.isger.brick.core.Module;
import net.isger.util.Callable;

public class CoreHelper {
    private static final ThreadLocal<Console> CONSOLE = new ThreadLocal();
    private static final Callable<Object> CALLABLE_CONSOLE = new Callable<Object>(){

        public Object call(Object ... args) {
            BaseCommand cmd = (BaseCommand)args[0];
            CoreHelper.getConsole().execute(cmd);
            return cmd.getResult();
        }
    };
    private static final Callable<Object> CALLABLE_MODULE = new Callable<Object>(){

        public Object call(Object ... args) {
            BaseCommand cmd = (BaseCommand)args[0];
            CoreHelper.getModule().execute(cmd);
            return cmd.getResult();
        }
    };
    private static final Callable<Object> CALLABLE_GATE = new Callable<Object>(){

        public Object call(Object ... args) {
            GateCommand cmd = (GateCommand)args[0];
            CoreHelper.getGate().operate(cmd);
            return cmd.getResult();
        }
    };

    protected CoreHelper() {
    }

    protected static Object to(BaseCommand cmd, Callable<Object> callable) {
        return callable.call(new Object[]{cmd});
    }

    public static Object toConsole(BaseCommand cmd) {
        return CoreHelper.to(cmd, CALLABLE_CONSOLE);
    }

    public static Object toModule(BaseCommand cmd) {
        return CoreHelper.to(cmd, CALLABLE_MODULE);
    }

    public static Object toGate(GateCommand cmd) {
        return CoreHelper.to(cmd, CALLABLE_GATE);
    }

    public static Console getConsole() {
        Context context = Context.getAction();
        Console console = context == null ? CONSOLE.get() : context.getConsole();
        return console;
    }

    public static Module getModule() {
        return CoreHelper.getConsole().getModule();
    }

    public static Gate getGate() {
        return ((GateModule)CoreHelper.getModule()).getGate();
    }

    public static CacheModule getCacheModule() {
        return (CacheModule)CoreHelper.getConsole().getModule("cache");
    }

    public static void setConsole(Console console) {
        CONSOLE.set(console);
    }
}

