/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.isger.brick.core.AbstractModule;
import net.isger.brick.core.BaseCommand;
import net.isger.brick.core.BaseGate;
import net.isger.brick.core.Gate;
import net.isger.brick.core.GateCommand;
import net.isger.brick.inject.ConstantStrategy;
import net.isger.util.Asserts;
import net.isger.util.Helpers;
import net.isger.util.Strings;
import net.isger.util.anno.Ignore;
import net.isger.util.reflect.ClassAssembler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GateModule
extends AbstractModule {
    private static final String GATE = "gate";
    private static final Logger LOG = LoggerFactory.getLogger(GateModule.class);

    public Class<? extends Gate> getTargetClass() {
        return Gate.class;
    }

    public Class<? extends Gate> getImplementClass() {
        Class<?> implClass = this.getImplementClass(GATE, null);
        if (implClass == null) {
            implClass = super.getImplementClass();
        }
        return implClass;
    }

    protected Class<? extends Gate> getBaseClass() {
        return BaseGate.class;
    }

    @Override
    protected List<Gate> create(Class<?> clazz, Map<String, Object> res, ClassAssembler assembler) {
        Map<String, Gate> gates = this.createGates(res, assembler);
        this.setGates(gates);
        return new ArrayList<Gate>(gates.values());
    }

    @Override
    protected Gate create() {
        return (Gate)super.create();
    }

    protected Map<String, Gate> createGates(Map<String, Object> res, ClassAssembler assembler) {
        HashMap<String, Gate> result = new HashMap<String, Gate>();
        for (Map.Entry<String, Object> entry : res.entrySet()) {
            Object resource;
            String name = entry.getKey();
            Object config = entry.getValue();
            if (config instanceof String && (resource = this.console.loadResource((String)config)) != null) {
                config = resource;
            }
            if (!(config instanceof Map)) {
                LOG.warn("(!) Skipped the unexpected gate configuration [{}]", config);
                continue;
            }
            result.put(name, this.createGate((Map)config, assembler));
        }
        return result;
    }

    protected Gate createGate(Map<String, Object> res, ClassAssembler assembler) {
        return this.createGate(this.getImplementClass(res), res, assembler);
    }

    protected Gate createGate(Class<? extends Gate> clazz, Map<String, Object> config, ClassAssembler assembler) {
        return (Gate)super.create(clazz, config, assembler);
    }

    protected Map<String, Gate> setGates(Map<String, Gate> gates) {
        HashMap<String, Gate> result = new HashMap<String, Gate>();
        for (Map.Entry<String, Gate> entry : gates.entrySet()) {
            String name = entry.getKey();
            Gate gate = this.setGate(name, entry.getValue());
            if (gate == null) continue;
            result.put(name, gate);
        }
        return result;
    }

    protected Gate setGate(String name, Gate gate) {
        Asserts.throwArgument((Strings.isNotEmpty((Object)name) && gate != null ? 1 : 0) != 0, (String)"The gate cannot be null or empty", (Object[])new Object[0]);
        if (LOG.isDebugEnabled()) {
            LOG.info("Binding [{}] gate [{}] for the module [{}]", new Object[]{name, gate, this});
        }
        return this.set(name, gate.getClass(), gate);
    }

    private Gate set(String name, Class<? extends Gate> gateType, Gate gate) {
        Class<? extends Gate> type = this.getTargetClass();
        if (type != gateType) {
            ConstantStrategy.set(this.container, gateType, name, gate);
        }
        if ((gate = ConstantStrategy.set(this.container, type, name, gate)) != null) {
            LOG.warn("(!) Discard [{}] gate [{}] in the module [{}]", new Object[]{name, gate, this});
        }
        return gate;
    }

    public final Map<String, Gate> getGates() {
        return this.container.getInstances(this.getTargetClass());
    }

    public final Gate getGate() {
        return (Gate)this.getInternal("brick.core.gate");
    }

    public Gate getGate(String name) {
        return this.container.getInstance(this.getTargetClass(), name);
    }

    protected Gate delGate(String name) {
        Gate gate = this.getGate(name);
        if (gate == null) {
            return null;
        }
        return this.set(name, gate.getClass(), null);
    }

    @Override
    public void initial() {
        super.initial();
        for (Map.Entry entry : Helpers.sortByValue(this.getGates().entrySet())) {
            this.initial((String)entry.getKey(), (Gate)entry.getValue());
        }
    }

    protected void initial(String domain, Gate gate) {
        gate.initial();
    }

    @Override
    public final void execute(BaseCommand cmd) {
        GateCommand gcmd = cmd instanceof GateCommand ? (GateCommand)cmd : GateCommand.cast(cmd);
        String domain = gcmd.getDomain();
        if (domain == null) {
            super.execute(gcmd);
        } else {
            Gate gate = this.getGate(domain);
            Asserts.isNotNull((Object)gate, (String)"Unfound the specified domain [%s] in the module [%s], Check whether it is configured in the brick configuration file", (Object[])new Object[]{domain, this.getClass().getName()});
            this.setInternal("brick.core.gate", gate);
            gate.operate(gcmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(mode=Ignore.Mode.INCLUDE)
    public void create(GateCommand cmd) {
        Map<String, Gate> gates = this.createGates(cmd.getParameter(), null);
        if (!cmd.getTransient()) {
            this.setGates(gates);
        }
        for (Map.Entry<String, Gate> entry : gates.entrySet()) {
            Gate gate = entry.getValue();
            this.container.inject(gate);
            GateCommand.mockAction();
            try {
                gate.initial();
            }
            finally {
                GateCommand.realAction();
            }
        }
        cmd.setResult(gates);
    }

    @Ignore(mode=Ignore.Mode.INCLUDE)
    public void remove(GateCommand cmd) {
        Map<String, Object> params = cmd.getParameter();
        HashMap<String, Gate> result = new HashMap<String, Gate>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String name = entry.getKey();
            Gate gate = this.delGate(name);
            if (gate == null) continue;
            result.put(name, gate);
        }
        cmd.setResult(result);
    }

    @Override
    public void destroy() {
        for (Map.Entry<String, Gate> entry : this.getGates().entrySet()) {
            this.destroy(entry.getKey(), entry.getValue());
        }
        super.destroy();
    }

    protected void destroy(String key, Gate gate) {
        gate.destroy();
    }
}

