/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.inject;

import java.util.concurrent.Callable;
import net.isger.brick.inject.Container;
import net.isger.brick.inject.Strategy;
import net.isger.util.reflect.Converter;

public class ConstantStrategy
implements Strategy {
    private Object instance;

    protected ConstantStrategy(Object instance) {
        this.instance = instance;
    }

    @Override
    public <T> T find(Class<T> type, String name, Callable<? extends T> callable) throws Exception {
        return (T)this.getInstance();
    }

    public Object getInstance() {
        return this.instance;
    }

    public void setInstance(Object instance) {
        this.instance = instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T set(Container container, Class<? extends T> type, String name, T instance) {
        Object oldInstance = null;
        Strategy strategy = container.getStrategy(type, name);
        if (strategy != null) {
            try {
                oldInstance = strategy.find(type, name, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (strategy instanceof ConstantStrategy) {
                ((ConstantStrategy)strategy).setInstance(instance);
                return (T)Converter.convert(type, oldInstance);
            }
        }
        container.setStrategy(type, name, new ConstantStrategy(instance));
        return (T)Converter.convert(type, oldInstance);
    }
}

