/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.inject;

import java.util.HashMap;
import java.util.Map;
import net.isger.brick.inject.Container;
import net.isger.brick.inject.InternalContainer;
import net.isger.brick.inject.InternalContext;
import net.isger.brick.inject.InternalFactory;
import net.isger.brick.inject.Key;
import net.isger.brick.inject.Scope;
import net.isger.util.Asserts;
import net.isger.util.Callable;
import net.isger.util.Reflects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContainerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerBuilder.class);
    private final Map<Key<?>, InternalFactory<?>> factories = new HashMap();
    private boolean duplicated = true;

    public void setDuplicates(boolean duplicates) {
        this.duplicated = duplicates;
    }

    public <T> ContainerBuilder factory(Class<T> type, String name, final Callable<T> callable, Scope scope) {
        return this.factory(Key.newInstance(type, name), new InternalFactory<T>(){

            @Override
            public T create(InternalContext context) {
                return callable.call(new Object[]{context.container});
            }
        }, scope == null ? Scope.get(type) : scope);
    }

    public <T> ContainerBuilder factory(Class<T> type, Callable<T> callable) {
        return this.factory(type, "default", callable, null);
    }

    public <T> ContainerBuilder factory(Class<T> type, Callable<T> callable, Scope scope) {
        return this.factory(type, "default", callable, scope);
    }

    public <T> ContainerBuilder factory(Class<T> type, String name, Callable<T> callable) {
        return this.factory(type, name, callable, null);
    }

    public <T> ContainerBuilder factory(Class<T> type, String name, final Class<? extends T> implementation, Scope scope) {
        return this.factory(Key.newInstance(type, name), new InternalFactory<T>(){

            @Override
            public T create(InternalContext context) {
                return Reflects.newInstance((Class)implementation);
            }
        }, scope == null ? Scope.get(implementation) : scope);
    }

    public <T> ContainerBuilder factory(Class<T> type) {
        return this.factory(type, "default", type, null);
    }

    public <T> ContainerBuilder factory(Class<T> type, Scope scope) {
        return this.factory(type, "default", type, scope);
    }

    public <T> ContainerBuilder factory(Class<T> type, Class<? extends T> implementation) {
        return this.factory(type, "default", implementation, null);
    }

    public <T> ContainerBuilder factory(Class<T> type, Class<? extends T> implementation, Scope scope) {
        return this.factory(type, "default", implementation, scope);
    }

    public <T> ContainerBuilder factory(Class<T> type, String name) {
        return this.factory(type, name, type, null);
    }

    public <T> ContainerBuilder factory(Class<T> type, String name, Class<? extends T> implementation) {
        return this.factory(type, name, implementation, null);
    }

    public <T> ContainerBuilder factory(Class<T> type, String name, Scope scope) {
        return this.factory(type, name, type, scope);
    }

    public <T> ContainerBuilder constant(Class<T> type, String name, final T value) {
        return this.factory(Key.newInstance(type, name), new InternalFactory<T>(){

            @Override
            public T create(InternalContext context) {
                return value;
            }
        }, Scope.DEFAULT);
    }

    public ContainerBuilder constant(String name, Object value) {
        return this.constant(value.getClass(), name, value);
    }

    private <T> ContainerBuilder factory(Key<T> key, InternalFactory<? extends T> factory, Scope scope) {
        if (this.factories.containsKey(key)) {
            Asserts.throwState((boolean)this.duplicated, (String)"Dependency mapping for [%s] already exists", (Object[])new Object[]{key});
            LOG.warn("(!) Dependency mapping for [{}] already exists", key);
        }
        this.factories.put(key, scope.factory(key.getType(), key.getName(), factory));
        return this;
    }

    public Container create(String name) {
        return new InternalContainer(name, this.factories);
    }
}

