/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.inject;

import net.isger.brick.bind.BrickCoreBinder;
import net.isger.brick.inject.ContainerBuilder;
import net.isger.brick.inject.ContainerProvider;
import net.isger.util.Asserts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerProviderFactory {
    private static final String BINDER = "net.isger.brick.bind.BrickCoreBinder";
    private static final int SUCCESS = 1;
    private static final int UNKNOWN = 2;
    private static final int FAILURE = 3;
    private static final Logger LOG = LoggerFactory.getLogger(ContainerProviderFactory.class);
    private static final ContainerProvider NOP_PROVIDER = new ContainerProvider(){

        @Override
        public boolean isReload() {
            return false;
        }

        @Override
        public void register(ContainerBuilder builder) {
        }
    };
    private static int initialized;

    private ContainerProviderFactory() {
    }

    private static void bind() {
        try {
            LOG.info("Complete static binder [{}]", (Object)BrickCoreBinder.getBinder());
            initialized = 1;
            return;
        }
        catch (NoClassDefFoundError e) {
            String msg = e.getMessage();
            if (msg == null || msg.indexOf(BINDER) == -1 && msg.indexOf(BINDER.replaceAll("[.]", "/")) == -1) {
                initialized = 3;
                throw e;
            }
            if (LOG.isDebugEnabled()) {
                LOG.warn("(!) Failed to load class [{}]", (Object)BINDER);
                LOG.warn("(!) Defaulting to no-operation (NOP) provider implementation");
            }
            initialized = 2;
        }
        catch (Exception e) {
            initialized = 3;
            throw Asserts.state((String)"Unexpected bind failure", (Object[])new Object[]{e.getCause()});
        }
    }

    public static ContainerProvider getProvider() {
        ContainerProvider provider;
        switch (initialized) {
            case 1: {
                provider = BrickCoreBinder.getBinder().getProvider();
                if (provider != null) break;
                throw Asserts.state((String)"The bound provider cannot be null", (Object[])new Object[0]);
            }
            default: {
                provider = NOP_PROVIDER;
            }
        }
        return provider;
    }

    static {
        ContainerProviderFactory.bind();
    }
}

