/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.inject;

import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.isger.brick.inject.Container;
import net.isger.brick.inject.InjectConductor;
import net.isger.brick.inject.InjectMulticaster;
import net.isger.brick.inject.InjectReserver;
import net.isger.brick.inject.InternalContext;
import net.isger.brick.inject.InternalFactory;
import net.isger.brick.inject.Key;
import net.isger.brick.inject.Strategy;
import net.isger.brick.util.anno.Collect;
import net.isger.brick.util.anno.Digest;
import net.isger.util.Asserts;
import net.isger.util.Callable;
import net.isger.util.Helpers;
import net.isger.util.Reflects;
import net.isger.util.Strings;
import net.isger.util.reflect.BoundField;
import net.isger.util.reflect.BoundMethod;

class InternalContainer
implements Container {
    final String name;
    final Map<Key<?>, InternalFactory<?>> factories;
    final Map<Key<?>, Strategy> strategies;
    transient InjectReserver reserver;
    private volatile ThreadLocal<InternalContext[]> context;

    InternalContainer(String name, Map<Key<?>, InternalFactory<?>> factories) {
        this.name = name;
        this.factories = new ConcurrentHashMap(factories);
        this.strategies = new ConcurrentHashMap();
        this.reserver = new InjectReserver(){

            @Override
            public boolean contains(Key<?> key) {
                return false;
            }

            @Override
            public <T> T alternate(Key<T> key, InjectConductor conductor) {
                return null;
            }
        };
        this.context = new ThreadLocal<InternalContext[]>(){

            @Override
            protected InternalContext[] initialValue() {
                return new InternalContext[1];
            }
        };
    }

    public void initial() {
        this.factories.put(Key.newInstance(Container.class, this.name), new InternalFactory<Container>(){

            @Override
            public Container create(InternalContext context) {
                return InternalContainer.this;
            }
        });
        for (InjectReserver reserver : Helpers.sort(new ArrayList<InjectReserver>(this.getInstances(InjectReserver.class).values()))) {
            this.reserver = InjectMulticaster.addInternal(this.reserver, reserver);
        }
    }

    @Override
    public boolean contains(Class<?> type) {
        return this.contains(type, "default");
    }

    @Override
    public boolean contains(Class<?> type, String name) {
        boolean result;
        block3: {
            result = this.contains(Key.newInstance(type, name));
            if (!result) {
                Class[] interfaceClasses;
                for (Class<?> superClass = type.getSuperclass(); superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
                    if (!this.contains(Key.newInstance(superClass, name))) continue;
                    result = true;
                    break block3;
                }
                for (Class interfaceClass : interfaceClasses = Reflects.getInterfaces(type)) {
                    if (!this.contains(Key.newInstance(interfaceClass, name))) continue;
                    result = true;
                    break block3;
                }
                result = this.getInstances(type).containsKey(name);
            }
        }
        return result;
    }

    private boolean contains(Key<?> key) {
        return this.factories.containsKey(key) || this.strategies.containsKey(key) || this.reserver.contains(key);
    }

    @Override
    public Strategy getStrategy(Class<?> type) {
        return this.getStrategy(type, "default");
    }

    @Override
    public Strategy getStrategy(Class<?> type, String name) {
        return this.strategies.get(Key.newInstance(type, name));
    }

    @Override
    public Strategy setStrategy(Class<?> type, Strategy strategy) {
        return this.setStrategy(type, "default", strategy);
    }

    @Override
    public Strategy setStrategy(Class<?> type, String name, Strategy strategy) {
        Key<?> key = Key.newInstance(type, name);
        if (strategy == null) {
            return this.strategies.remove(key);
        }
        return this.strategies.put(key, strategy);
    }

    @Override
    public <T> T getInstance(Class<T> type) {
        return this.getInstance(type, "default");
    }

    @Override
    public <T> T getInstance(Class<T> type, String name) {
        return this.getInstance(type, name, null);
    }

    @Override
    public <T> T getInstance(final Class<T> type, final String name, InjectConductor conductor) {
        return this.call(new Callable<T>(){

            public T call(Object ... args) {
                Object instance;
                block6: {
                    instance = InternalContainer.this.getInstance(Key.newInstance(type, name), (InternalContext)args[0]);
                    if (instance == null) {
                        Class[] interfaces;
                        for (Class superclass = type.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
                            instance = InternalContainer.this.getInstance(Key.newInstance(superclass, name), (InternalContext)args[0]);
                            if (instance == null || !type.isInstance(instance)) {
                                continue;
                            }
                            break block6;
                        }
                        for (Class interfaceClass : interfaces = Reflects.getInterfaces((Class)type)) {
                            instance = InternalContainer.this.getInstance(Key.newInstance(interfaceClass, name), (InternalContext)args[0]);
                            if (instance == null || !type.isInstance(instance)) {
                                continue;
                            }
                            break block6;
                        }
                        if (type != Object.class || !"default".equals(name)) {
                            instance = InternalContainer.this.getInstances(type).get(name);
                        }
                    }
                }
                return instance;
            }
        }, conductor);
    }

    private <T> T getInstance(Key<T> key, final InternalContext context) {
        T result = null;
        InternalFactory<?> factory = this.factories.get(key);
        if (factory == null) {
            if (this.strategies.containsKey(key)) {
                try {
                    result = this.strategies.get(key).find(key.getType(), key.getName(), null);
                }
                catch (Exception e) {
                    throw Asserts.state((String)e.getMessage(), (Object[])new Object[]{e.getCause()});
                }
            }
        } else {
            result = (T)factory.create(context);
        }
        if (result == null) {
            result = this.reserver.alternate(key, new InjectConductor(){

                @Override
                public boolean hasInject(Object instance) {
                    return context.hasInject(instance);
                }
            });
        }
        this.inject(key, result, context);
        return result;
    }

    @Override
    public <T> Map<String, T> getInstances(Class<T> type) {
        return this.getInstances(type, (InjectConductor)null);
    }

    @Override
    public <T> Map<String, T> getInstances(final Class<T> type, InjectConductor conductor) {
        return (Map)this.call(new Callable<Map<String, T>>(){

            public Map<String, T> call(Object ... args) {
                return InternalContainer.this.getInstances(type, (InternalContext)args[0]);
            }
        }, conductor);
    }

    private <T> Map<String, T> getInstances(Class<T> type, InternalContext context) {
        Object instance;
        Key<?> key;
        HashMap instances = new HashMap();
        for (Map.Entry<Key<?>, Strategy> entry : this.strategies.entrySet()) {
            Strategy strategy;
            key = entry.getKey();
            if (!type.isAssignableFrom(key.type) || (strategy = entry.getValue()) == null) continue;
            try {
                instance = strategy.find(key.type, key.name, null);
                if (instance == null) continue;
                this.inject(key, instance, context);
                instances.put(key.getName(), instance);
            }
            catch (Exception e) {
                throw Asserts.state((String)e.getMessage(), (Object[])new Object[]{e.getCause()});
            }
        }
        for (Map.Entry<Key<?>, InternalFactory<?>> entry : this.factories.entrySet()) {
            InternalFactory<?> factory;
            key = entry.getKey();
            if (!type.isAssignableFrom(key.type) || (factory = entry.getValue()) == null) continue;
            try {
                instance = factory.create(context);
                if (instance == null) continue;
                this.inject(key, instance, context);
                instances.put(key.getName(), instance);
            }
            catch (Exception e) {
                throw Asserts.state((String)e.getMessage(), (Object[])new Object[]{e.getCause()});
            }
        }
        return instances;
    }

    @Override
    public <T> T inject(final T instance) {
        return this.call(new Callable<T>(){

            public T call(Object ... args) {
                InternalContainer.this.inject(Key.newInstance(instance.getClass(), "default"), instance, (InternalContext)args[0]);
                return instance;
            }
        }, null);
    }

    private void inject(Key<?> key, Object instance, InternalContext context) {
        if (context.hasInject(instance)) {
            return;
        }
        context.instances.add(instance);
        Class<?> instanceClass = instance.getClass();
        for (List fields : Reflects.getBoundFields(instanceClass).values()) {
            for (BoundField field : fields) {
                Object infect;
                String fieldName;
                Class<?> fieldType;
                if (!this.setInstance(instance, field, fieldType = field.getField().getType(), fieldName = Strings.empty((Object)field.getAlias(), (String)"default"))) {
                    fieldName = field.getName();
                    this.setInstance(instance, field, fieldType, fieldName);
                }
                if (!field.isInject() || (infect = field.getValue(instance)) == null) continue;
                this.inject(Key.newInstance(fieldType, fieldName), infect, context);
            }
        }
        List methods = Reflects.getBoundMethods(instanceClass, Digest.class, (boolean)false);
        Collections.sort(methods, new Comparator<BoundMethod>(){

            @Override
            public int compare(BoundMethod prev, BoundMethod next) {
                return ((Digest)prev.getAnnotation(Digest.class)).value() - ((Digest)next.getAnnotation(Digest.class)).value();
            }
        });
        for (BoundMethod method : methods) {
            Digest digest = (Digest)method.getAnnotation(Digest.class);
            if (digest.stage() != Digest.Stage.INITIAL) continue;
            method.invoke(instance, new Object[0]);
        }
    }

    private boolean setInstance(Object instance, BoundField field, Class<?> fieldType, String fieldName) {
        boolean result;
        block6: {
            Object value;
            block9: {
                Type[] actualTypes;
                block8: {
                    Type genericType;
                    block7: {
                        if (field.getField().getAnnotation(Collect.class) == null) break block6;
                        genericType = field.getField().getGenericType();
                        if (!fieldType.isArray()) break block7;
                        Class<?> componentType = fieldType.getComponentType();
                        Map<String, ?> instances = this.getInstances(componentType);
                        int size = instances.size();
                        if (size > 0) {
                            Object value2 = Array.newInstance(componentType, size);
                            System.arraycopy(instances.values().toArray(), 0, value2, 0, size);
                            field.setValue(instance, value2);
                            return true;
                        }
                        break block6;
                    }
                    if (!(genericType instanceof ParameterizedType)) break block6;
                    ParameterizedType paramType = (ParameterizedType)genericType;
                    actualTypes = paramType.getActualTypeArguments();
                    if (!fieldType.isAssignableFrom(ArrayList.class)) break block8;
                    Map instances = this.getInstances((Class)actualTypes[0]);
                    value = new ArrayList(instances.values());
                    break block9;
                }
                if (!fieldType.isAssignableFrom(HashMap.class)) break block6;
                value = this.getInstances((Class)actualTypes[1]);
            }
            field.setValue(instance, value);
            return true;
        }
        if (result = this.contains(fieldType, fieldName)) {
            field.setValue(instance, this.getInstance(fieldType, fieldName));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T call(Callable<T> callable, InjectConductor conductor) {
        InternalContext[] reference = this.context.get();
        if (reference[0] == null) {
            reference[0] = new InternalContext(this, conductor);
            try {
                Object object = callable.call(new Object[]{reference[0]});
                return (T)object;
            }
            finally {
                reference[0] = null;
                this.context.remove();
            }
        }
        return (T)callable.call(new Object[]{reference[0]});
    }

    public void destroy() {
        InternalContext[] reference = this.context.get();
        if (reference[0] != null) {
            for (Object instance : reference[0].instances) {
                List methods = Reflects.getBoundMethods(instance.getClass(), Digest.class, (boolean)false);
                Collections.sort(methods, new Comparator<BoundMethod>(){

                    @Override
                    public int compare(BoundMethod prev, BoundMethod next) {
                        return ((Digest)prev.getAnnotation(Digest.class)).value() - ((Digest)next.getAnnotation(Digest.class)).value();
                    }
                });
                for (BoundMethod method : methods) {
                    Digest digest = (Digest)method.getAnnotation(Digest.class);
                    if (digest.stage() != Digest.Stage.DESTROY) continue;
                    method.invoke(instance, new Object[0]);
                }
            }
        }
        this.strategies.clear();
        this.factories.clear();
        this.context.remove();
    }

    public String toString() {
        return this.name;
    }
}

