/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.inject;

import net.isger.util.Asserts;
import net.isger.util.Reflects;

public class Key<T> {
    final Class<T> type;
    final String name;
    final int hashCode;

    private Key(Class<T> type, String name) {
        Asserts.isNotNull(type, (String)"The key type not be null", (Object[])new Object[0]);
        Asserts.isNotEmpty((Object)name, (String)"The key name not be null or empty for [%s]", (Object[])new Object[]{type});
        this.type = type;
        this.name = name;
        this.hashCode = Reflects.getWrapClass(type).hashCode() << 8 + name.hashCode() & 0xFF;
    }

    public static <T> Key<T> newInstance(Class<T> type, String name) {
        return new Key<T>(type, name);
    }

    public Class<T> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Key)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        Key key = (Key)o;
        return this.name.equals(key.name) && Reflects.getWrapClass(this.type).equals(Reflects.getWrapClass(key.type));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(this.name).append(":").append(this.type.getName());
        return buffer.toString();
    }
}

