/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.inject;

import java.util.concurrent.Callable;
import net.isger.brick.inject.InternalContainer;
import net.isger.brick.inject.InternalContext;
import net.isger.brick.inject.InternalFactory;
import net.isger.brick.inject.Strategy;
import net.isger.brick.util.anno.Scoped;

public enum Scope {
    DEFAULT{

        @Override
        protected <T> InternalFactory<? extends T> factory(Class<T> type, String name, InternalFactory<? extends T> factory) {
            return factory;
        }
    }
    ,
    SINGLETON{

        @Override
        protected <T> InternalFactory<? extends T> factory(Class<T> type, String name, final InternalFactory<? extends T> factory) {
            return new InternalFactory<T>(){
                T instance;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T create(InternalContext context) {
                    InternalContainer internalContainer = context.container;
                    synchronized (internalContainer) {
                        if (this.instance == null) {
                            this.instance = factory.create(context);
                        }
                        return this.instance;
                    }
                }
            };
        }
    }
    ,
    THREAD{

        @Override
        protected <T> InternalFactory<? extends T> factory(Class<T> type, String name, final InternalFactory<? extends T> factory) {
            return new InternalFactory<T>(){
                private final ThreadLocal<T> threadLocal = new ThreadLocal();

                @Override
                public T create(InternalContext context) {
                    Object instance = this.threadLocal.get();
                    if (instance == null) {
                        instance = factory.create(context);
                        this.threadLocal.set(instance);
                    }
                    return instance;
                }
            };
        }
    }
    ,
    STRATEGY{

        @Override
        protected <T> InternalFactory<? extends T> factory(final Class<T> type, final String name, final InternalFactory<? extends T> factory) {
            return new InternalFactory<T>(){

                @Override
                public T create(InternalContext context) {
                    Strategy strategy = context.getStrategy(type, name);
                    try {
                        return strategy.find(type, name, this.toCallable(context, factory));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
    };


    protected <T> Callable<? extends T> toCallable(final InternalContext context, final InternalFactory<? extends T> factory) {
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                return factory.create(context);
            }
        };
    }

    protected abstract <T> InternalFactory<? extends T> factory(Class<T> var1, String var2, InternalFactory<? extends T> var3);

    public static Scope get(Class<?> clazz) {
        Scope scope;
        Scoped scoped = clazz.getAnnotation(Scoped.class);
        if (scoped != null && (scope = scoped.value()) != null) {
            return scope;
        }
        return DEFAULT;
    }
}

