/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.stub;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import net.isger.brick.stub.AbstractStub;
import net.isger.brick.stub.BaseDataSource;
import net.isger.brick.stub.Condition;
import net.isger.brick.stub.StubCommand;
import net.isger.brick.stub.dialect.Dialect;
import net.isger.brick.stub.dialect.Dialects;
import net.isger.brick.stub.dialect.SqlDialect;
import net.isger.brick.stub.model.Meta;
import net.isger.brick.stub.model.Metas;
import net.isger.brick.stub.model.Model;
import net.isger.brick.stub.model.Option;
import net.isger.util.Asserts;
import net.isger.util.Callable;
import net.isger.util.Helpers;
import net.isger.util.Sqls;
import net.isger.util.Strings;
import net.isger.util.anno.Ignore;
import net.isger.util.sql.PageSql;
import net.isger.util.sql.Pager;
import net.isger.util.sql.SqlEntry;
import net.isger.util.sql.SqlTransformer;
import net.isger.util.sql.SqlTransformerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class SqlStub
extends AbstractStub {
    public static final String PARAM_JNDINAME = "jndiName";
    public static final String PARAM_DRIVERNAME = "driverName";
    public static final String PARAM_URL = "url";
    public static final String PARAM_USER = "user";
    public static final String PARAM_PASSWORD = "password";
    private static final Logger LOG = LoggerFactory.getLogger(SqlStub.class);
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private DataSource dataSource;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private Dialect dialect;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private SqlTransformer transformer;

    @Override
    @Ignore(mode=Ignore.Mode.INCLUDE)
    public void initial() {
        Dialect dialect;
        if (this.dataSource == null || (this.dataSource = this.getDataSource()) == null) {
            String value = Strings.trim((Object)this.getJndiName());
            if (Strings.isNotEmpty((Object)value)) {
                try {
                    this.dataSource = (DataSource)new InitialContext().lookup(value);
                }
                catch (Exception e) {
                    throw Asserts.state((String)"Couldn't lookup DataSource from [%s] - %s", (Object[])new Object[]{value, e.getMessage(), e.getCause()});
                }
            } else {
                value = this.getUrl();
                if (Strings.isNotEmpty((Object)value) && Strings.isNotEmpty((Object)this.getDriverName())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.info("Initializing DataSource url [{}]", (Object)value);
                    }
                    this.dataSource = new BaseDataSource(this.getDriverName(), value, this.getUser(), this.getPassword());
                } else {
                    throw Asserts.state((String)"Unexpected JNDI or JDBC configuration. Make sure you want to use the sql stub", (Object[])new Object[0]);
                }
            }
        }
        if ((dialect = this.getDialect()) == null && (dialect = Dialects.getDialect(this.getDriverName())) == null) {
            dialect = new SqlDialect();
        }
        this.dialect = dialect;
        if (this.transformer == null) {
            this.transformer = new SqlTransformerAdapter();
        } else {
            this.transformer.initial();
        }
        this.initialStandard(StubCommand.getAction());
    }

    protected void initialStandard(StubCommand cmd) {
        cmd.setCondition(new Pager());
        this.initialModel(cmd, new Model());
        this.initialModel(cmd, new Meta());
        this.initialModel(cmd, new Option());
    }

    private void initialModel(StubCommand cmd, Object table) {
        cmd.setTable(table);
        try {
            this.exists(cmd);
        }
        catch (Exception e) {
            this.create(cmd);
            for (Meta meta : Metas.getMetas(table).values()) {
                Model model = meta.toModel();
                if (model == null) continue;
                this.initialModel(cmd, model);
            }
        }
    }

    protected String getJndiName() {
        return (String)this.getParameter(PARAM_JNDINAME);
    }

    protected String getDriverName() {
        return (String)this.getParameter(PARAM_DRIVERNAME);
    }

    protected String getUrl() {
        return (String)this.getParameter(PARAM_URL);
    }

    protected String getUser() {
        return (String)this.getParameter(PARAM_USER);
    }

    protected String getPassword() {
        return (String)this.getParameter(PARAM_PASSWORD);
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    protected Dialect getDialect() {
        return this.dialect;
    }

    protected Connection getConnection(StubCommand cmd) {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw Asserts.state((String)"Failure to connect database", (Object[])new Object[]{e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Ignore(mode=Ignore.Mode.INCLUDE)
    public void create(StubCommand cmd) {
        Object result;
        Object table = cmd.getTable();
        final Connection conn = this.getConnection(cmd);
        Object[] condition = this.getCondition(cmd, 3);
        try {
            result = table instanceof String ? Sqls.modify((SqlEntry)this.transformer.transform(this.dialect.getCreateEntry((String)table, (String[][])condition[0])), (Connection)conn) : (table instanceof Class ? (condition == null ? Sqls.modify((SqlEntry)this.transformer.transform(this.dialect.getCreateEntry((Class)table)), (Connection)conn) : this.modify(cmd.getOperate(), (Class)table, condition, conn)) : Helpers.each((Object)table, (Callable)new Callable<Object>(){

                public Object call(Object ... args) {
                    return Sqls.modify((SqlEntry)SqlStub.this.transformer.transform(SqlStub.this.dialect.getCreateEntry(args[1])), (Connection)conn);
                }
            }, (Object[])new Object[0]));
        }
        finally {
            this.close(conn);
        }
        cmd.setResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Ignore(mode=Ignore.Mode.INCLUDE)
    public void insert(StubCommand cmd) {
        Object result;
        Object table = cmd.getTable();
        Object[] condition = this.getCondition(cmd, 3);
        final Connection conn = this.getConnection(cmd);
        try {
            result = table instanceof String ? Sqls.modify((SqlEntry)this.dialect.getInsertEntry((String)table, condition), (Connection)conn) : (table instanceof Class ? this.modify(cmd.getOperate(), (Class)table, condition, conn) : Helpers.each((Object)table, (Callable)new Callable<Object>(){

                public Object call(Object ... args) {
                    return Sqls.modify((SqlEntry)SqlStub.this.dialect.getInsertEntry(args[1]), (Connection)conn);
                }
            }, (Object[])new Object[0]));
        }
        finally {
            this.close(conn);
        }
        cmd.setResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Ignore(mode=Ignore.Mode.INCLUDE)
    public void delete(StubCommand cmd) {
        Object result;
        Object table = cmd.getTable();
        Object[] condition = this.getCondition(cmd, 3);
        final Connection conn = this.getConnection(cmd);
        try {
            result = table instanceof String ? Sqls.modify((SqlEntry)this.dialect.getDeleteEntry((String)table, (Object[])condition[0]), (Connection)conn) : (table instanceof Class ? this.modify(cmd.getOperate(), (Class)table, condition, conn) : Helpers.each((Object)table, (Callable)new Callable<Object>(){

                public Object call(Object ... args) {
                    return Sqls.modify((SqlEntry)SqlStub.this.dialect.getDeleteEntry(args[1]), (Connection)conn);
                }
            }, (Object[])new Object[0]));
        }
        finally {
            this.close(conn);
        }
        cmd.setResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Ignore(mode=Ignore.Mode.INCLUDE)
    public void update(StubCommand cmd) {
        Object result;
        Object table = cmd.getTable();
        Object[] condition = this.getCondition(cmd, 3);
        final Connection conn = this.getConnection(cmd);
        try {
            if (table instanceof String) {
                Object[][] values = (Object[][])condition[0];
                result = Sqls.modify((SqlEntry)this.dialect.getUpdateEntry((String)table, values[0], values[1]), (Connection)conn);
            } else {
                result = table instanceof Class ? this.modify(cmd.getOperate(), (Class)table, condition, conn) : Helpers.each((Object)table, (Callable)new Callable<Object>(){

                    public Object call(Object ... args) {
                        Object[] values = (Object[])args[1];
                        return Sqls.modify((SqlEntry)SqlStub.this.dialect.getUpdateEntry(values[0], values[1]), (Connection)conn);
                    }
                }, (Object[])new Object[0]);
            }
        }
        finally {
            this.close(conn);
        }
        cmd.setResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Ignore(mode=Ignore.Mode.INCLUDE)
    public void select(StubCommand cmd) {
        Object[] result;
        block14: {
            Object table = cmd.getTable();
            Object[] condition = this.getCondition(cmd, 3);
            final Connection conn = this.getConnection(cmd);
            try {
                String countSql;
                SqlEntry sqlEntry;
                if (table instanceof String) {
                    sqlEntry = this.dialect.getSearchEntry((String)table, (String[])condition[0], (Object[])condition[1]);
                    result = Sqls.query((SqlEntry)sqlEntry, (Connection)conn);
                } else {
                    boolean isSpecify;
                    if (!(table instanceof Class)) {
                        result = (Object[])Helpers.each((Object)table, (Callable)new Callable<Object>(){

                            public Object call(Object ... args) {
                                return Sqls.query((SqlEntry)SqlStub.this.dialect.getSearchEntry(args[1]), (Connection)conn);
                            }
                        }, (Object[])new Object[0]);
                        break block14;
                    }
                    this.canonicalize(cmd.getOperate(), condition);
                    String id = (String)condition[0];
                    Object[] args = (Object[])condition[1];
                    String sql = Sqls.getSQL((Class)((Class)table), (String)this.dialect.name(), (String)id, (Object[])((Object[])condition[2]));
                    boolean bl = isSpecify = id.indexOf(":") > 0;
                    if (Strings.isEmpty((Object)sql)) {
                        if (isSpecify) {
                            String[] opcodes = id.split("[:]");
                            sql = Sqls.getSQL((Class)((Class)table), (String)this.dialect.name(), (String)opcodes[0], (Object[])((Object[])condition[2]));
                        }
                        Asserts.throwState((boolean)Strings.isNotEmpty((Object)sql), (String)"Not found the sql [%s] in the configuration file", (Object[])new Object[]{id});
                        args = (Object[])args[1];
                    } else if (isSpecify) {
                        args = (Object[])Helpers.newArray((Object)args[0], (Object)Helpers.getElement((Object)args[1], Pager.class));
                    } else if (args[0] == null && args[1] instanceof Object[]) {
                        args = (Object[])args[1];
                    }
                    sqlEntry = this.transformer.transform(this.dialect.getSearchEntry(sql, args));
                    result = Sqls.query((SqlEntry)sqlEntry, (Connection)conn);
                }
                if (sqlEntry instanceof PageSql && (countSql = ((PageSql)sqlEntry).getCountSql()) != null) {
                    Object[] target = new Object[result.length + 1];
                    System.arraycopy(result, 0, target, 0, result.length);
                    target[result.length] = ((Number)((Object[][])Sqls.query((String)countSql, (Object[])((PageSql)sqlEntry).getCountValues(), (Connection)conn)[1])[0][0]).longValue();
                    result = target;
                }
            }
            finally {
                this.close(conn);
            }
        }
        cmd.setResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Ignore(mode=Ignore.Mode.INCLUDE)
    public void exists(StubCommand cmd) {
        Object[] result;
        Object table = cmd.getTable();
        Object[] condition = this.getCondition(cmd, 3);
        final Connection conn = this.getConnection(cmd);
        try {
            if (table instanceof String) {
                SqlEntry sqlEntry = this.dialect.getExistsEntry((String)table);
                result = Sqls.query((SqlEntry)sqlEntry, (Connection)conn);
            } else if (table instanceof Class) {
                this.canonicalize(cmd.getOperate(), condition);
                String id = Strings.empty((Object)condition[0], (String)"exists");
                String sql = Sqls.getSQL((Class)((Class)table), (String)this.dialect.name(), (String)id, (Object[])((Object[])condition[2]));
                Object[] args = (Object[])condition[1];
                if (Strings.isEmpty((Object)sql) && id.indexOf(":") >= 0) {
                    String[] opcodes = id.split("[:]");
                    sql = Sqls.getSQL((Class)((Class)table), (String)this.dialect.name(), (String)opcodes[0], (Object[])((Object[])condition[2]));
                    Asserts.throwState((boolean)Strings.isNotEmpty((Object)sql), (String)"Not found the sql [%s] in the configuration file", (Object[])new Object[]{id});
                    args = (Object[])args[1];
                } else {
                    args = (Object[])args[0];
                }
                SqlEntry sqlEntry = this.transformer.transform(this.dialect.getSearchEntry(sql, args));
                result = Sqls.query((SqlEntry)sqlEntry, (Connection)conn);
            } else {
                result = (Object[])Helpers.each((Object)table, (Callable)new Callable<Object>(){

                    public Object call(Object ... args) {
                        return Sqls.query((SqlEntry)SqlStub.this.dialect.getExistsEntry(args[1]), (Connection)conn);
                    }
                }, (Object[])new Object[0]);
            }
        }
        finally {
            this.close(conn);
        }
        cmd.setResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Ignore(mode=Ignore.Mode.INCLUDE)
    public void remove(StubCommand cmd) {
        Object result;
        Object table = cmd.getTable();
        final Connection conn = this.getConnection(cmd);
        try {
            result = Helpers.each((Object)table, (Callable)new Callable<Object>(){

                public Object call(Object ... args) {
                    return Sqls.modify((SqlEntry)SqlStub.this.dialect.getRemoveEntry(args[1]), (Connection)conn);
                }
            }, (Object[])new Object[0]);
        }
        finally {
            this.close(conn);
        }
        cmd.setResult(result);
    }

    protected Object[] getCondition(StubCommand cmd, int length) {
        Object config = cmd.getCondition();
        if (config instanceof Condition) {
            throw Asserts.state((String)"Unsupported feature in the current version", (Object[])new Object[0]);
        }
        return (Object[])Helpers.newArray((Object)config, (int)length);
    }

    protected Object modify(String operate, Class<?> table, Object[] condition, Connection conn) {
        boolean isSpecify;
        this.canonicalize(operate, condition);
        String id = (String)condition[0];
        String sql = Sqls.getSQL(table, (String)this.dialect.name(), (String)id, (Object[])((Object[])condition[2]));
        Object[] args = (Object[])condition[1];
        boolean bl = isSpecify = id.indexOf(":") > 0;
        if (Strings.isEmpty((Object)sql)) {
            if (isSpecify) {
                String[] opcodes = id.split("[:]");
                sql = Sqls.getSQL(table, (String)this.dialect.name(), (String)opcodes[0], (Object[])((Object[])condition[2]));
            }
            Asserts.throwState((boolean)Strings.isNotEmpty((Object)sql), (String)"Not found the sql [%s] in the configuration file", (Object[])new Object[]{id});
            args = (Object[])args[1];
        } else if (isSpecify) {
            args = (Object[])args[0];
        } else if (args[0] == null && args[1] instanceof Object[]) {
            args = (Object[])args[1];
        }
        SqlEntry entry = this.transformer.transform(sql, (Object)args);
        sql = entry.getSql();
        Object[] value = entry.getValues();
        return value instanceof Object[][] ? Sqls.modify((String)sql, (Object[][])((Object[][])value), (Connection)conn) : (int[])Sqls.modify((String)sql, (Object[])value, (Connection)conn);
    }

    private void canonicalize(String operate, Object[] condition) {
        if (condition[0] != null && !(condition[0] instanceof String)) {
            int index = condition.length - 1;
            while (index > 0) {
                condition[index--] = condition[index];
            }
            condition[index] = operate;
        }
    }

    public void close(Connection conn) {
        try {
            if (conn != null && conn.getAutoCommit()) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    @Ignore(mode=Ignore.Mode.INCLUDE)
    public void destroy() {
    }
}

