/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.stub.dialect;

import java.util.Hashtable;
import java.util.Map;
import net.isger.brick.stub.dialect.Dialect;
import net.isger.util.hitch.Director;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dialects {
    private static final String KEY_DIALECTS = "brick.core.dialects";
    private static final String DIALECT_PATH = "net/isger/brick/stub/dialect";
    private static final Logger LOG = LoggerFactory.getLogger(Dialects.class);
    private static final Dialects INSTANCE = new Dialects();
    private Map<String, Dialect> dialects = new Hashtable<String, Dialect>();

    private Dialects() {
    }

    public static void addDialect(Dialect dialect) {
        String name = dialect.getClass().getName();
        if (LOG.isDebugEnabled()) {
            LOG.info("Achieve dialect [{}]", (Object)name);
        }
        if ((dialect = Dialects.INSTANCE.dialects.put(name, dialect)) != null && LOG.isDebugEnabled()) {
            LOG.warn("(!) Discard dialect [{}]", (Object)dialect);
        }
    }

    public static Dialect getDialect(String driverName) {
        Dialect result = null;
        for (Dialect dialect : Dialects.INSTANCE.dialects.values()) {
            if (!dialect.isSupport(driverName)) continue;
            result = dialect;
            break;
        }
        return result;
    }

    static {
        new Director(){

            protected String directPath() {
                return this.directPath(Dialects.KEY_DIALECTS, Dialects.DIALECT_PATH);
            }
        }.direct((Object)INSTANCE);
    }
}

