/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.stub.dialect;

import net.isger.brick.stub.dialect.SqlDialect;
import net.isger.util.sql.PageSql;
import net.isger.util.sql.Pager;

public class H2Dialect
extends SqlDialect {
    private static final String DRIVER_NAME = "org.h2.Driver";

    @Override
    public boolean isSupport(String name) {
        return super.isSupport(name) || DRIVER_NAME.equals(name);
    }

    @Override
    protected PageSql createPageSql(Pager page, String sql, Object[] values) {
        return new PageSql(page, sql, values){

            public Object[] getWrapValues(Object[] values) {
                Pager page = super.getPage();
                int valCount = 2;
                Object[] wrapValues = null;
                if (values != null) {
                    wrapValues = new Object[valCount += values.length];
                    System.arraycopy(values, 0, wrapValues, 0, values.length);
                } else {
                    wrapValues = new Object[valCount];
                }
                wrapValues[valCount - 1] = page.getStart() + page.getLimit();
                wrapValues[valCount - 2] = page.getStart();
                return wrapValues;
            }
        };
    }
}

