/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.stub.dialect;

import java.util.HashMap;
import java.util.Map;
import net.isger.brick.stub.dialect.SqlDialect;
import net.isger.brick.stub.model.Meta;
import net.isger.util.Strings;

public class MysqlDialect
extends SqlDialect {
    private static final String[] DRIVER_NAMES = new String[]{"com.mysql.jdbc.Driver", "com.mysql.cj.jdbc.Driver", "org.mariadb.jdbc.Driver"};
    public static final String NUMERIC = "numeric";
    private static final Map<String, String> TYPES = new HashMap<String, String>();

    @Override
    public boolean isSupport(String name) {
        for (String driverName : DRIVER_NAMES) {
            if (!driverName.equals(name)) continue;
            return true;
        }
        return super.isSupport(name);
    }

    @Override
    protected String type(Meta meta, String name) {
        String type = TYPES.get(name.toUpperCase());
        if (Strings.isEmpty((Object)type)) {
            type = super.type(meta, name);
        }
        return type;
    }

    @Override
    protected String seal() {
        return "`";
    }

    static {
        TYPES.put("number".toUpperCase(), NUMERIC.toUpperCase());
    }
}

