/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.stub.dialect;

import java.util.HashMap;
import java.util.Map;
import net.isger.brick.stub.dialect.DescriberDelegate;
import net.isger.brick.stub.dialect.SqlDialect;
import net.isger.brick.stub.model.Meta;
import net.isger.brick.stub.model.Option;
import net.isger.util.Helpers;
import net.isger.util.Strings;
import net.isger.util.sql.PageSql;
import net.isger.util.sql.Pager;

public class PostgresDialect
extends SqlDialect {
    private static final String DRIVER_NAME = "org.postgresql.Driver";
    private static final String NUMERIC = "numeric";
    private static final String BIGINT = "bigint";
    private static final String BOOL = "bool";
    private static final Map<String, String> TYPES = new HashMap<String, String>();

    public PostgresDialect() {
        this.addDescriber("long", this.getNumberDescriber(BIGINT, false));
        this.addDescriber("int", this.getNumberDescriber("int", false));
        this.addDescriber("boolean", new DescriberDelegate(this.getNumberDescriber(BOOL, false)){

            @Override
            public String describe(Option option, Object ... extents) {
                String value = super.describe(option, extents);
                switch (option.getType().intValue()) {
                    case 0: {
                        value = String.valueOf(Helpers.toBoolean((Object)value));
                    }
                }
                return value;
            }
        });
    }

    @Override
    public boolean isSupport(String name) {
        return super.isSupport(name) || DRIVER_NAME.equals(name);
    }

    @Override
    protected String type(Meta meta, String name) {
        String pending = name.toUpperCase();
        String type = TYPES.get(pending);
        if (Strings.isEmpty((Object)type)) {
            if (this.describers.containsKey(pending)) {
                return pending;
            }
            type = super.type(meta, pending);
        }
        return type;
    }

    @Override
    protected PageSql createPageSql(Pager page, String sql, Object[] values) {
        return new PageSql(page, sql, values){

            public String getWrapSql(String sql) {
                return sql + " limit ? offset ?";
            }

            public Object[] getWrapValues(Object[] values) {
                Pager page = super.getPage();
                int valCount = 2;
                Object[] wrapValues = null;
                if (values != null) {
                    wrapValues = new Object[valCount += values.length];
                    System.arraycopy(values, 0, wrapValues, 0, values.length);
                } else {
                    wrapValues = new Object[valCount];
                }
                wrapValues[valCount - 1] = (page.getStart() - 1) * page.getLimit();
                wrapValues[valCount - 2] = page.getLimit();
                return wrapValues;
            }
        };
    }

    static {
        TYPES.put("number".toUpperCase(), NUMERIC.toUpperCase());
        TYPES.put("datetime".toUpperCase(), "timestamp".toUpperCase());
    }
}

