/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.stub.dialect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.isger.brick.stub.dialect.Describer;
import net.isger.brick.stub.dialect.DescriberAdapter;
import net.isger.brick.stub.dialect.Dialect;
import net.isger.brick.stub.model.Meta;
import net.isger.brick.stub.model.Metas;
import net.isger.brick.stub.model.Model;
import net.isger.brick.stub.model.Option;
import net.isger.brick.stub.model.Options;
import net.isger.brick.stub.model.OptionsConversion;
import net.isger.util.Dates;
import net.isger.util.Helpers;
import net.isger.util.Numbers;
import net.isger.util.Reflects;
import net.isger.util.Strings;
import net.isger.util.reflect.BoundField;
import net.isger.util.sql.PageSql;
import net.isger.util.sql.Pager;
import net.isger.util.sql.SqlEntry;

public class SqlDialect
implements Dialect {
    private static final Map<String, Model> MODELS;
    private static final Map<String, String> TYPES;
    private final Describer PRIMARY_DESCRIBER;
    private final Describer NOTNULL_DESCRIBER;
    private final Describer UNIQUE_DESCRIBER;
    private final Describer DEFAULT_DESCRIBER = new DescriberAdapter(){

        @Override
        public String describe(Option option, Object ... extents) {
            Object value = option.getValue();
            if (extents != null && extents[0] != null) {
                value = extents[0].toString();
            }
            return "DEFAULT " + value;
        }
    };
    private String name;
    protected final Map<Object, Describer> describers;

    public SqlDialect() {
        this.PRIMARY_DESCRIBER = new DescriberAdapter(){

            @Override
            public String describe(Option option, Object ... extents) {
                return "PRIMARY KEY";
            }
        };
        this.NOTNULL_DESCRIBER = new DescriberAdapter(){

            @Override
            public String describe(Option option, Object ... extents) {
                Object value = option.getValue();
                return Strings.isEmpty((Object)value) || Helpers.toBoolean((Object)value) ? "NOT NULL" : "NULL";
            }
        };
        this.UNIQUE_DESCRIBER = new DescriberAdapter(){

            @Override
            public String describe(Option option, Object ... extents) {
                StringBuffer buffer = new StringBuffer(64);
                buffer.append("UNIQUE");
                String name = option.getName();
                List<Object> value = option.getValue();
                if (Strings.isEmpty((Object)name) || Strings.isEmpty((Object)value)) {
                    return buffer.toString();
                }
                String seal = SqlDialect.this.seal();
                buffer.append(" KEY ").append(seal).append("UK_").append(name).append(seal);
                if (value instanceof String) {
                    value = Arrays.asList(value);
                }
                buffer.append("(").append(Strings.join((boolean)true, (String)",", (String)seal, value)).append(")");
                return buffer.toString();
            }
        };
        this.describers = new HashMap<Object, Describer>();
        this.addDescriber("reference", this.getReferenceDescriber("reference"));
        this.addDescriber("string", this.getStringDescriber("string"));
        this.addDescriber("number", this.getNumberDescriber("number"));
        this.addDescriber("int", this.getNumberDescriber("int"));
        this.addDescriber("date", this.getDateDescriber("date"));
        this.addDescriber("time", this.getDateDescriber("time"));
        this.addDescriber("datetime", this.getDateDescriber("datetime"));
        this.addDescriber("timestamp", this.getDateDescriber("timestamp"));
        this.addDescriber(0, this.DEFAULT_DESCRIBER);
        this.addDescriber(1, this.PRIMARY_DESCRIBER);
        this.addDescriber(3, this.NOTNULL_DESCRIBER);
        this.addDescriber(4, this.UNIQUE_DESCRIBER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model getModel(String name) {
        Map<String, Model> map = MODELS;
        synchronized (map) {
            return MODELS.get(name);
        }
    }

    public String name() {
        if (Strings.isEmpty((Object)this.name)) {
            this.name = Helpers.getAliasName(this.getClass(), (String)"Dialect$");
        }
        return this.name;
    }

    @Override
    public boolean isSupport(String name) {
        return this.name().equalsIgnoreCase(name);
    }

    protected String type(Meta meta, String name) {
        String key = name.toUpperCase();
        return Strings.empty((Object)TYPES.get(key), (String)key);
    }

    protected String seal() {
        return "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqlEntry getCreateEntry(Object table) {
        Options options;
        Model model = Model.create(table);
        List<String[]> describes = this.getColumnDescribes(model.metas());
        Object optionsSchema = model.schemaValue("options");
        if (Strings.isNotEmpty((Object)optionsSchema) && (options = (Options)OptionsConversion.getInstance().convert(optionsSchema)) != null) {
            describes.add(new String[]{null, this.getOptionDescribe(null, options, true)});
        }
        Map<String, Model> map = MODELS;
        synchronized (map) {
            if (!MODELS.containsKey(model.modelName())) {
                MODELS.put(model.modelName(), model.clone());
            }
        }
        return this.getCreateEntry(model.modelName(), (String[][])describes.toArray((T[])new String[describes.size()][]));
    }

    @Override
    public SqlEntry getCreateEntry(String table, String[][] describes) {
        String seal = this.seal();
        StringBuffer sql = new StringBuffer(512);
        sql.append("CREATE TABLE ").append(table);
        if (describes.length > 0) {
            sql.append(" (");
            for (String[] describe : describes) {
                int count = describe.length;
                if (Strings.isNotEmpty((Object)describe[0])) {
                    sql.append(seal).append(describe[0]).append(seal).append(" ");
                }
                for (int i = 1; i < count; ++i) {
                    sql.append(describe[i]).append(" ");
                }
                sql.setLength(sql.length() - 1);
                sql.append(", ");
            }
            sql.setLength(sql.length() - 2);
            sql.append(")");
        }
        return new SqlEntry(sql.toString(), new Object[0]);
    }

    @Override
    public SqlEntry getInsertEntry(Object table) {
        return this.getInsertEntry(this.getTableName(table), this.getTableData(table));
    }

    @Override
    public SqlEntry getInsertEntry(String tableName, Object[] gridData) {
        String seal = this.seal();
        StringBuffer sql = new StringBuffer(512);
        StringBuffer params = new StringBuffer(128);
        sql.append("INSERT INTO ").append(tableName).append("(");
        Object[] columns = (Object[])gridData[0];
        int count = columns.length;
        for (int i = 0; i < count; ++i) {
            sql.append(seal).append(columns[i]).append(seal).append(", ");
            params.append("?, ");
        }
        sql.setLength(sql.length() - 2);
        sql.append(") VALUES (");
        params.setLength(params.length() - 2);
        sql.append(params);
        sql.append(")");
        return new SqlEntry(sql.toString(), (Object[])gridData[1]);
    }

    @Override
    public SqlEntry getDeleteEntry(Object table) {
        return this.getDeleteEntry(this.getTableName(table), this.getTableData(table));
    }

    @Override
    public SqlEntry getDeleteEntry(String tableName, Object[] gridData) {
        String seal = this.seal();
        StringBuffer sql = new StringBuffer(512);
        sql.append("DELETE FROM ").append(tableName).append(" WHERE 1 = 1");
        Object[] columns = (Object[])gridData[0];
        int count = columns.length;
        if (gridData.length == 3 && Strings.isNotEmpty((Object)((String)gridData[2]))) {
            throw new IllegalStateException("Unsupported feature in the current version");
        }
        for (int i = 0; i < count; ++i) {
            sql.append(" AND ").append(seal).append(columns[i]).append(seal).append(" = ?");
        }
        return new SqlEntry(sql.toString(), (Object[])gridData[1]);
    }

    @Override
    public SqlEntry getUpdateEntry(Object newTable, Object oldTable) {
        return this.getUpdateEntry(this.getTableName(newTable), this.getTableData(newTable), this.getTableData(oldTable));
    }

    @Override
    public SqlEntry getUpdateEntry(String tableName, Object[] newGridData, Object[] oldGridData) {
        int i;
        String seal = this.seal();
        StringBuffer sql = new StringBuffer(512);
        sql.append("UPDATE ").append(tableName).append(" SET ");
        Object[] columns = (Object[])newGridData[0];
        int count = columns.length;
        for (i = 0; i < count; ++i) {
            sql.append(seal).append(columns[i]).append(seal).append(" = ?, ");
        }
        sql.setLength(sql.length() - 2);
        sql.append(" WHERE 1 = 1");
        columns = (String[])oldGridData[0];
        count = columns.length;
        if (oldGridData.length == 3 && Strings.isNotEmpty((Object)((String)oldGridData[2]))) {
            throw new IllegalStateException("Unsupported feature in the current version");
        }
        for (i = 0; i < count; ++i) {
            sql.append(" AND ").append(seal).append(columns[i]).append(seal).append(" = ?");
        }
        return new SqlEntry(sql.toString(), (Object[])Helpers.newArray((Object)newGridData[1], (Object)oldGridData[1]));
    }

    @Override
    public SqlEntry getSearchEntry(Object table) {
        return this.getSearchEntry(this.getTableName(table), this.getColumnNames(table), this.getTableData(table));
    }

    @Override
    public SqlEntry getSearchEntry(String tableName, Object[] columns, Object[] gridData) {
        int i;
        String seal = this.seal();
        StringBuffer sql = new StringBuffer(512);
        StringBuffer restrict = new StringBuffer(128);
        sql.append("SELECT ");
        int count = columns.length;
        for (i = 0; i < count; ++i) {
            sql.append(seal).append(columns[i]).append(seal).append(", ");
        }
        sql.setLength(sql.length() - 2);
        sql.append(" FROM ").append(tableName).append(" WHERE 1 = 1");
        columns = (String[])gridData[0];
        count = columns.length;
        if (gridData.length == 3 && Strings.isNotEmpty((Object)((String)gridData[2]))) {
            throw new IllegalStateException("Unsupported feature in the current version");
        }
        for (i = 0; i < count; ++i) {
            restrict.append(" AND ").append(seal).append(columns[i]).append(seal).append(" = ?");
        }
        sql.append(restrict);
        return this.getSearchEntry(sql.toString(), (Object[])gridData[1]);
    }

    @Override
    public SqlEntry getSearchEntry(String sql, Object[] values) {
        Pager pager = this.getPager(values);
        return this.getSearchEntry(pager, sql, values);
    }

    private SqlEntry getSearchEntry(Pager pager, String sql, Object[] values) {
        if (pager == null) {
            return new SqlEntry(sql, values);
        }
        return this.createPageSql(pager, sql, values);
    }

    protected PageSql createPageSql(Pager pager, String sql, Object[] values) {
        return new PageSql(pager, sql, values);
    }

    protected Pager getPager(Object[] values) {
        return (Pager)Helpers.getElement((Object)values, Pager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqlEntry getExistsEntry(Object table) {
        Model model = Model.create(table);
        Map<String, Model> map = MODELS;
        synchronized (map) {
            if (!MODELS.containsKey(model.modelName())) {
                MODELS.put(model.modelName(), model.clone());
            }
        }
        return this.getExistsEntry(this.getTableName(model));
    }

    @Override
    public SqlEntry getExistsEntry(String tableName) {
        StringBuffer sql = new StringBuffer(128);
        sql.append("SELECT count(1) FROM ").append(tableName).append(" WHERE 1 <> 1");
        return new SqlEntry(sql.toString(), new Object[0]);
    }

    @Override
    public SqlEntry getRemoveEntry(Object table) {
        return new SqlEntry(new StringBuffer("DROP TABLE ").append(this.getTableName(table)).toString(), new Object[0]);
    }

    protected String getTableName(Object table) {
        return Model.getName(table);
    }

    protected String[] getColumnNames(Object table) {
        Metas metas = Metas.getMetas(table);
        ArrayList<String> columns = new ArrayList<String>();
        for (Meta meta : metas.values()) {
            if (meta.isReference()) continue;
            columns.add(meta.getName());
        }
        return columns.toArray(new String[columns.size()]);
    }

    protected List<String[]> getColumnDescribes(Metas metas) {
        ArrayList<String[]> describes = new ArrayList<String[]>(metas.size());
        for (Meta meta : metas.values()) {
            String[] describe = this.getColumnDescribe(meta);
            if (describe == null) continue;
            describes.add(describe);
        }
        return describes;
    }

    protected String[] getColumnDescribe(Meta meta) {
        switch (meta.getMode()) {
            case 2: {
                Options options = meta.options();
                String description = meta.getDescription();
                meta = Meta.createMeta("id", meta.getLabel(), meta.getName());
                meta.setDescription(description);
                meta.options().set(options);
            }
        }
        String describe = meta.getType().toUpperCase();
        String typeName = this.type(meta, describe);
        Describer describer = this.describers.get(typeName);
        if ((describer != null || !describe.equalsIgnoreCase(typeName) && (describer = this.describers.get(describe)) != null) && Strings.isEmpty((Object)(describe = describer.describe(meta)))) {
            return null;
        }
        describe = describe + this.getOptionDescribe(describer, meta);
        return new String[]{meta.getName(), describe};
    }

    protected String getOptionDescribe(final Describer describer, final Meta meta) {
        final SqlDialect self = this;
        return this.getOptionDescribe(describer == null ? null : new Describer(){

            @Override
            public String describe(Option option, Object ... extents) {
                return describer.describe(option, meta, self);
            }

            @Override
            public String describe(Meta field) {
                return describer.describe(field);
            }
        }, meta.options(), false);
    }

    protected String getOptionDescribe(Describer describer, Options options, boolean hasComma) {
        StringBuffer sql = new StringBuffer(128);
        for (Option option : options.values()) {
            Describer optionDescriber;
            Number type = option.getType();
            if (type == null || (optionDescriber = this.describers.get(type.intValue())) == null) continue;
            Object[] objectArray = new Object[1];
            Object object = objectArray[0] = describer == null ? null : describer.describe(option, new Object[0]);
            String describe = optionDescriber.describe(option, objectArray);
            if (describe == null) continue;
            sql.append(" ").append(describe);
            if (!hasComma) continue;
            sql.append(", ");
        }
        if (hasComma && sql.length() > 0) {
            sql.setLength(sql.length() - 2);
        }
        return sql.toString();
    }

    protected String getDateDescribe(Object value) {
        if (value instanceof String) {
            try {
                value = Double.parseDouble((String)value);
            }
            catch (Exception e) {
                value = Dates.toString((Object)value, (int)1);
            }
        } else if (value == null) {
            return "CURRENT_TIMESTAMP";
        }
        if (value instanceof Number) {
            Number pending = (Number)value;
            if (pending.intValue() == 0) {
                return "CURRENT_TIMESTAMP";
            }
            value = Dates.toString((Date)new Date(System.currentTimeMillis() + pending.longValue()), (int)1);
        }
        return "TO_DATE('" + value + "', 'YYYY-MM-DD HH:mm:ss')";
    }

    protected Object[] getTableData(Object table) {
        Metas metas = Metas.getMetas(table);
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<Object> row = new ArrayList<Object>();
        for (Meta meta : metas.values()) {
            String column;
            Object value;
            if (meta.isReference() || (value = meta.getValue(table)) == null || (value = this.getColumnValue(column = meta.getName(), value)) == null) continue;
            columns.add(column);
            row.add(value);
        }
        return new Object[]{columns.toArray(new String[columns.size()]), row.toArray()};
    }

    protected Object[] getTableData(Model model) {
        Metas metas = model.metas();
        List<String> names = metas.names();
        int metaCount = names.size();
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<Object> row = new ArrayList<Object>();
        for (int i = 0; i < metaCount; ++i) {
            String column = names.get(i);
            Object value = metas.get(column).getValue();
            if (value == null) continue;
            columns.add(column);
            row.add(this.getColumnValue(column, value));
        }
        return new Object[]{columns.toArray(new String[columns.size()]), row.toArray()};
    }

    protected Object getColumnValue(String name, Object value) {
        if (value instanceof Number || value instanceof Boolean || value instanceof CharSequence) {
            return value;
        }
        if (value instanceof Class) {
            return ((Class)value).getName();
        }
        String[] pending = name.split("[_]", 2);
        if (pending.length == 1) {
            return value;
        }
        BoundField field = Reflects.getBoundField(value.getClass(), (String)pending[1]);
        if (field == null) {
            return value;
        }
        return this.getColumnValue(pending[1], field.getValue(value));
    }

    protected void addDescriber(Object type, Describer describer) {
        if (type instanceof String) {
            type = ((String)type).toUpperCase();
        }
        this.describers.put(type, describer);
    }

    protected Describer getReferenceDescriber(String name) {
        return new DescriberAdapter(name);
    }

    protected Describer getStringDescriber(String name) {
        return new StringDescriber();
    }

    protected Describer getNumberDescriber(String name) {
        return this.getNumberDescriber(name, true);
    }

    protected Describer getNumberDescriber(String name, boolean hasScale) {
        return new NumberDescriber(name, hasScale);
    }

    protected Describer getDateDescriber(String name) {
        return new DateDescriber(name);
    }

    static {
        TYPES = new HashMap<String, String>();
        TYPES.put("double".toUpperCase(), "number".toUpperCase());
        TYPES.put("float".toUpperCase(), "number".toUpperCase());
        TYPES.put("long".toUpperCase(), "number".toUpperCase());
        TYPES.put("integer".toUpperCase(), "int".toUpperCase());
        TYPES.put("short".toUpperCase(), "int".toUpperCase());
        TYPES.put("boolean".toUpperCase(), "int".toUpperCase());
        MODELS = new HashMap<String, Model>();
    }

    protected class DateDescriber
    extends DescriberAdapter {
        public DateDescriber(String name) {
            super(name);
        }

        @Override
        public String describe(Meta field) {
            StringBuffer describe = new StringBuffer(64);
            switch (field.getScale()) {
                case -1: {
                    describe.append(SqlDialect.this.type(field, this.getName()));
                    break;
                }
                case 1: {
                    describe.append(SqlDialect.this.type(field, "time"));
                    break;
                }
                case 2: {
                    describe.append(SqlDialect.this.type(field, "datetime"));
                    break;
                }
                case 3: {
                    describe.append(SqlDialect.this.type(field, "timestamp"));
                    break;
                }
                default: {
                    describe.append(SqlDialect.this.type(field, "date"));
                }
            }
            return describe.toString();
        }

        @Override
        public String describe(Option option, Object ... extents) {
            String value;
            switch (option.getType().intValue()) {
                case 0: {
                    value = ((SqlDialect)extents[1]).getDateDescribe(option.getValue());
                    break;
                }
                default: {
                    value = null;
                }
            }
            return value;
        }
    }

    protected class StringDescriber
    extends DescriberAdapter {
        protected StringDescriber() {
        }

        @Override
        public String describe(Meta field) {
            int length = field.getLength();
            return length > 0 ? SqlDialect.this.type(field, "VARCHAR") + "(" + length + ")" : SqlDialect.this.type(field, "TEXT");
        }

        @Override
        public String describe(Option option, Object ... extents) {
            String value = null;
            switch (option.getType().intValue()) {
                case 0: {
                    Object optionValue = option.getValue();
                    if (optionValue == null) break;
                    value = "'" + optionValue.toString().replaceAll("[']", "''") + "'";
                }
            }
            return value;
        }
    }

    protected class NumberDescriber
    extends DescriberAdapter {
        private boolean hasScale;

        public NumberDescriber(String name, boolean hasScale) {
            super(name);
            this.hasScale = hasScale;
        }

        @Override
        public String describe(Meta field) {
            StringBuffer describe = new StringBuffer(SqlDialect.this.type(field, this.getName()));
            int length = field.getLength();
            if (length > 0 && this.hasScale) {
                describe.append("(").append(length);
                length = field.getScale();
                if (length > 0) {
                    describe.append(", ").append(length);
                }
                describe.append(")");
            }
            return describe.toString();
        }

        @Override
        public String describe(Option option, Object ... extents) {
            String value = null;
            switch (option.getType().intValue()) {
                case 0: {
                    Object optionValue = option.getValue();
                    value = optionValue == null ? "0" : String.valueOf(Numbers.parseInt((Object)optionValue));
                }
            }
            return value;
        }
    }
}

