/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.stub.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.isger.brick.stub.dialect.Dialect;
import net.isger.brick.stub.model.MetaAssembler;
import net.isger.brick.stub.model.Metas;
import net.isger.brick.stub.model.MetasConversion;
import net.isger.brick.stub.model.Model;
import net.isger.brick.stub.model.Options;
import net.isger.brick.stub.model.OptionsConversion;
import net.isger.raw.Artifact;
import net.isger.raw.Depository;
import net.isger.raw.Raw;
import net.isger.raw.TextRaw;
import net.isger.util.Asserts;
import net.isger.util.Reflects;
import net.isger.util.Strings;
import net.isger.util.anno.Affix;
import net.isger.util.anno.Alias;
import net.isger.util.reflect.BoundField;
import net.isger.util.reflect.Converter;
import net.isger.util.reflect.conversion.Conversion;

@Alias(value="t_brick_stub_meta")
public final class Meta
implements Cloneable {
    public static final String ID = "id";
    public static final String VALUE = "value";
    public static final String TYPE_REFERENCE = "reference";
    public static final int MODE_VALUE_DATA = 0;
    public static final int MODE_VALUE_DICT = 1;
    public static final int MODE_VALUE_META = 2;
    public static final int MODE_REFERENCE_EMBED = 0;
    public static final int MODE_REFERENCE_BRIDGE = 1;
    public static final int MODE_REFERENCE_HOOK = 2;
    public static final int SCALE_REFERENCE_O2O = 0;
    public static final int SCALE_REFERENCE_O2M = 1;
    public static final int SCALE_REFERENCE_M2O = 2;
    public static final int SCALE_REFERENCE_M2M = 3;
    @Affix(value="{length : 20, options : [1, 3]}")
    private String id;
    @Affix(value="{length : 128, options : [3, 4]}")
    private String code;
    @Affix(value="{length : 50}")
    private String label;
    @Affix(value="{length : 50, options : 3}")
    private String name;
    @Affix(value="{length : 30, options : 3}")
    private String type;
    @Affix(value="{length : 2, options : 3}")
    private Number mode;
    @Affix(value="{length : 5}")
    private Number length;
    @Affix(value="{length : 2}")
    private Number scale;
    @Affix(value="{type : 'text'}")
    private String description;
    @Affix(value="{type : 'reference'}")
    private Options options;
    @Affix(value="{type : 'reference'}")
    private Object value;
    private transient BoundField field;

    public Meta() {
    }

    public Meta(Object ... args) {
        this.set(args);
    }

    protected void set(Object ... args) {
        if (args == null) {
            return;
        }
        switch (args.length) {
            case 8: {
                this.description = (String)args[7];
            }
            case 7: {
                this.mode = (Integer)args[6];
            }
            case 6: {
                this.code = (String)args[5];
            }
            case 5: {
                this.scale = (Integer)args[4];
            }
            case 4: {
                this.length = (Integer)args[3];
            }
            case 3: {
                this.type = (String)args[2];
            }
            case 2: {
                this.name = (String)args[1];
            }
            case 1: {
                this.label = (String)args[0];
            }
        }
    }

    public boolean isReference() {
        return TYPE_REFERENCE.equalsIgnoreCase(this.type);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getMode() {
        return this.mode == null ? 0 : this.mode.intValue();
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getLength() {
        return this.length == null ? 0 : this.length.intValue();
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getScale() {
        return this.scale == null ? -1 : this.scale.intValue();
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Options options() {
        if (this.options == null) {
            this.options = new Options();
        }
        return this.options;
    }

    public boolean hasOption() {
        return this.options().size() > 0;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getValue(Object instance) {
        Object value = this.getValue();
        if (this.field != null) {
            Map values;
            if (this.field.getField().getDeclaringClass().isInstance(instance)) {
                value = this.field.getValue(instance);
            } else if (instance instanceof Map && (value = (values = (Map)instance).get(this.field.getAlias())) == null) {
                value = values.get(this.field.getName());
            }
        }
        return value;
    }

    public void setValue(Object value) {
        Class<?> type = Dialect.TYPES.get(this.getType());
        if (type != null) {
            value = Converter.convert(type, (Object)value);
        }
        this.value = value;
    }

    public Model toModel() {
        if (this.isReference()) {
            switch (this.getMode()) {
                case 1: {
                    Object target;
                    if (!(this.value instanceof Map)) break;
                    Model model = new Model(this.name, new Object[0]);
                    model.modelLabel(this.label);
                    model.modelDescription(this.description);
                    Map params = (Map)this.value;
                    ArrayList paramMetas = new ArrayList((List)params.get("metas"));
                    Object source = params.get("source");
                    if (source != null) {
                        paramMetas.add(source);
                    }
                    if ((target = params.get("target")) != null) {
                        paramMetas.add(target);
                    }
                    model.metas().set((Metas)MetasConversion.getInstance().convert(paramMetas));
                    return model;
                }
            }
        } else {
            switch (this.getMode()) {
                case 2: {
                    Model model = new Model(this.code, new Object[0]);
                    model.modelLabel(this.label);
                    model.modelDescription(this.description);
                    model.meta(true, MetaAssembler.createMeta(ID, 3, 1));
                    Meta meta = new Meta(this.label, VALUE, this.type, this.length, this.scale, this.code, 0, this.description);
                    meta.options().set(3, 4);
                    model.meta(true, meta);
                    return model;
                }
            }
        }
        return null;
    }

    public Meta clone() {
        Meta meta;
        try {
            meta = (Meta)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Asserts.state((String)"Failure to clone meta", (Object[])new Object[]{e});
        }
        meta.options = this.options().clone();
        return meta;
    }

    public static Meta create(String affix) {
        Artifact artifact;
        Meta meta = new Meta();
        if (Strings.isNotEmpty((Object)affix) && (artifact = Depository.getArtifact((Raw)new TextRaw(affix))) != null) {
            meta = (Meta)artifact.transform(Meta.class);
        }
        return meta;
    }

    public static Meta createMeta(String fieldName, Object ... args) {
        return Meta.createMeta(Meta.class, fieldName, args);
    }

    public static Meta createMeta(Class<?> clazz, String fieldName, Object ... args) {
        Meta meta = Meta.createMeta(Reflects.getBoundField(clazz, (String)fieldName));
        meta.set(args);
        return meta;
    }

    public static Meta createMeta(BoundField field) {
        Meta meta = Meta.create(field.getAffix());
        if (Strings.isEmpty((Object)meta.name)) {
            meta.name = field.getAlias();
            if (Strings.isEmpty((Object)meta.name)) {
                meta.name = Strings.toColumnName((String)field.getName());
            }
        }
        if (Strings.isEmpty((Object)meta.type)) {
            meta.type = field.getField().getType().getSimpleName();
        }
        meta.field = field;
        return meta;
    }

    static {
        Converter.addConversion((Conversion)OptionsConversion.getInstance());
    }
}

