/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.stub.model;

import java.util.HashMap;
import java.util.Map;
import net.isger.brick.stub.model.Meta;
import net.isger.brick.stub.model.Metas;

public class MetaAssembler {
    public static final String ID = "id";
    public static final String DESCRIPTION = "description";
    public static final String INPUT_TIME = "input_time";
    private static final Map<Class<?>, MetaAssembler> ASSEMBLERS = new HashMap();
    public static final MetaAssembler base = new MetaAssembler();
    private Metas metas = new Metas();

    protected MetaAssembler() {
        Class<?> clazz = this.getClass();
        if (MetaAssembler.getAssembler(clazz) != null) {
            throw new IllegalStateException("Exists meta assembler " + clazz);
        }
        ASSEMBLERS.put(clazz, this);
    }

    public void add(Object ... args) {
        this.metas.add(args);
    }

    public void put(String name, Object ... args) {
        this.metas.put(name, args);
    }

    public static final MetaAssembler getAssembler(Class<?> clazz) {
        return ASSEMBLERS.get(clazz);
    }

    public static Meta createMeta(String name, Object ... options) {
        return MetaAssembler.createMeta(MetaAssembler.class, name, options);
    }

    public static final Meta createMeta(Class<?> clazz, String name, Object ... options) {
        MetaAssembler assembler = MetaAssembler.getAssembler(clazz);
        if (assembler == null) {
            if (!ASSEMBLERS.containsKey(clazz)) {
                try {
                    Class.forName(clazz.getName());
                }
                catch (Exception e) {
                    ASSEMBLERS.put(clazz, null);
                }
                return MetaAssembler.createMeta(clazz, name, options);
            }
            return null;
        }
        Meta meta = assembler.metas.get(name);
        if (meta != null) {
            meta.options().set(options);
        }
        return meta;
    }

    static {
        base.add("\u6807\u8bc6", ID, "string", 20, 0);
        base.add("\u63cf\u8ff0", DESCRIPTION, "string");
        base.add("\u5165\u5e93\u65f6\u95f4", INPUT_TIME, "date");
    }
}

