/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.stub.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.isger.brick.stub.model.Meta;
import net.isger.brick.stub.model.Model;
import net.isger.util.Helpers;
import net.isger.util.Reflects;
import net.isger.util.Strings;
import net.isger.util.anno.Alias;
import net.isger.util.reflect.BoundField;

public class Metas
implements Cloneable {
    private Map<String, Object> metas = new HashMap<String, Object>();

    public Metas() {
    }

    public Metas(List<Object> metas) {
        this();
        if (metas != null) {
            for (Object meta : metas) {
                if (meta instanceof Meta) {
                    this.add((Meta)meta);
                    continue;
                }
                if (!(meta instanceof Object[])) continue;
                this.add((Object[])meta);
            }
        }
    }

    void add(Object ... args) {
        this.put((String)args[1], args);
    }

    void put(String name, Object ... args) {
        this.metas.put(name, args);
    }

    public void add(Meta meta) {
        this.put(null, meta);
    }

    public void put(String name, Meta meta) {
        if (Strings.isEmpty((Object)name)) {
            Class<?> clazz = meta.getClass();
            Alias alias = clazz.getAnnotation(Alias.class);
            String string = name = alias == null || clazz == Meta.class ? meta.getName() : alias.value();
            if (Strings.isEmpty((Object)name)) {
                name = Strings.replaceIgnoreCase((String)clazz.getSimpleName(), (String)"Meta$", (String)"");
            }
        }
        if (name.indexOf(46) != -1) {
            throw new IllegalArgumentException("Invalid meta alias " + name);
        }
        this.metas.put(name, meta);
    }

    public void set(Metas metas) {
        this.metas.clear();
        if (metas != null) {
            this.metas.putAll(metas.metas);
        }
    }

    public Meta get(String name) {
        Object meta = this.metas.get(name);
        if (meta instanceof Object[]) {
            meta = new Meta((Object[])meta);
        }
        return (Meta)meta;
    }

    public List<String> names() {
        return new ArrayList<String>(this.metas.keySet());
    }

    public List<Meta> values() {
        ArrayList<Meta> metas = new ArrayList<Meta>();
        for (String name : this.metas.keySet()) {
            metas.add(this.get(name));
        }
        return metas;
    }

    public int size() {
        return this.metas.size();
    }

    public static Metas getMetas(Object table) {
        if (table instanceof Model && ((Model)((Object)table)).isModel()) {
            return ((Model)((Object)table)).metas();
        }
        if (!(table instanceof Class)) {
            table = table.getClass();
        }
        Metas metas = new Metas();
        Map boundFields = Reflects.getBoundFields(table);
        if (boundFields != null) {
            ArrayList fields = new ArrayList(boundFields.values());
            for (List field : fields) {
                metas.add(Meta.createMeta((BoundField)field.get(0)));
            }
        }
        return metas;
    }

    public Metas clone() {
        Metas metas;
        try {
            metas = (Metas)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Failure to clone metas", e);
        }
        metas.metas = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.metas.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Meta) {
                value = ((Meta)value).clone();
            } else if (value instanceof Object[]) {
                value = Helpers.newArray((Object)value);
            }
            metas.metas.put(entry.getKey(), value);
        }
        return metas;
    }
}

