/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.stub.model;

import java.util.HashMap;
import java.util.Map;
import net.isger.brick.stub.model.Meta;
import net.isger.brick.stub.model.Metas;
import net.isger.brick.stub.model.MetasConversion;
import net.isger.raw.Artifact;
import net.isger.raw.Depository;
import net.isger.raw.Raw;
import net.isger.raw.TextRaw;
import net.isger.util.Sqls;
import net.isger.util.Strings;
import net.isger.util.anno.Affix;
import net.isger.util.anno.Alias;
import net.isger.util.reflect.Converter;
import net.isger.util.reflect.conversion.Conversion;

@Alias(value="t_brick_stub_model")
public class Model
implements Cloneable {
    @Affix(value="{length : 20, options : [1, 3]}")
    private String id;
    @Affix(value="{length : 50}")
    private String label;
    @Affix(value="{length : 50, options : [3, 4]}")
    private String name = Sqls.getTableName(this.getClass(), (String)"Model$");
    @Affix(value="{type : 'text'}")
    private String description;
    private transient Map<String, Object> schema;
    @Affix(value="{name : 't_brick_stub_item', type : 'reference', mode : 1, scale : 3, value : {source : {name : 'model_id', type : 'string', length : 20, options : 3, value : 't_brick_stub_model.id'}, target : {name : 'meta_id', type : 'string', length : 20, options : 3, value : 't_brick_stub_meta.id'}, metas : [{name : 'id', type : 'string', length : 20, options : [1, 3]}, {name : 'label', type : 'string', length : 50}, {name : 'name', type : 'string', length : 50}, {name : 'description', type : 'text'}]}}")
    private Metas metas = Metas.getMetas(this);

    public Model() {
        if (this.metas == null) {
            this.metas = new Metas();
        }
        this.schema = new HashMap<String, Object>();
    }

    public Model(Object[] metas) {
        this();
        this.metas(metas);
    }

    public Model(String name, Object ... metas) {
        this(metas);
        if (Strings.isNotEmpty((Object)name)) {
            this.name = name;
        }
    }

    protected Model(Map<String, Object> schema, Metas metas) {
        this();
        if (metas != null) {
            this.metas = metas;
        }
        if (schema != null) {
            this.schema.putAll(schema);
        }
        this.name = Strings.empty((Object)this.schemaValue("name"), (String)this.name);
    }

    public boolean isModel() {
        return Model.class != this.getClass() || !this.modelName().equalsIgnoreCase(Sqls.getTableName(Model.class));
    }

    public String modelId() {
        return this.id;
    }

    public void modelId(String id) {
        this.id = id;
    }

    public String modelLabel() {
        return this.label;
    }

    public void modelLabel(String label) {
        this.label = label;
    }

    public String modelName() {
        return this.name;
    }

    public void modelName(String name) {
        this.name = name;
    }

    public String modelDescription() {
        return this.description;
    }

    public void modelDescription(String description) {
        this.description = description;
    }

    public Object schemaValue(String name) {
        return this.schema.get(name);
    }

    public void schemaValue(String name, Object value) {
        this.schema.put(name, value);
    }

    public Metas metas() {
        return this.metas;
    }

    public void metas(Object[] metas) {
        for (Object instance : metas) {
            boolean isBelong;
            Meta meta;
            if (instance instanceof Object[]) {
                meta = new Meta((Object[])instance);
                isBelong = true;
            } else if (instance instanceof Meta) {
                meta = ((Meta)instance).clone();
                isBelong = false;
            } else {
                throw new IllegalArgumentException(String.valueOf(instance));
            }
            this.meta(isBelong, meta);
        }
    }

    public void meta(Meta meta) {
        this.meta(false, null, meta);
    }

    public void meta(boolean isBelong, Meta meta) {
        this.meta(isBelong, null, meta);
    }

    public void meta(String name, Meta meta) {
        this.meta(false, name, meta);
    }

    public void meta(boolean isBelong, String name, Meta meta) {
        if (Strings.isEmpty((Object)name)) {
            name = meta.getName();
        }
        if (isBelong) {
            meta.setCode(this.modelName() + "$" + name);
        }
        this.metas.put(name, meta);
    }

    public Meta meta(String name) {
        return this.metas.get(name);
    }

    public Object metaValue(String name) {
        return this.meta(name).getValue();
    }

    public void metaValue(String name, Object value) {
        this.meta(name).setValue(value);
    }

    public void metaValue(Map<?, ?> values) {
        for (String name : this.metas().names()) {
            this.metaValue(name, values.get(values.containsKey(name) ? name : Strings.toFieldName((String)name)));
        }
    }

    public void metaEmpty() {
        for (Meta meta : this.metas().values()) {
            meta.setValue(null);
        }
    }

    public Model clone() {
        Model model;
        try {
            model = (Model)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Failure to clone model", e);
        }
        model.metas = this.metas.clone();
        return model;
    }

    public static String getName(Object instance) {
        return Model.create(instance).modelName();
    }

    public static Model create(Object instance) {
        Artifact artifact;
        if (instance instanceof Model) {
            return (Model)instance;
        }
        if (instance instanceof String) {
            return new Model((String)instance, new Object[0]);
        }
        Class<?> table = instance instanceof Class ? (Class<?>)instance : instance.getClass();
        HashMap<String, Object> schema = new HashMap<String, Object>();
        Affix affix = table.getAnnotation(Affix.class);
        if (affix != null && (artifact = Depository.getArtifact((Raw)new TextRaw(Strings.empty((Object)affix.value())))) != null) {
            schema.putAll((Map)artifact.transform(Map.class));
        }
        if (Strings.isEmpty(schema.get("name"))) {
            schema.put("name", Sqls.getTableName(table));
        }
        return new Model(schema, Metas.getMetas(table));
    }

    static {
        Converter.addConversion((Conversion)MetasConversion.getInstance());
    }
}

