/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.task;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.isger.brick.core.BaseCommand;
import net.isger.brick.core.Console;
import net.isger.brick.core.Context;
import net.isger.brick.task.Task;
import net.isger.brick.task.TaskCommand;
import net.isger.brick.util.CommandOperator;
import net.isger.util.anno.Alias;
import net.isger.util.anno.Ignore;

public class BaseTask
implements Task {
    @Ignore(mode=Ignore.Mode.INCLUDE)
    @Alias(value="system")
    private Console console;
    @Ignore(mode=Ignore.Mode.INCLUDE)
    private CommandOperator operator = new CommandOperator(this);
    private volatile ExecutorService executor = Executors.newCachedThreadPool();
    private volatile ExecutorService daemonor = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    });

    public void initial() {
    }

    @Override
    public void operate(TaskCommand cmd) {
        this.operator.operate(cmd);
    }

    public void submit(TaskCommand cmd) {
        final BaseCommand task = BaseCommand.cast(cmd.getCommand());
        final net.isger.util.Callable callback = cmd.getCallback();
        final Context context = Context.getAction();
        cmd.setResult((cmd.getDaemon() ? this.daemonor : this.executor).submit(task == null ? new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Context.setAction(context);
                return callback.call();
            }
        } : new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                BaseTask.this.console.execute(task);
                Context.setAction(context);
                return callback == null ? task.getResult() : callback.call(new Object[]{task});
            }
        }));
    }

    public void destroy() {
        this.executor.shutdownNow();
        this.daemonor.shutdownNow();
    }
}

