/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.task;

import java.util.Map;
import net.isger.brick.core.AbstractModule;
import net.isger.brick.core.BaseCommand;
import net.isger.brick.inject.ConstantStrategy;
import net.isger.brick.task.BaseTask;
import net.isger.brick.task.Task;
import net.isger.brick.task.TaskCommand;
import net.isger.util.Asserts;
import net.isger.util.reflect.ClassAssembler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskModule
extends AbstractModule {
    private static final String TASK = "task";
    private static final Logger LOG = LoggerFactory.getLogger(TaskModule.class);

    public Class<? extends Task> getTargetClass() {
        return Task.class;
    }

    public Class<? extends Task> getImplementClass() {
        return this.getImplementClass(TASK);
    }

    public Class<? extends Task> getBaseClass() {
        return BaseTask.class;
    }

    @Override
    protected Object create(Class<?> clazz, Map<String, Object> res, ClassAssembler assembler) {
        Task task = (Task)super.create(clazz, res, assembler);
        this.setTask(task);
        return task;
    }

    protected Task getTask() {
        return this.container.getInstance(this.getTargetClass(), "system");
    }

    protected void setTask(Task task) {
        Asserts.isNotNull((Object)task, (String)"The task cannot be null", (Object[])new Object[0]);
        if (LOG.isDebugEnabled()) {
            LOG.info("Achieve task [{}]", (Object)task);
        }
        this.setTask(Task.class, "system", task);
    }

    private void setTask(Class<?> type, String name, Object task) {
        task = ConstantStrategy.set(this.container, type, name, task);
        if (LOG.isDebugEnabled() && task != null) {
            LOG.info("(!) Discard task [{}]", task);
        }
    }

    @Override
    protected Task create() {
        return (Task)super.create();
    }

    @Override
    public void initial() {
        super.initial();
        Task task = this.getTask();
        if (task == null) {
            this.setTask(this.create());
            task = this.getTask();
        }
        task.initial();
    }

    @Override
    public final void execute(BaseCommand cmd) {
        TaskCommand payload = (TaskCommand)cmd;
        if (payload.getCallback() == null && payload.getCommand() == null) {
            super.execute(payload);
        } else {
            Task task = this.getTask();
            this.setInternal("brick.core.task", task);
            task.operate(payload);
        }
    }

    @Override
    public void destroy() {
        Task task = this.getTask();
        if (task != null) {
            task.destroy();
        }
        super.destroy();
    }
}

