/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.util;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.isger.brick.util.anno.Digest;
import net.isger.util.Asserts;
import net.isger.util.Callable;
import net.isger.util.Files;
import net.isger.util.Strings;

public class ContentLibrary {
    private transient ExecutorService service;
    private transient File root;
    private transient File carryDir;
    private transient File sourceDir;
    private int threads;
    private String workspace;

    @Digest
    private void initial() {
        this.threads = Math.max(Math.min(10, this.threads), 10);
        this.service = Executors.newFixedThreadPool(this.threads);
        if (Strings.isEmpty((Object)this.workspace)) {
            this.workspace = "./content-libary";
        }
        this.root = new File(this.workspace);
        if (this.root.exists() && !this.root.isDirectory()) {
            throw Asserts.argument((String)"Invalid workspace path [%s]", (Object[])new Object[]{this.workspace});
        }
        this.carryDir = new File(this.root, "carry");
        this.sourceDir = new File(this.root, "source");
        this.carryDir.mkdirs();
        this.sourceDir.mkdirs();
    }

    public Future<?> carry(String namespace, String name, File file) {
        return this.carry(namespace, name, file, null);
    }

    public Future<?> carry(final String namespace, final String name, File file, final Callable<String> callable) {
        if (file == null || !file.exists() || !file.isFile()) {
            return null;
        }
        final File carryFile = new File(this.carryDir, file.getName());
        Files.rename((File)file, (File)carryFile);
        return this.service.submit(new Runnable(){

            @Override
            public void run() {
                String file;
                File sourcePath;
                block7: {
                    block6: {
                        sourcePath = new File(ContentLibrary.this.sourceDir, namespace + File.separatorChar + name);
                        if (!sourcePath.exists()) break block6;
                        if (sourcePath.isDirectory()) break block7;
                        Files.delete((File)sourcePath);
                    }
                    Files.mkdirs((File)sourcePath);
                }
                if (callable == null) {
                    file = carryFile.getName();
                } else {
                    file = (String)callable.call(new Object[]{namespace, name, carryFile, sourcePath});
                    if (Strings.isEmpty((Object)file)) {
                        return;
                    }
                    sourcePath = new File(sourcePath, file);
                }
                ContentLibrary.this.remove(namespace, name, file);
                Files.rename((File)carryFile, (File)sourcePath);
            }
        });
    }

    public void remove(String namespace, String name) {
        Files.delete((File)new File(this.sourceDir, namespace + File.separatorChar + name));
    }

    public void remove(String namespace, String name, String file) {
        Files.delete((File)new File(this.sourceDir, namespace + File.separatorChar + name + File.separatorChar + file));
    }

    public File source(String namespace, String name, String file) {
        return this.get(this.sourceDir, namespace + File.separatorChar + name + File.separatorChar + file);
    }

    private File get(File dir, String path) {
        File file = new File(dir, path);
        if (!file.exists()) {
            file = null;
        }
        return file;
    }
}

