/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.isger.brick.util.DesignLoader;
import net.isger.util.Reflects;
import net.isger.util.Scans;
import net.isger.util.Strings;
import net.isger.util.reflect.ClassAssembler;
import net.isger.util.scan.ScanFilter;

public class ScanLoader
extends DesignLoader {
    public static final String PARAM_PATH = "path";
    private ScanFilter filter;

    public ScanLoader(ScanFilter filter) {
        this(null, filter);
    }

    public ScanLoader(Class<?> targetClass, ScanFilter filter) {
        super(targetClass);
        this.filter = filter;
    }

    @Override
    protected Object create(Class<?> clazz, Map<String, Object> res, ClassAssembler assembler) {
        HashMap<String, Object> result = null;
        if (this.hasScan(clazz, res)) {
            HashMap<String, Object> container = new HashMap<String, Object>();
            Object config = res.get(PARAM_PATH);
            if (config != null) {
                res.remove(PARAM_PATH);
                if (config instanceof String) {
                    container.putAll(this.scan((String)config, res, assembler));
                } else if (config instanceof Collection) {
                    for (Object path : (Collection)config) {
                        if (!(path instanceof String)) {
                            throw new IllegalArgumentException("Invalid config");
                        }
                        container.putAll(this.scan((String)path, res, assembler));
                    }
                } else {
                    throw new IllegalArgumentException("Invalid config");
                }
            }
            result = container;
        } else {
            result = this.make(clazz, res, assembler);
        }
        return result;
    }

    protected Object create(Object res, ClassAssembler assembler) {
        if (res instanceof String) {
            return this.scan((String)res, null, assembler);
        }
        return super.create(res, assembler);
    }

    protected boolean hasScan(Class<?> clazz, Map<String, Object> res) {
        return (clazz == this.getTargetClass() || !res.containsKey("class")) && res.containsKey(PARAM_PATH);
    }

    protected Map<String, Object> scan(String path, Map<String, Object> res, ClassAssembler assembler) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String name : Scans.scan((String)path.replaceAll("[.\\\\]", "/"), (ScanFilter)this.filter)) {
            name = Strings.replaceIgnoreCase((String)name, (String)"[.]class$").replaceAll("[\\\\/]", ".");
            String className = path.replaceAll("[\\\\/]", ".") + name;
            Object instance = this.make(Reflects.getClass((String)className), res, assembler);
            if (instance == null) continue;
            result.put(name.replaceFirst("^[.]", ""), instance);
        }
        return result;
    }

    protected Object make(Class<?> clazz, Map<String, Object> res, ClassAssembler assembler) {
        if (Reflects.isAbstract(clazz)) {
            return null;
        }
        return super.create(clazz, res, assembler);
    }

    protected List<Object> toList(Object instance) {
        ArrayList<Object> result;
        if (instance instanceof List) {
            result = (ArrayList<Object>)instance;
        } else {
            result = new ArrayList<Object>();
            result.add(instance);
        }
        return result;
    }
}

