/*
 * Decompiled with CFR 0.152.
 */
package net.isger.raw;

import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import net.isger.raw.Artifact;
import net.isger.raw.GsonAdapter;
import net.isger.raw.Raw;
import net.isger.util.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonArtifact
implements Artifact {
    private static final Logger LOG = LoggerFactory.getLogger(GsonArtifact.class);
    private GsonBuilder builder;
    private Raw raw;

    public GsonArtifact(Raw raw) {
        this.raw = raw;
        this.builder = new GsonBuilder();
        this.builder.registerTypeAdapterFactory(GsonAdapter.FACTORY);
    }

    public Raw getRaw() {
        return this.raw;
    }

    public <T> T transform(Class<T> type) {
        return (T)this.transform((Type)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object transform(Type type) {
        Object result = null;
        Raw raw = this.getRaw();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(raw.getInputStream());
            result = this.builder.create().fromJson((Reader)reader, type);
        }
        catch (Exception e) {
            try {
                LOG.warn("(!) Unable to transform [{}]", raw.getSource(), (Object)e.getCause());
            }
            catch (Throwable throwable) {
                Files.close(reader);
                throw throwable;
            }
            Files.close((Closeable)reader);
        }
        Files.close((Closeable)reader);
        return result;
    }
}

