/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.auth;

import java.util.Collection;
import java.util.List;
import net.isger.brick.auth.AuthCommand;
import net.isger.brick.auth.AuthInfo;
import net.isger.brick.auth.ShiroToken;
import net.isger.brick.core.Command;
import net.isger.brick.core.Console;
import net.isger.util.Asserts;
import net.isger.util.Helpers;
import net.isger.util.anno.Alias;
import net.isger.util.anno.Ignore;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;

public class ShiroRealm
extends AuthorizingRealm {
    @Ignore(mode=Ignore.Mode.INCLUDE)
    @Alias(value="system")
    private Console console;

    public String getName() {
        return Helpers.getAliasName(((Object)((Object)this)).getClass(), (String)"Realm$");
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof ShiroToken;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        AuthCommand cmd = AuthCommand.newAction();
        cmd.setOperate("auth");
        List token = principals.asList();
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        switch (token.size()) {
            case 1: {
                if (!(token.get(0) instanceof AuthInfo)) break;
                this.addAuthInfo(info, (AuthInfo)token.get(0));
            }
            case 0: {
                return info;
            }
        }
        cmd.setToken((Object)token);
        try {
            this.console.execute((Command)cmd);
            if (cmd.getResult() instanceof AuthInfo) {
                this.addAuthInfo(info, (AuthInfo)cmd.getResult());
            }
        }
        catch (Exception e) {
            throw Asserts.state((String)"Failure to get authorization info", (Object[])new Object[]{e});
        }
        return info;
    }

    private void addAuthInfo(SimpleAuthorizationInfo info, AuthInfo authInfo) {
        info.addRoles((Collection)authInfo.getRoles());
        info.addStringPermissions((Collection)authInfo.getPermissions());
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        return new SimpleAuthenticationInfo(token.getPrincipal(), token.getCredentials(), this.getName());
    }
}

