/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.bus;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.isger.brick.bus.NettyEndpoint;
import net.isger.brick.core.Handler;
import net.isger.util.Asserts;
import net.isger.util.Helpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyInbound
extends NettyEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(NettyInbound.class);
    private transient AbstractBootstrap<?, ?> bootstrap;
    private transient EventLoopGroup loop;
    private transient Channel service;
    private transient Handler channeler;

    @Override
    protected final void open() {
        super.open();
        InetSocketAddress address = this.getAddress();
        try {
            while (!this.console.hasReady()) {
                Helpers.sleep((long)200L);
            }
            LOG.info("Listening [{}://{}]", (Object)this.getProtocolName(), (Object)address);
            this.service = this.bootstrap.bind().sync().channel();
            this.channeler.handle((Object)this.service);
        }
        catch (Exception e) {
            throw Asserts.state((String)"Failure to bind [%s]", (Object[])new Object[]{address, e});
        }
    }

    @Override
    protected final void bootstrap(ChannelInitializer<Channel> initializer) {
        this.loop = new NioEventLoopGroup();
        if ("udp".equalsIgnoreCase(this.getChannel())) {
            this.bootstrap = ((Bootstrap)((Bootstrap)new Bootstrap().group(this.loop)).channelFactory((ChannelFactory)new ChannelFactory<Channel>(){

                public Channel newChannel() {
                    return NettyInbound.this.newDatagramChannel();
                }
            })).handler(initializer);
            this.bootstrap.localAddress(this.getAddress().getPort());
            this.bootstrap.option(ChannelOption.IP_MULTICAST_LOOP_DISABLED, (Object)false);
            this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
            this.channeler = new Handler(){

                public Object handle(Object message) {
                    NettyInbound.this.open((DatagramChannel)message);
                    return null;
                }
            };
        } else {
            this.bootstrap = ((ServerBootstrap)new ServerBootstrap().group(this.loop, (EventLoopGroup)new NioEventLoopGroup()).channelFactory((ChannelFactory)new ChannelFactory<ServerChannel>(){

                public ServerChannel newChannel() {
                    return NettyInbound.this.newServerChannel();
                }
            })).childHandler(initializer);
            this.bootstrap.localAddress((SocketAddress)this.getAddress());
            this.channeler = new Handler(){

                public Object handle(Object message) {
                    NettyInbound.this.open((ServerChannel)message);
                    return null;
                }
            };
        }
    }

    protected DatagramChannel newDatagramChannel() {
        return new NioDatagramChannel(InternetProtocolFamily.IPv4);
    }

    protected void open(DatagramChannel channel) {
        InetSocketAddress address = this.getAddress();
        address.getHostName();
        try {
            channel.joinGroup(this.getAddress(), this.getNetworkInterface()).sync();
        }
        catch (Exception e) {
            throw Asserts.state((String)e.getMessage(), (Object[])new Object[]{e.getCause()});
        }
    }

    protected ServerChannel newServerChannel() {
        return new NioServerSocketChannel();
    }

    protected void open(ServerChannel channel) {
    }

    @Override
    protected void send(ChannelHandlerContext context, Object message) {
    }

    @Override
    protected void close() {
        if (this.service != null) {
            this.service.close();
            this.service = null;
        }
        this.loop.shutdownGracefully();
        super.close();
    }
}

