/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.plugin.persist;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.isger.brick.plugin.persist.Persist;
import net.isger.util.Helpers;
import net.isger.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Persists {
    private static final Logger LOG = LoggerFactory.getLogger(Persists.class);
    private Map<String, Persist> persists = new HashMap<String, Persist>();

    public Persists() {
        this(null);
    }

    public Persists(List<Object> persists) {
        if (persists != null) {
            for (Object instance : persists) {
                if (instance instanceof Persist) {
                    this.add((Persist)instance);
                    continue;
                }
                if (!(instance instanceof Map)) continue;
                for (Map.Entry entry : ((Map)instance).entrySet()) {
                    instance = entry.getValue();
                    if (!(instance instanceof Persist)) continue;
                    this.put((String)entry.getKey(), (Persist)instance);
                }
            }
        }
    }

    public void add(Persist persist) {
        this.put("", persist);
    }

    public void put(String name, Persist persist) {
        String key;
        int index = name.lastIndexOf(".");
        if (index++ > 0) {
            key = name.substring(0, index);
            name = name.substring(index);
        } else {
            key = "";
        }
        key = key + Persists.getName(persist.getClass(), name);
        if (LOG.isDebugEnabled()) {
            LOG.info("Binding [{}] persist [{}]", (Object)key, (Object)persist);
        }
        if ((persist = this.persists.put(key, persist)) != null) {
            LOG.warn("(!) Discard [{}] service [{}]", (Object)key, (Object)persist);
        }
    }

    public Persist get(String name) {
        return this.persists.get(name);
    }

    public Collection<Persist> values() {
        return this.persists.values();
    }

    public Set<Map.Entry<String, Persist>> entrySet() {
        return this.persists.entrySet();
    }

    public static final String getName(Class<? extends Persist> clazz) {
        return Persists.getName(clazz, "");
    }

    public static final String getName(Class<? extends Persist> clazz, String name) {
        return Helpers.getAliasName(clazz, (String)"Persist$", (String)Strings.toLower((String)name));
    }
}

