/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util;

import java.lang.reflect.Type;
import net.isger.util.Helpers;
import net.isger.util.Strings;

public class Asserts {
    private Asserts() {
    }

    public static void isFalse(boolean expression) {
        Asserts.isFalse(expression, "The expression must be false", new Object[0]);
    }

    public static void isFalse(boolean expression, String message, Object ... args) {
        Asserts.isTrue(!expression, message, args);
    }

    public static void isTrue(boolean expression) {
        Asserts.isTrue(expression, "The expression must be true", new Object[0]);
    }

    public static void isTrue(boolean expression, String message, Object ... args) {
        Asserts.throwArgument(expression, message, args);
    }

    public static <T> T isNull(T value) {
        return Asserts.isNull(value, "The argument [%s] must be null", new Object[0]);
    }

    public static <T> T isNull(T value, String message, Object ... args) {
        Asserts.throwArgument(value == null, message, (Object[])Helpers.newArray(value, args));
        return value;
    }

    public static <T> T isNotNull(T value) {
        return Asserts.isNotNull(value, "The argument not be null", new Object[0]);
    }

    public static <T> T isNotNull(T value, String message, Object ... args) {
        Asserts.throwArgument(value != null, message, args);
        return value;
    }

    public static <T> String isEmpty(T value) {
        return Asserts.isEmpty(value, "The argument [%s] must be null or empty", new Object[0]);
    }

    public static <T> String isEmpty(T value, String message, Object ... args) {
        Asserts.throwArgument(Strings.isEmpty(value), message, (Object[])Helpers.newArray(value, args));
        return "";
    }

    public static <T> String isNotEmpty(T value) {
        return Asserts.isNotEmpty(value, "The argument not be null or empty", new Object[0]);
    }

    public static <T> String isNotEmpty(T value, String message, Object ... args) {
        Asserts.throwArgument(Strings.isNotEmpty(value), message, args);
        return Strings.empty(value.toString());
    }

    public static String isNotContains(String source, String value) {
        return Asserts.isNotContains(source, value, "The source must not contain the substring [%s]", value);
    }

    public static String isNotContains(String source, String value, String message, Object ... args) {
        Asserts.throwArgument(Strings.isEmpty(source) || Strings.isEmpty(value) || !source.contains(value), message, args);
        return source;
    }

    public static void isInstance(Class<?> clazz, Object instance) {
        Asserts.isInstance(clazz, instance, "", new Object[0]);
    }

    public static void isInstance(Class<?> type, Object instance, String message, Object ... args) {
        Asserts.isNotNull(type, "Type to check against must not be null", new Object[0]);
        Asserts.throwArgument(type.isInstance(instance), "%sinstance of class [%s] must be an instance of %s", Strings.isEmpty(message) ? "" : Strings.format(message, args) + " - ", instance != null ? instance.getClass().getName() : "null", type);
    }

    public static void isAssignable(Class<?> superType, Class<?> subType) {
        Asserts.isAssignable(superType, subType, null, new Object[0]);
    }

    public static void isAssignable(Class<?> superType, Class<?> subType, String message, Object ... args) {
        message = Strings.isEmpty(message) ? "" : Strings.format(message, args) + " - ";
        Asserts.isNotNull(superType, "%sThe super type not be null", message);
        Asserts.isNotNull(subType, "%sThe sub type not be null for %s", message, superType);
        Asserts.throwArgument(superType.isAssignableFrom(subType), "%s%s is not assignable to %s", message, subType, superType);
    }

    public static void isNotPrimitive(Type type) {
        Asserts.throwArgument(!(type instanceof Class) || !((Class)type).isPrimitive(), "%s is primitive", type);
    }

    public static void throwArgument(boolean expression) {
        Asserts.throwArgument(expression, null, new Object[0]);
    }

    public static void throwArgument(boolean expression, String message, Object ... args) {
        if (!expression) {
            throw Asserts.argument(message, args);
        }
    }

    public static IllegalArgumentException argument(String message, Object ... args) {
        if (Strings.isEmpty(message)) {
            message = "The argument is invalid";
        }
        return new IllegalArgumentException("(X) " + Strings.format(message, args), Asserts.getCause(args));
    }

    public static void throwState(boolean expression) {
        Asserts.throwState(expression, null, new Object[0]);
    }

    public static void throwState(boolean expression, String message, Object ... args) {
        if (!expression) {
            throw Asserts.state(message, args);
        }
    }

    public static IllegalStateException state(String message, Object ... args) {
        if (Strings.isEmpty(message)) {
            message = "The state invariant must be true";
        }
        return new IllegalStateException("(X) " + Strings.format(message, args), Asserts.getCause(args));
    }

    public static Throwable getCause(Object[] args) {
        return args != null && args.length > 0 && args[args.length - 1] instanceof Throwable ? (Throwable)args[args.length - 1] : null;
    }
}

