/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util;

import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class Dates {
    private static final String[] DATE_PATTERNS = new String[]{"yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd", "yyyy-MM", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM/dd", "yyyy/MM", "yyyyMMddHHmmss", "yyyyMMddHHmm", "yyyyMMdd", "yyyyMM", "yyyy", "HH:mm:ss", "HH:mm", "EEE MMM dd HH:mm:ss zzz yyyy", "yyyy-MM-dd'T'HH:mm:ssXXX", "MMM dd, yyyy hh:mm:ss a"};
    public static final int PATTERN_DEFAULT = 0;
    public static final int PATTERN_COMMON = 1;
    public static final int PATTERN_COMMON_MINUTE = 2;
    public static final int PATTERN_COMMON_DATE = 3;
    public static final int PATTERN_COMMON_MONTH = 4;
    public static final int PATTERN_NORMAL = 5;
    public static final int PATTERN_NORMAL_MINUTE = 6;
    public static final int PATTERN_NORMAL_DATE = 7;
    public static final int PATTERN_NORMAL_MONTH = 8;
    public static final int PATTERN_COMPACT = 9;
    public static final int PATTERN_COMPACT_MINUTE = 10;
    public static final int PATTERN_COMPACT_DATE = 11;
    public static final int PATTERN_COMPACT_MONTH = 12;
    public static final int PATTERN_YEAR = 13;
    public static final int PATTERN_TIME = 14;
    public static final int PATTERN_TIME_MINUTE = 15;
    public static final int PATTERN_RFC_822 = 16;
    public static final int PATTERN_RFC_3339 = 17;
    public static final int PATTERN_APPEAR = 18;
    private static final int[] UNITS = new int[]{1, 1000, 60000, 3600000, 86400000};
    public static final int UNIT_MILLIS = 0;
    public static final int UNIT_SECOND = 1;
    public static final int UNIT_MINUTE = 2;
    public static final int UNIT_HOUR = 3;
    public static final int UNIT_DAY = 4;

    private Dates() {
    }

    public static String getPattern(int type) {
        if (type < 0 && type > DATE_PATTERNS.length) {
            type = 0;
        }
        return DATE_PATTERNS[type];
    }

    public static Date toDate(Object value) {
        Date date;
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            date = new Date(((Timestamp)value).getTime());
        } else if (value instanceof Date) {
            date = (Date)value;
        } else if (value instanceof Number) {
            date = new Date(((Number)value).longValue());
        } else {
            String source = String.valueOf(value);
            try {
                source = LocalDateTime.parse(source).format(DateTimeFormatter.ofPattern(DATE_PATTERNS[1]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            source = source.replaceFirst("\\d+([-/]?\\d+)T", " ").replaceAll("[\u5e74\u6708\u65e5]", "-").replaceAll("[\u65f6\u5206]", ":").replaceAll("\u79d2", "");
            date = Dates.parse(source, Locale.getDefault(Locale.Category.FORMAT));
            if (date == null && Locale.getDefault(Locale.Category.FORMAT) != Locale.ENGLISH) {
                date = Dates.parse(source, Locale.ENGLISH);
            }
        }
        return date;
    }

    private static Date parse(String source, Locale locale) {
        Date date = null;
        SimpleDateFormat parser = new SimpleDateFormat("", locale);
        parser.setLenient(true);
        ParsePosition pos = new ParsePosition(0);
        for (int i = 0; i < DATE_PATTERNS.length; ++i) {
            parser.applyPattern(DATE_PATTERNS[i]);
            pos.setIndex(0);
            date = parser.parse(source, pos);
            if (date != null && pos.getIndex() == source.length()) break;
        }
        return date;
    }

    public static String toString(Object date) {
        return Dates.toString(date, 0);
    }

    public static String toString(Object date, int selector) {
        return Dates.toString(Dates.toDate(date), selector);
    }

    public static String toString(int selector) {
        return Dates.toString(null, selector);
    }

    public static String toString(Date date) {
        return Dates.toString(date, 0);
    }

    public static String toString(Date date, int selector) {
        if (date == null) {
            date = new Date();
        }
        if (selector < 0 || selector >= DATE_PATTERNS.length) {
            selector = 0;
        }
        return Dates.toString(date, DATE_PATTERNS[selector]);
    }

    public static String toString(Date date, String pattern) {
        return new SimpleDateFormat(pattern).format(date);
    }

    public static Date getDate() {
        return Dates.getDate(null, 0L, 0);
    }

    public static Date getDate(long delay) {
        return Dates.getDate(null, delay, 0);
    }

    public static Date getDate(long delay, int unit) {
        return Dates.getDate(null, delay, unit);
    }

    public static Date getDate(Date startTime, long delay) {
        return Dates.getDate(startTime, delay, 0);
    }

    public static Date getDate(Date startTime, long delay, int unit) {
        if (unit < 0 || unit > 4) {
            unit = 4;
        }
        if (startTime == null) {
            startTime = new Date();
        }
        if (delay != 0L) {
            startTime = new Date(startTime.getTime() + delay * (long)UNITS[unit]);
        }
        return startTime;
    }

    public static long getGap(Date startTime, Date endTime) {
        return Dates.getGap(startTime, endTime, 4);
    }

    public static long getGap(Date startTime) {
        return Dates.getGap(startTime, 4);
    }

    public static long getGap(Date startTime, int unit) {
        return Dates.getGap(startTime, new Date(), unit);
    }

    public static long getGap(Date startTime, Date endTime, int unit) {
        if (unit < 0 || unit > 4) {
            unit = 4;
        }
        Calendar sc = Calendar.getInstance();
        sc.setTime(startTime);
        Calendar ec = Calendar.getInstance();
        ec.setTime(endTime);
        switch (unit) {
            case 4: {
                sc.set(11, 0);
                ec.set(11, 0);
            }
            case 3: {
                sc.set(12, 0);
                ec.set(12, 0);
            }
            case 2: {
                ec.set(13, 0);
                sc.set(13, 0);
            }
            case 1: {
                sc.set(14, 0);
                ec.set(14, 0);
            }
        }
        return (ec.getTimeInMillis() - sc.getTimeInMillis()) / (long)UNITS[unit];
    }

    public static Date getMin(Date source, int delay) {
        return Dates.getMin(source, delay, 4);
    }

    public static Date getMin(Date source, int delay, int unit) {
        return Dates.getMin(source, Dates.getDate(delay, unit));
    }

    public static Date getMin(Date source, Date target) {
        return source.getTime() >= target.getTime() ? target : source;
    }

    public static Date getMax(Date source, int delay) {
        return Dates.getMax(source, delay, 4);
    }

    public static Date getMax(Date source, int delay, int unit) {
        return Dates.getMax(source, Dates.getDate(delay, unit));
    }

    public static Date getMax(Date source, Date target) {
        return source.getTime() >= target.getTime() ? source : target;
    }
}

