/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.isger.util.Asserts;
import net.isger.util.Helpers;

public class Dependency {
    public static final String ROOT = "root";
    private volatile transient List<Object> stayings = new LinkedList<Object>();
    private List<Object> stays;
    private List<Object> nodes = new LinkedList<Object>();
    private Map<Object, List<Object>> dependencies;
    private Map<Object, List<Object>> bedependencies;

    public Dependency() {
        this.stays = new LinkedList<Object>();
        this.dependencies = new HashMap<Object, List<Object>>();
        this.bedependencies = new HashMap<Object, List<Object>>();
    }

    public List<Object> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public void addNode(Object node, Object ... dependencies) {
        this.addNode(node, Arrays.asList(dependencies));
    }

    public void addNode(Object node, List<Object> dependencies) {
        if (dependencies == null) {
            dependencies = new ArrayList<Object>();
        } else {
            Asserts.throwArgument(!dependencies.contains(node), "Dependencies cannot contain itself [%s]", node);
        }
        dependencies = Helpers.getMerge(this.dependencies.get(node), dependencies);
        this.addDependencies(node, dependencies);
        this.setDependencies(node, dependencies);
    }

    private void addDependencies(Object node, List<Object> dependencies) {
        this.dependencies.put(node, dependencies);
        for (Object dependency : dependencies) {
            List<Object> bedependencies = this.bedependencies.get(dependency);
            if (bedependencies == null) {
                bedependencies = new ArrayList<Object>();
                this.bedependencies.put(dependency, bedependencies);
            } else if (bedependencies.contains(node)) continue;
            bedependencies.add(node);
        }
    }

    private void setDependencies(Object node, List<Object> dependencies) {
        if (dependencies != null) {
            if ((dependencies = Helpers.getSurplus(this.nodes, dependencies)).size() == 0) {
                this.setNode(node);
            } else {
                for (Object dependency : dependencies) {
                    this.addStay(dependency);
                }
                this.addStay(node);
            }
        }
    }

    private void setNode(Object node) {
        List<Object> bedependencies;
        if (!this.nodes.contains(node)) {
            this.nodes.add(node);
        }
        if ((bedependencies = this.bedependencies.get(node)) != null) {
            for (Object bedependency : bedependencies) {
                this.setDependencies(bedependency, this.dependencies.get(bedependency));
            }
        }
        this.stays.remove(node);
    }

    private void addStay(Object node) {
        List<Object> bedependencies;
        Asserts.throwState(!this.stayings.contains(node), "Found the self-devourer: %s -> %s", this.stayings, node);
        this.stayings.add(node);
        this.nodes.remove(node);
        if (!this.stays.contains(node)) {
            this.stays.add(node);
        }
        if ((bedependencies = this.bedependencies.get(node)) != null) {
            for (Object bedependency : bedependencies) {
                this.addStay(bedependency);
            }
        }
        this.stayings.remove(node);
    }
}

