/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util;

import java.util.List;
import java.util.Map;
import net.isger.util.Asserts;
import net.isger.util.Operator;
import net.isger.util.Reflects;
import net.isger.util.anno.Ignore;
import net.isger.util.reflect.BoundMethod;

@Ignore
public class DynamicOperator
implements Operator {
    protected static final String METH_OPERATE = BoundMethod.makeMethodDesc("operate");
    private Object source;

    public DynamicOperator() {
        this.source = this;
    }

    public DynamicOperator(Object source) {
        Asserts.isNotNull(source, "The operator source not be null", new Object[0]);
        this.source = source;
    }

    private Map<String, List<BoundMethod>> getMethods() {
        return Reflects.getBoundMethods(this.getSource().getClass(), true);
    }

    protected final BoundMethod getMethod(String operate) {
        Map<String, List<BoundMethod>> methods = this.getMethods();
        if (methods.containsKey(operate)) {
            return methods.get(operate).get(0);
        }
        if (!BoundMethod.isMethodDesc(operate)) {
            return this.getMethod(BoundMethod.makeMethodDesc(operate));
        }
        return null;
    }

    @Override
    public void operate() {
        Asserts.throwState(this.getSource() != this, "No target operation", new Object[0]);
        this.operate(METH_OPERATE, new Object[0]);
    }

    protected Object operate(String operate, Object ... args) {
        BoundMethod method = this.getMethod(operate);
        Asserts.isNotNull(method, "Unfound the specified operate in the dynamic Operator [%s]", this.source.getClass().getName());
        return method.invoke(this.getSource(), args);
    }

    protected final Object getSource() {
        return this.source;
    }

    public Object clone() {
        DynamicOperator operator;
        try {
            operator = (DynamicOperator)super.clone();
            if (this == this.getSource()) {
                operator.source = operator;
            }
        }
        catch (CloneNotSupportedException e) {
            throw Asserts.state("Failure to clone operator", e);
        }
        return operator;
    }
}

