/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;

public class Files {
    private static final String PROP_TMPDIR = "java.io.tmpdir";
    private static final String PROP_USERDIR = "user.dir";

    private Files() {
    }

    public static String getBasePath() {
        return new File(System.getProperty(PROP_USERDIR)).getAbsolutePath();
    }

    public static String toPath(String value) {
        return value.replaceAll("[.]|\\\\", "/");
    }

    public static String toPath(String value, String name) {
        String path = Files.toPath(value);
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return path + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJar(String path) {
        JarInputStream jis = null;
        try {
            jis = Files.openJarIS(path);
            boolean bl = jis.getNextJarEntry() != null;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            Files.close(jis);
        }
    }

    public static JarOutputStream openJarOS(String path) throws IOException {
        JarOutputStream jos = null;
        try {
            jos = new JarOutputStream(new FileOutputStream(path));
        }
        catch (IOException e) {
            jos = new JarOutputStream(new URL(path).openConnection().getOutputStream());
        }
        return jos;
    }

    public static JarInputStream openJarIS(String path) throws IOException {
        JarInputStream jis = null;
        try {
            jis = new JarInputStream(new FileInputStream(path));
        }
        catch (IOException e) {
            jis = new JarInputStream(new URL(path).openStream());
        }
        return jis;
    }

    public static JarEntry get(JarInputStream jis, String name) throws IOException {
        JarEntry je;
        while ((je = jis.getNextJarEntry()) != null && (je.isDirectory() || !je.getName().equals(name))) {
        }
        return je;
    }

    public static List<JarEntry> search(JarInputStream jis, String regex) throws IOException {
        JarEntry je;
        ArrayList<JarEntry> entries = new ArrayList<JarEntry>();
        while ((je = jis.getNextJarEntry()) != null) {
            if (je.isDirectory() || !je.getName().matches(regex)) continue;
            entries.add(je);
        }
        return entries;
    }

    public static File getFile(String name) {
        File file = new File(name);
        if (!Files.isCanonical(file)) {
            file = null;
        }
        return file;
    }

    public static File getFile(String path, String name) {
        File file = new File(path, name);
        if (!Files.isCanonical(file)) {
            file = null;
        }
        return file;
    }

    public static String getCanonical(String path) {
        return Files.getCanonical(new File(path));
    }

    public static String getCanonical(File file) {
        String path;
        try {
            path = file.getCanonicalPath();
        }
        catch (Exception e) {
            path = null;
        }
        return path;
    }

    public static boolean isCanonical(String path) {
        return Files.getCanonical(path) != null;
    }

    public static boolean isCanonical(File file) {
        return Files.getCanonical(file) != null;
    }

    public static File createFile(String path) {
        return Files.createFile(Files.getFile(path));
    }

    public static File createFile(String path, String name) {
        return Files.createFile(Files.getFile(path, name));
    }

    public static File createFile(File file) {
        File parentDir = file.getParentFile();
        if (parentDir.exists() && parentDir.isDirectory() || parentDir.mkdirs()) {
            try {
                if (file.exists() && file.isFile() || file.createNewFile()) {
                    return file;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void delete(File file) {
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                Files.delete(subFile);
            }
        }
        if (file.exists()) {
            file.delete();
        }
    }

    public static File tmpdir() {
        return new File(System.getProperty(PROP_TMPDIR));
    }

    public static boolean mkdirs(File file) {
        return Files.mkdirs(file, false);
    }

    public static boolean mkdirs(File file, boolean force) {
        boolean result = false;
        if (Files.isCanonical(file)) {
            if (force) {
                Files.delete(file);
            }
            result = file.mkdirs();
        }
        return result;
    }

    public static File write(String path, String content) {
        return Files.write(path, content, false);
    }

    public static File write(String path, String content, boolean append) {
        return Files.write(Files.getFile(path), content, append);
    }

    public static File write(String path, String name, String content) {
        return Files.write(Files.getFile(path, name), content, false);
    }

    public static File write(String path, String name, String content, boolean append) {
        return Files.write(Files.getFile(path, name), content, append);
    }

    public static File write(File file, String content) {
        return Files.write(file, content, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File write(File file, String content, boolean append) {
        FileWriter writer = null;
        file = Files.createFile(file);
        try {
            writer = new FileWriter(file, append);
            writer.write(content);
        }
        catch (Exception e) {
            try {
                file = null;
            }
            catch (Throwable throwable) {
                Files.close(writer);
                throw throwable;
            }
            Files.close(writer);
        }
        Files.close(writer);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File write(File file, byte[] data) {
        FileOutputStream out = null;
        file = Files.createFile(file);
        try {
            out = new FileOutputStream(file);
            out.write(data);
        }
        catch (Exception e) {
            try {
                file = null;
            }
            catch (Throwable throwable) {
                Files.close(out);
                throw throwable;
            }
            Files.close(out);
        }
        Files.close(out);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File rename(File source, File target) {
        if (!source.exists()) {
            return null;
        }
        if (target.exists()) {
            if (target.isDirectory()) {
                target = new File(target, source.getName());
            }
            Files.delete(target);
        }
        if (!source.renameTo(target)) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(source);
                target = Files.copy((InputStream)is, target);
            }
            catch (FileNotFoundException e) {
                try {
                    target = null;
                }
                catch (Throwable throwable) {
                    Files.close(is);
                    throw throwable;
                }
                Files.close(is);
            }
            Files.close(is);
        }
        return target;
    }

    public static File copy(InputStream source, String target) {
        return Files.copy(source, Files.createFile(target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copy(InputStream source, File target) {
        FileOutputStream os = null;
        try {
            int size;
            os = new FileOutputStream(target);
            byte[] buffer = new byte[1024];
            while ((size = source.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, size);
                os.flush();
            }
        }
        catch (Exception e) {
            try {
                target = null;
            }
            catch (Throwable throwable) {
                Files.close(os);
                throw throwable;
            }
            Files.close(os);
        }
        Files.close(os);
        return target;
    }

    public static byte[] read(File file) throws IOException {
        return Files.read(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(InputStream is) throws IOException {
        ByteArrayOutputStream bs = null;
        byte[] buffer = new byte[1024];
        try {
            int size;
            bs = new ByteArrayOutputStream(1024);
            while ((size = is.read(buffer)) != -1) {
                bs.write(buffer, 0, size);
                bs.flush();
            }
        }
        catch (Throwable throwable) {
            Files.close(bs);
            throw throwable;
        }
        Files.close(bs);
        return bs.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Object instance) throws IOException {
        byte[] result = null;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream os = null;
        try {
            os = new ObjectOutputStream(buffer);
            os.writeObject(instance);
            result = buffer.toByteArray();
        }
        catch (Throwable throwable) {
            Files.close(os);
            Files.close(buffer);
            throw throwable;
        }
        Files.close(os);
        Files.close(buffer);
        return result;
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

