/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.inject.Named;
import net.isger.util.Asserts;
import net.isger.util.Callable;
import net.isger.util.Dates;
import net.isger.util.Extendable;
import net.isger.util.Files;
import net.isger.util.Ordered;
import net.isger.util.Reflects;
import net.isger.util.Securities;
import net.isger.util.Strings;
import net.isger.util.anno.Alias;
import net.isger.util.anno.Ignore;
import net.isger.util.anno.Order;
import net.isger.util.anno.Sensitive;
import net.isger.util.reflect.BoundField;
import net.isger.util.reflect.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helpers {
    public static final Logger LOG;
    public static final int SEED_DIGIT = 0;
    private static final Object UUID_LOCKED;
    private static int uuidSearial;
    private static final String REGEX_CODE = "[A-Z0-9]+(\\-[A-Z0-9]+)*";
    private static final String CODE_RADIX = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final char[] CODES;
    private static final int[][] CODES_LIMITS;
    public static final int MAX_RADIX;
    public static final int MIN_RADIX = 2;
    private static final Map<Character, Integer> DIGIT_INDECES;
    private static final ThreadLocal<Map<String, Object>> GSON_CONTEXT;
    private static final Gson GSON;
    private static final Map<String, Properties> CACHE_PROPERTIES;

    private Helpers() {
    }

    public static String parse(long value, int radix) {
        boolean negative;
        if (radix < 2 || radix > MAX_RADIX || radix == 10) {
            return Long.toString(value);
        }
        int size = 65;
        int pos = 64;
        char[] buffer = new char[65];
        boolean bl = negative = value < 0L;
        if (!negative) {
            value = -value;
        }
        while (value <= (long)(-radix)) {
            buffer[pos--] = CODES[(int)(-(value % (long)radix))];
            value /= (long)radix;
        }
        buffer[pos] = CODES[(int)(-value)];
        if (negative) {
            buffer[--pos] = 45;
        }
        return new String(buffer, pos, 65 - pos);
    }

    public static long parse(String value, int radix) {
        value = value.trim();
        int count = value.length();
        if (radix < 2 || radix > MAX_RADIX) {
            throw new NumberFormatException("Unsupported " + radix + " radix");
        }
        if (radix <= 36) {
            value = value.toLowerCase();
        }
        if (count == 0) {
            throw new NumberFormatException("Failure to parse [" + value + "] using " + radix + " radix");
        }
        long limit = -9223372036854775807L;
        boolean negative = false;
        int amount = 0;
        char v = value.charAt(0);
        if (v < '0') {
            if (v == '-') {
                negative = true;
                limit = Long.MIN_VALUE;
            } else if (v != '+' || count == 1) {
                throw new NumberFormatException("Failure to parse [" + value + "] using " + radix + " radix");
            }
            ++amount;
        }
        long result = 0L;
        long multmin = limit / (long)radix;
        while (amount < count) {
            Integer digit;
            if ((digit = DIGIT_INDECES.get(Character.valueOf(value.charAt(amount++)))) == null || digit < 0 || result < multmin) {
                throw new NumberFormatException("Failure to parse [" + value + "] using " + radix + " radix");
            }
            if ((result *= (long)radix) < limit + (long)digit.intValue()) {
                throw new NumberFormatException("Failure to parse [" + value + "] using " + radix + " radix");
            }
            result -= (long)digit.intValue();
        }
        return negative ? result : -result;
    }

    public static String toJson(Object instance) {
        return Helpers.toJson(instance, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toJson(Object instance, boolean desensitization) {
        ThreadLocal<Map<String, Object>> threadLocal = GSON_CONTEXT;
        synchronized (threadLocal) {
            String string;
            HashMap<String, Boolean> context = new HashMap<String, Boolean>();
            context.put("desensitization", desensitization);
            GSON_CONTEXT.set(context);
            try {
                string = GSON.toJson(instance);
                GSON_CONTEXT.set(null);
            }
            catch (Throwable throwable) {
                GSON_CONTEXT.set(null);
                throw throwable;
            }
            return string;
        }
    }

    public static Object fromJson(String json) {
        return Helpers.fromJson(json, Object.class);
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            if (Map.class.isAssignableFrom(clazz) || Collection.class.isAssignableFrom(clazz) || clazz.isArray() || clazz == Object.class) {
                return (T)GSON.fromJson(json, clazz);
            }
            if (Reflects.isGeneral(clazz)) {
                return (T)Converter.convert(clazz, JsonParser.parseString((String)json));
            }
            Map parameters = Helpers.fromJson(json, Map.class);
            T instance = Reflects.newInstance(clazz, parameters);
            if (instance instanceof Extendable) {
                ((Extendable)instance).setExtends(parameters);
            }
            return instance;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean toBoolean(Object value) {
        return value != null && (value instanceof Boolean ? (Boolean)value != false : Helpers.toInt(value) != 0 || Strings.equalsIgnoreCase(value.toString(), "t", "true", "y", "yes", "o", "on", "ok"));
    }

    public static int toInt(Object value) {
        return Helpers.toInt(value, 0);
    }

    public static int toInt(Object value, int def) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value != null) {
            try {
                def = Double.valueOf(value.toString()).intValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public static long toLong(Object value) {
        return Helpers.toLong(value, 0L);
    }

    public static long toLong(Object value, long def) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value != null) {
            try {
                def = Double.valueOf(value.toString()).longValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public static double toDouble(Object value) {
        return Helpers.toDouble(value, 0.0);
    }

    public static double toDouble(Object value, double def) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value != null) {
            try {
                def = Double.valueOf(value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public static String toHex(byte[] values) {
        StringBuffer buffer = new StringBuffer(values.length);
        for (byte value : values) {
            int hex = value & 0xFF;
            if (hex < 16) {
                buffer.append("0");
            }
            buffer.append(Integer.toHexString(hex));
        }
        return buffer.toString();
    }

    public static byte[] toHex(String hex) {
        int size = hex.length() / 2;
        byte[] result = new byte[size];
        char[] values = hex.toCharArray();
        for (int i = 0; i < size; ++i) {
            int offset = i * 2;
            byte radixHigh = Helpers.toRadix(values[offset]);
            byte radixLow = Helpers.toRadix(values[offset + 1]);
            if (radixHigh == -1 || radixLow == -1) {
                return null;
            }
            result[i] = (byte)(radixHigh << 4 | radixLow);
        }
        return result;
    }

    public static byte toRadix(char value) {
        return (byte)CODE_RADIX.indexOf(value);
    }

    public static String makeMD5(String value) {
        return Helpers.makeMD5(value.getBytes());
    }

    public static String makeMD5(byte[] value) {
        try {
            return Helpers.toHex(Securities.toDigest("MD5", value));
        }
        catch (Exception e) {
            throw Asserts.state("Failure to make MD5 for [%s] - %s", value, e.getMessage(), e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String makeUUID() {
        UUID uuid = UUID.randomUUID();
        StringBuilder buffer = new StringBuilder();
        long mostBits = uuid.getMostSignificantBits();
        buffer.append(Helpers.getDigits(mostBits >> 32, 8));
        buffer.append(Helpers.getDigits(mostBits >> 16, 4));
        buffer.append(Helpers.getDigits(mostBits, 4));
        long leastBits = uuid.getLeastSignificantBits();
        buffer.append(Helpers.getDigits(leastBits >> 48, 4));
        buffer.append(Helpers.getDigits(leastBits, 12));
        Object object = UUID_LOCKED;
        synchronized (object) {
            buffer.append(CODES[uuidSearial++]);
            uuidSearial %= MAX_RADIX;
        }
        return buffer.toString();
    }

    public static String makeMarchineCode() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Helpers.getCPUID());
        buffer.append(Helpers.getHDID());
        buffer.append(Files.getBasePath());
        return Helpers.makeMD5(buffer.toString());
    }

    private static String getDigits(long value, int bits) {
        long hi = 1L << bits * 4;
        return Helpers.parse(hi | value & hi - 1L, MAX_RADIX).substring(1);
    }

    public static String makeCode(int length) {
        return Helpers.makeCode(length, Helpers.getRandom());
    }

    public static String makeCode(int length, int seed) {
        StringBuffer code = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            code.append(Helpers.getRandomCode(seed));
        }
        return code.toString();
    }

    private static char getRandomCode(int seed) {
        return Helpers.getRandomCode(CODES_LIMITS[seed %= CODES_LIMITS.length][0], CODES_LIMITS[seed][1]);
    }

    private static char getRandomCode(int start, int limit) {
        return CODES[start + Helpers.getRandom(limit)];
    }

    public static int getRandom() {
        return Helpers.getRandom(0);
    }

    public static int getRandom(int limit) {
        int result;
        UUID uuid = UUID.randomUUID();
        Random random = new Random(uuid.getMostSignificantBits());
        int seed = Math.abs((int)(uuid.getLeastSignificantBits() % Integer.MAX_VALUE));
        while ((result = random.nextInt(seed)) < 0) {
        }
        return limit <= 0 ? result : result % limit;
    }

    public static int getBitCount(long value) {
        return Long.bitCount(value);
    }

    public static int getBitCount(byte[] bytes) {
        int count = 0;
        for (byte value : bytes) {
            count += Integer.bitCount(value & 0xFF);
        }
        return count;
    }

    public static URL getURL(File file) {
        try {
            return file.getAbsoluteFile().toURI().toURL();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static URL getPropertiesURL(boolean isXML, String name) {
        return Helpers.getPropertiesURL(isXML, null, name);
    }

    public static URL getPropertiesURL(boolean isXML, Object source, String name) {
        URL url = Reflects.getResource(source, name);
        if (url == null) {
            if (isXML) {
                if (!Strings.endWithIgnoreCase(name, "[.]xml")) {
                    url = Reflects.getResource(source, name + ".xml");
                }
            } else if (!Strings.endWithIgnoreCase(name, "[.]properties")) {
                url = Reflects.getResource(source, name + ".properties");
            }
        }
        return url;
    }

    public static Properties getProperties(File file) {
        return Helpers.load(new Properties(), file);
    }

    public static Properties getProperties(String name) {
        return Helpers.load(Helpers.getProperties(false, name), true, name);
    }

    public static Properties getProperties(Object source, String name) {
        return Helpers.load(Helpers.getProperties(false, source, name), true, source, name);
    }

    public static Properties getProperties(boolean isXML, String name) {
        return Helpers.getProperties(isXML, Helpers.getPropertiesURL(isXML, name));
    }

    public static Properties getProperties(boolean isXML, Object source, String name) {
        return Helpers.getProperties(isXML, Helpers.getPropertiesURL(isXML, source, name));
    }

    public static Properties getProperties(boolean isXML, URL url) {
        return Helpers.load(new Properties(), isXML, url);
    }

    public static Properties load(Properties props, File file) {
        URL url = Helpers.getURL(file);
        return Helpers.load(Helpers.load(props, false, url), true, url);
    }

    public static Properties load(Properties props, String name) {
        return Helpers.load(Helpers.load(props, false, name), true, name);
    }

    public static Properties load(Properties props, Object source, String name) {
        return Helpers.load(Helpers.load(props, false, source, name), true, source, name);
    }

    public static Properties load(Properties props, boolean isXML, String name) {
        return Helpers.load(props, isXML, Helpers.getPropertiesURL(isXML, name));
    }

    public static Properties load(Properties props, boolean isXML, Object source, String name) {
        return Helpers.load(props, isXML, Helpers.getPropertiesURL(isXML, source, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties load(Properties props, boolean isXML, URL url) {
        if (url == null) {
            return props;
        }
        InputStream in = null;
        try {
            in = url.openStream();
            if (isXML) {
                props.loadFromXML(in);
            } else {
                props.load(in);
            }
        }
        catch (Exception e) {
            LOG.warn("(!) Failed to load properties [{}] {}- {}", new Object[]{url, isXML ? "from XML " : "", e.getMessage()});
        }
        finally {
            Files.close(in);
        }
        return props;
    }

    public static String getProperty(String key) {
        return Helpers.getProperty(key, "");
    }

    public static String getProperty(final String key, final String value) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, value);
            }
        });
    }

    public static String getProperty(Class<?> clazz, String id, Object ... args) {
        return Helpers.getProperty(clazz, null, id, args);
    }

    public static String getProperty(Class<?> clazz, String dialect, String id, Object ... args) {
        return Helpers.getProperty(null, clazz, dialect, id, args);
    }

    public static String getProperty(String suffix, Class<?> clazz, String dialect, String id, Object ... args) {
        String value;
        String name = clazz.getName().replaceAll("[.]", "/");
        String dialectName = Strings.join(true, ".", new Object[]{Strings.join(true, "$", new Object[]{name, dialect}), suffix});
        Properties properties = CACHE_PROPERTIES.get(dialectName);
        if (properties == null) {
            properties = Helpers.getProperties(clazz, Strings.join(true, ".", new Object[]{name, suffix}));
            if (Strings.isNotEmpty(dialect)) {
                properties = Helpers.load(properties, clazz, dialectName);
            }
            Asserts.throwState(properties != null, "Not found the [%s] file", dialectName);
            CACHE_PROPERTIES.put(dialectName, properties);
        }
        if (Strings.isNotEmpty(value = properties.getProperty(id))) {
            value = Strings.format(value, args);
        }
        return value;
    }

    public static int compare(Object other, Object another) {
        Order oo = Reflects.getAnnotation(other, Order.class);
        Order ao = Reflects.getAnnotation(another, Order.class);
        Integer oi = null;
        if (other instanceof Ordered) {
            oi = ((Ordered)other).order();
        } else if (oo != null) {
            oi = oo.value();
        }
        Integer ai = null;
        if (another instanceof Ordered) {
            ai = ((Ordered)another).order();
        } else if (ao != null) {
            ai = ao.value();
        }
        if (oi != null && ai != null) {
            return oi.compareTo(ai);
        }
        if (other instanceof String && another instanceof String) {
            return ((String)other).compareTo((String)another);
        }
        if (other != null && another != null) {
            return Integer.compare(other.hashCode(), another.hashCode());
        }
        if (other != null) {
            return 1;
        }
        if (another != null) {
            return -1;
        }
        return 0;
    }

    public static boolean hasAliasName(AnnotatedElement element) {
        return Strings.isNotEmpty(Helpers.getAliasName(element.getAnnotation(Alias.class))) || Strings.isNotEmpty(Helpers.getAliasName((Annotation)element.getAnnotation(Named.class)));
    }

    public static boolean hasAliasName(Annotation[] annos) {
        boolean result = false;
        if (annos != null) {
            for (Annotation anno : annos) {
                if (!Strings.isNotEmpty(Helpers.getAliasName(anno))) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static String getAliasName(Annotation[] annos) {
        String name = null;
        if (annos != null) {
            Annotation anno;
            Annotation[] annotationArray = annos;
            int n = annotationArray.length;
            for (int i = 0; i < n && !Strings.isNotEmpty(name = Helpers.getAliasName(anno = annotationArray[i])); ++i) {
            }
        }
        return name;
    }

    public static String getAliasName(Class<?> clazz) {
        return Helpers.getAliasName(clazz, null, null);
    }

    public static String getAliasName(Class<?> clazz, String mask) {
        return Helpers.getAliasName(clazz, mask, null);
    }

    public static String getAliasName(Class<?> clazz, String mask, String value) {
        return Helpers.getAliasName(clazz, mask, value, clazz.getSimpleName(), new Object[][]{Helpers.wraps("i_", 1)});
    }

    public static String getAliasName(Method method) {
        return Helpers.getAliasName(method, null, null);
    }

    public static String getAliasName(Method method, String mask) {
        return Helpers.getAliasName(method, mask, null);
    }

    public static String getAliasName(Method method, String mask, String value) {
        return Helpers.getAliasName(method, mask, value, method.getName(), Helpers.wraps("set_|get_", 3), Helpers.wraps("is_", 2));
    }

    private static String getAliasName(AnnotatedElement element, String mask, String value, String name, Object[] ... covers) {
        if (Helpers.hasAliasName(element)) {
            name = Strings.empty(Helpers.getAliasName(element.getAnnotation(Alias.class)), Helpers.getAliasName((Annotation)element.getAnnotation(Named.class)));
        } else if (Strings.isNotEmpty(value)) {
            name = value.trim();
        } else {
            for (Object[] cover : covers) {
                if (!Strings.startWithIgnoreCase(Strings.toColumnName(name), (String)cover[0])) continue;
                name = name.substring((Integer)cover[1]);
                break;
            }
            name = Strings.toLower(name);
        }
        return Strings.isEmpty(mask) ? name : Strings.replaceIgnoreCase(name, mask);
    }

    private static String getAliasName(Annotation anno) {
        String name = null;
        if (anno instanceof Alias) {
            name = ((Alias)anno).value();
        } else if (anno instanceof Named) {
            name = ((Named)anno).value();
        }
        return name;
    }

    public static boolean isEmpty(Map<?, ?> values) {
        return values != null && values.isEmpty();
    }

    public static boolean isEmpty(Collection<?> values) {
        return values != null && values.isEmpty();
    }

    public static boolean isMultiple(Object instance) {
        return instance != null && (instance instanceof Collection || instance.getClass().isArray());
    }

    public static <T> Map<String, List<T>> toUnmodifiable(Map<String, List<T>> values) {
        for (Map.Entry<String, List<T>> entry : values.entrySet()) {
            values.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        return Collections.unmodifiableMap(values);
    }

    public static Map<String, ? extends Object> toHierarchical(Map<String, ? extends Object> values) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, ? extends Object> entry : values.entrySet()) {
            HashMap<String, Object> container;
            String subKey;
            if (entry.getValue() == null) continue;
            String key = Strings.toHierarchy(entry.getKey());
            int index = key.indexOf(".");
            if (index == -1) {
                subKey = null;
            } else {
                subKey = key.substring(index + 1);
                key = key.substring(0, index);
            }
            Object value = result.get(key);
            if (value == null) {
                if (subKey == null) {
                    value = entry.getValue();
                    result.put(key, value instanceof Map && value.getClass() != HashMap.class ? new HashMap((Map)value) : value);
                    continue;
                }
                container = new HashMap<String, Object>();
                result.put(key, container);
            } else if (value instanceof Map) {
                container = (HashMap<String, Object>)value;
                if (subKey == null) {
                    value = entry.getValue();
                    if (value instanceof Map) {
                        Map pending = (Map)value;
                        for (Map.Entry unionEntry : pending.entrySet()) {
                            String unionKey = (String)unionEntry.getKey();
                            if (container.containsKey(unionKey)) continue;
                            container.put(unionKey, unionEntry.getValue());
                        }
                        continue;
                    }
                    return values;
                }
            } else {
                return values;
            }
            container.put(subKey, entry.getValue());
        }
        return result;
    }

    public static Map<String, Object> toFlat(Map<String, Object> values) {
        return null;
    }

    public static <K, T> boolean toAppend(Map<K, List<T>> values, K name, T value) {
        return Helpers.toAppend(values, name, value, true);
    }

    public static <K, T> boolean toAppend(Map<K, List<T>> values, K name, T value, boolean repeat) {
        return Helpers.toAppends(values, name, Arrays.asList(value), repeat) > 0;
    }

    public static <K, T> int toAppends(Map<K, List<T>> values, K name, Collection<T> value) {
        return Helpers.toAppends(values, name, value, true);
    }

    public static <K, T> int toAppends(Map<K, List<T>> values, K name, Collection<T> value, boolean repeat) {
        List<T> container = values.get(name);
        if (container == null) {
            container = new ArrayList<T>();
            values.put(name, container);
        }
        return repeat ? (container.addAll(value) ? value.size() : 0) : Helpers.add(container, value);
    }

    public static boolean contains(List<?> a, List<?> b) {
        boolean result = a.size() >= b.size();
        for (Object v : b) {
            if (a.contains(v)) continue;
            result = false;
            break;
        }
        return result;
    }

    public static <T> List<T> getSurplus(List<T> source, List<T> target) {
        ArrayList<T> result = new ArrayList<T>();
        for (T v : target) {
            if (source.contains(v)) continue;
            result.add(v);
        }
        return result;
    }

    public static <T> List<T> getMerge(List<T> source, List<T> target) {
        ArrayList container = new ArrayList();
        if (source != null && source.size() > 0) {
            Helpers.add(container, target);
        }
        if (target != null && target.size() > 0) {
            Helpers.add(container, target);
        }
        return container;
    }

    public static <T> int add(Collection<T> container, Enumeration<T> values) {
        return Helpers.add(container, Helpers.newList(values));
    }

    public static <T> int add(Collection<T> container, Iterator<T> values) {
        return Helpers.add(container, Helpers.newList(values));
    }

    public static <T> int add(Collection<T> container, T ... values) {
        return Helpers.add(container, values == null ? null : Arrays.asList(values));
    }

    public static <T> int add(Collection<T> container, Collection<T> values) {
        int amount = 0;
        if (values != null) {
            for (T value : values) {
                if (!Helpers.add(container, value)) continue;
                ++amount;
            }
        }
        return amount;
    }

    public static <T> boolean add(Collection<T> container, T value) {
        boolean result = value != null && !container.contains(value);
        if (result) {
            container.add(value);
        }
        return result;
    }

    public static <T> List<T> newList(Enumeration<T> values) {
        ArrayList<T> result = new ArrayList<T>();
        if (values != null) {
            while (values.hasMoreElements()) {
                result.add(values.nextElement());
            }
        }
        return result;
    }

    public static <T> List<T> newList(Iterator<T> values) {
        ArrayList<T> result = new ArrayList<T>();
        if (values != null) {
            while (values.hasNext()) {
                result.add(values.next());
            }
        }
        return result;
    }

    public static <K, V> Map<K, V> newMap(Map<K, V> source, K ... keys) {
        HashMap<K, V> target = new HashMap<K, V>();
        if (source != null) {
            if (keys != null && keys.length > 0) {
                for (K key : keys) {
                    if (key == null) continue;
                    target.put(key, source.get(key));
                }
            } else {
                target.putAll(source);
            }
        }
        return target;
    }

    public static Map<String, ? extends Object> getMap(Map<String, ? extends Object> params, String key) {
        Object value = params.get(key);
        if (value instanceof Map) {
            params = (Map<String, ? extends Object>)value;
        } else if (Strings.isNotEmpty(key)) {
            params = Helpers.toHierarchical(params);
            for (String name : Strings.toHierarchy(key).split("[./]")) {
                value = params.get(name);
                if (!(value instanceof Map)) {
                    params = null;
                    break;
                }
                params = Helpers.toHierarchical((Map)value);
            }
        }
        return params;
    }

    public static Object getInstance(Map<String, ? extends Object> params, String key) {
        int index = key.lastIndexOf(".");
        if (index > 0) {
            params = Helpers.getMap(params, key.substring(0, index));
            key = key.substring(index + 1);
        }
        return params.get(key);
    }

    public static Object toArray(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Collection) {
            Collection collection = (Collection)source;
            int size = collection.size();
            Class sourceClass = Object.class;
            if (size > 0) {
                for (Object value : (Collection)source) {
                    if (sourceClass.isInstance(value)) {
                        sourceClass = value.getClass();
                        continue;
                    }
                    if (value == null) continue;
                    sourceClass = Object.class;
                    break;
                }
            }
            return sourceClass == Object.class ? collection.toArray() : Helpers.toArray(sourceClass, source);
        }
        Class<?> sourceClass = source.getClass();
        if (sourceClass.isArray()) {
            return source;
        }
        Object result = Array.newInstance(sourceClass, 1);
        Array.set(result, 0, source);
        return result;
    }

    public static Object toArray(final Class<?> type, Object source) {
        if (source == null) {
            return null;
        }
        final ArrayList container = new ArrayList();
        Helpers.each(source, new Callable.Runnable(){

            @Override
            public void run(Object ... args) {
                if (type.isInstance(args[1])) {
                    container.add(args[1]);
                } else if (args[1] == null) {
                    if (type.isPrimitive()) {
                        args[1] = Converter.defaultValue(type);
                    }
                    container.add(args[1]);
                }
            }
        }, new Object[0]);
        int size = container.size();
        source = Array.newInstance(type, size);
        if (size > 0) {
            System.arraycopy(container.toArray(), 0, source, 0, size);
        }
        return source;
    }

    public static Object newArray(Object source) {
        return Helpers.newArray(source, -1);
    }

    public static Object newArray(Object source, int length) {
        Class sourceClass = source == null ? Object.class : source.getClass();
        if ((source = Helpers.toArray(source)) == null) {
            return length < 0 ? null : new Object[length];
        }
        if (sourceClass.isArray()) {
            int sourceLength = Array.getLength(source);
            if (length < 0) {
                length = sourceLength;
            } else if (length < sourceLength) {
                sourceLength = length;
            }
            Object target = Array.newInstance(sourceClass.getComponentType(), length);
            if (sourceLength > 0) {
                System.arraycopy(source, 0, target, 0, sourceLength);
            }
            source = target;
        }
        return source;
    }

    public static Object newArray(Object source, Object target) {
        Class<?> targetType;
        target = Helpers.newArray(target);
        if (source == null) {
            return target;
        }
        source = Helpers.newArray(source);
        if (target == null) {
            return source;
        }
        int sourceCount = Array.getLength(source);
        if (sourceCount == 0) {
            return target;
        }
        int targetCount = Array.getLength(target);
        if (targetCount == 0) {
            return source;
        }
        Class<?> sourceType = source.getClass().getComponentType();
        Class<Object> resultType = sourceType.isAssignableFrom(targetType = target.getClass().getComponentType()) ? sourceType : (targetType.isAssignableFrom(sourceType) ? targetType : Object.class);
        if (!sourceType.isArray() && !targetType.isArray()) {
            Object result = Array.newInstance(resultType, sourceCount + targetCount);
            for (Object[] current : new Object[][]{{sourceType, source, 0, sourceCount}, {targetType, target, sourceCount, targetCount}}) {
                if (resultType.isAssignableFrom((Class)current[0])) {
                    System.arraycopy(current[1], 0, result, (Integer)current[2], (Integer)current[3]);
                    continue;
                }
                for (int i = 0; i < (Integer)current[3]; ++i) {
                    Array.set(result, i + (Integer)current[2], Array.get(current[1], i));
                }
            }
            return result;
        }
        return Helpers.newArray(resultType, source, sourceCount, target, targetCount);
    }

    private static Object newArray(Class<?> resultType, Object source, int sourceCount, Object target, int targetCount) {
        int resultCount;
        int loopCount;
        Object overValue;
        if (sourceCount - targetCount >= 0) {
            overValue = source;
            loopCount = targetCount;
            resultCount = sourceCount;
        } else {
            overValue = target;
            loopCount = sourceCount;
            resultCount = targetCount;
        }
        Object result = Array.newInstance(resultType, resultCount);
        int amount = 0;
        do {
            Array.set(result, amount, Helpers.newArray(Array.get(source, amount), Array.get(target, amount)));
        } while (++amount < loopCount);
        while (amount < resultCount) {
            Array.set(result, amount, Array.get(overValue, amount));
            ++amount;
        }
        return result;
    }

    public static <T> T[] newArray(Class<T> resultType, Object[] source, int count) {
        Object[] result = (Object[])Array.newInstance(resultType, count);
        if ((count = Math.min(source.length, count)) > 0) {
            int amount = 0;
            do {
                Array.set(result, amount, Array.get(source, amount));
            } while (++amount < count);
        }
        return result;
    }

    public static Object[][] newGrid(boolean isColumn, Object ... values) {
        Object result;
        int i;
        int size = values.length;
        final ArrayList grid = new ArrayList();
        if (isColumn) {
            for (i = 0; i < size; ++i) {
                int j;
                final int colCount = i;
                result = Helpers.each(values[i], new Callable<Object>(){

                    @Override
                    public Object call(Object ... args) {
                        List<Object> row;
                        Integer rowIndex = (Integer)args[0];
                        int rowCount = grid.size();
                        if (rowIndex == rowCount) {
                            row = new ArrayList();
                            grid.add(row);
                            for (int i = 0; i < colCount; ++i) {
                                row.add(null);
                            }
                        } else {
                            row = (List)grid.get(rowIndex);
                        }
                        return row.add(args[1]);
                    }
                }, new Object[0]);
                int n = j = result instanceof Object[] ? ((Object[])result).length : 1;
                while (j < grid.size()) {
                    ((List)grid.get(j)).add(null);
                    ++j;
                }
            }
            size = grid.size();
        } else {
            int colCount = 0;
            for (int i2 = 0; i2 < size; ++i2) {
                int j;
                int count;
                final ArrayList<Object> row = new ArrayList<Object>();
                grid.add(row);
                result = Helpers.each(values[i2], new Callable<Object>(){

                    @Override
                    public Object call(Object ... args) {
                        return row.add(args[1]);
                    }
                }, new Object[0]);
                int n = count = result instanceof Object[] ? ((Object[])result).length : 1;
                if (count > colCount) {
                    for (j = 0; j < i2; ++j) {
                        for (int k = colCount; k < count; ++k) {
                            ((List)grid.get(j)).add(null);
                        }
                    }
                    colCount = count;
                    continue;
                }
                for (j = count; j < colCount; ++j) {
                    row.add(null);
                }
            }
        }
        result = new Object[size][];
        for (i = 0; i < size; ++i) {
            result[i] = ((List)grid.get(i)).toArray();
        }
        return result;
    }

    public static Object compact(Object value) {
        if (value != null) {
            value = Helpers.toArray(value);
            int size = Array.getLength(value);
            switch (size) {
                case 0: {
                    value = null;
                    break;
                }
                case 1: {
                    value = Array.get(value, 0);
                    if (!Helpers.isMultiple(value)) break;
                    value = Helpers.compact(value);
                    break;
                }
                default: {
                    ArrayList<Object> container = new ArrayList<Object>();
                    for (int i = 0; i < size; ++i) {
                        Object pending = Helpers.compact(Array.get(value, i));
                        if (pending == null) continue;
                        container.add(pending);
                    }
                    value = container.size() < 2 ? Helpers.compact(container) : Helpers.toArray(container);
                }
            }
        }
        return value;
    }

    public static Object wrap(Object ... args) {
        return args;
    }

    public static Object[] wraps(Object ... args) {
        return args;
    }

    @SafeVarargs
    public static <T> T[] group(T ... args) {
        return args;
    }

    public static <T> T[][] groups(T[] ... args) {
        return args;
    }

    public static void sleep(int s) {
        Helpers.sleep(TimeUnit.SECONDS.toMillis(s), 0);
    }

    public static void sleep(long ms) {
        Helpers.sleep(ms, 0);
    }

    public static void sleep(long ms, int ns) {
        if (ms > 0L || ns > 0) {
            try {
                Thread.sleep(ms, ns);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void readying(Callable<Boolean> readyable) {
        Helpers.readying(readyable, 200L);
    }

    public static void readying(Callable<Boolean> readyable, long ms) {
        while (!Helpers.toBoolean(readyable.call())) {
            Helpers.sleep(ms);
        }
    }

    public static InetAddress getAddress() {
        InetAddress address = null;
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                address = Helpers.getAddress(ifaces.nextElement(), address);
                if (address == null || !address.isSiteLocalAddress()) continue;
                return address;
            }
            if (address == null) {
                address = InetAddress.getLocalHost();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return address;
    }

    public static InetAddress getAddress(String host) {
        InetAddress address = null;
        try {
            address = Helpers.getAddress(NetworkInterface.getByInetAddress(InetAddress.getByName(host)), Helpers.getAddress());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return address;
    }

    private static InetAddress getAddress(NetworkInterface iface, InetAddress candidateAddress) {
        Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
        while (inetAddrs.hasMoreElements()) {
            InetAddress inetAddr = inetAddrs.nextElement();
            if (inetAddr.isLoopbackAddress()) continue;
            if (inetAddr.isSiteLocalAddress()) {
                return inetAddr;
            }
            if (candidateAddress != null) continue;
            candidateAddress = inetAddr;
        }
        return candidateAddress;
    }

    public static SocketAddress getAddress(int port) {
        return Helpers.getAddress(null, port);
    }

    public static SocketAddress getAddress(String host, int port) {
        InetAddress address = Helpers.getAddress(host);
        return address == null ? null : new InetSocketAddress(address, port);
    }

    public static boolean isCode(String value) {
        return Helpers.isCode(value, 64);
    }

    public static boolean isCode(String value, int limit) {
        if (limit <= 0) {
            limit = 64;
        }
        return Strings.isNotEmpty(value) && value.toUpperCase().matches(REGEX_CODE) && value.length() < limit;
    }

    public static <T> Object each(Object instance, Callable<T> callable, Object ... args) {
        return Helpers.each(false, instance, callable, args);
    }

    public static <T> Object each(boolean multipled, Object array, Callable<T> callable, Object ... args) {
        int size;
        boolean isMultiple = true;
        if (array instanceof Collection) {
            Collection collection = (Collection)array;
            size = collection.size();
            array = collection.toArray(new Object[size]);
        } else if (array != null && array.getClass().isArray()) {
            size = Array.getLength(array);
        } else {
            isMultiple = false;
            size = 1;
            array = new Object[]{array};
        }
        int[] status = new int[]{0};
        Object[] result = new Object[size];
        for (int i = 0; i < size; ++i) {
            result[i] = callable.call(i, Array.get(array, i), args, status);
            switch (status[0]) {
                default: 
            }
        }
        return isMultiple || multipled ? result : Helpers.getElement((Object)result, 0);
    }

    public static int getLength(Object array) {
        int size = array instanceof Collection ? ((Collection)array).size() : (array instanceof Map ? ((Map)array).size() : (array == null ? 0 : (array.getClass().isArray() ? Array.getLength(array) : 1)));
        return size;
    }

    public static int getIndex(Object array, Object instance) {
        int size = 0;
        if (array instanceof Collection) {
            Collection collection = (Collection)array;
            size = collection.size();
            array = collection.toArray(new Object[size]);
        } else if (array.getClass().isArray()) {
            size = Array.getLength(array);
        } else {
            size = 1;
            array = new Object[]{array};
        }
        for (int i = 0; i < size; ++i) {
            if (!instance.equals(Array.get(array, i))) continue;
            return i;
        }
        return -1;
    }

    public static <T> T getElement(Object array, final Class<T> rawClass) {
        final Object[] instance = new Object[1];
        Helpers.each(array, new Callable.Runnable(){

            @Override
            public void run(Object ... args) {
                int[] status = (int[])args[3];
                if (rawClass.isInstance(args[1])) {
                    instance[0] = args[1];
                    status[0] = 1;
                }
            }
        }, new Object[0]);
        return (T)instance[0];
    }

    public static Object getElement(Object array, int index) {
        int size = 0;
        if (array instanceof Collection) {
            Collection collection = (Collection)array;
            size = collection.size();
            array = collection.toArray(new Object[size]);
        } else if (array.getClass().isArray()) {
            size = Array.getLength(array);
        } else {
            size = 1;
            array = new Object[]{array};
        }
        return index < 0 || index >= size ? null : Array.get(array, index);
    }

    public static Object getValue(Map<String, ? extends Object> params, String key) {
        return Helpers.getValue(params, key, (String)null);
    }

    public static Object getValue(Map<String, ? extends Object> params, String key, String suffix) {
        suffix = Strings.empty(suffix);
        if ((key = Strings.empty(key)).length() > 0) {
            Object value;
            Map<String, ? extends Object> pending;
            String pendingKey = Strings.toHierarchy(key);
            int index = pendingKey.lastIndexOf(".");
            if (index > 0) {
                pending = Helpers.getMap(params, pendingKey.substring(0, index));
                pendingKey = pendingKey.substring(index + 1);
            } else {
                pending = Helpers.toHierarchical(params);
                pendingKey = key;
            }
            if (pending != null && (value = pending.get(pendingKey + suffix)) != null) {
                return value;
            }
        }
        return params.get(key + suffix);
    }

    public static Object getValue(Map<String, ? extends Object> params, String key, Class<?> rawClass) {
        if (Reflects.isGeneral(rawClass) || rawClass.isInterface()) {
            return Helpers.getValue(params, key);
        }
        params = Helpers.toHierarchical(params);
        key = Strings.empty(key);
        HashMap result = new HashMap();
        Map<String, List<BoundField>> fields = Reflects.getBoundFields(rawClass);
        for (Map.Entry<String, List<BoundField>> entry : fields.entrySet()) {
            BoundField field = entry.getValue().get(0);
            String name = entry.getKey();
            HashMap<String, Object> value = Helpers.getValue(params, key + "." + name);
            if (value == null && (!Strings.isNotEmpty(name = field.getAlias()) || (value = Helpers.getValue(params, key + "." + name)) == null)) continue;
            if (value instanceof Map) {
                HashMap<String, Object> pending = new HashMap<String, Object>((Map)value);
                value = pending;
                Object subValue = Helpers.getValue(pending, name, field.getToken().getRawClass());
                if (subValue != null) {
                    pending.put(name, subValue);
                }
            }
            result.put(name, value);
        }
        return result.size() > 0 ? result : null;
    }

    public static Object getValues(Map<String, ? extends Object> params, String key) {
        return Helpers.getValues(params, key, (String)null);
    }

    public static Object getValues(Map<String, ? extends Object> params, String key, String suffix) {
        Object value = Helpers.getValue(params, (key = Strings.empty(key)) + "[]", suffix);
        if (value == null) {
            Object pending;
            int amount = 0;
            ArrayList<Object> container = new ArrayList<Object>();
            while ((pending = Helpers.getValue(params, key + "[" + amount++ + "]", suffix)) != null) {
                container.add(pending);
            }
            if (container.size() > 0) {
                return Helpers.newArray(container.get(0).getClass(), container.toArray(), container.size());
            }
            value = Helpers.getValue(params, key, suffix);
        }
        return Helpers.newArray(value);
    }

    public static Object getValues(Map<String, Object> params, String key, Class<?> rawClass) {
        Object value = Helpers.getValue(params, (key = Strings.empty(key)) + "[]", rawClass);
        if (value == null) {
            Object pending;
            int amount = 0;
            ArrayList<Object> container = new ArrayList<Object>();
            while ((pending = Helpers.getValue(params, key + "[" + amount++ + "]", rawClass)) != null) {
                container.add(pending);
            }
            if (container.size() > 0) {
                return Helpers.newArray(container.get(0).getClass(), container.toArray(), container.size());
            }
            value = Helpers.getValue(params, key, rawClass);
        }
        return Helpers.newArray(value);
    }

    public static <T> T nvl(T value, T alternative) {
        return Helpers.nvl(value, value, alternative);
    }

    public static <T> T nvl(T value, T leftist, T rightist) {
        return (T)Helpers.resolve(value != null, leftist, rightist);
    }

    public static <T> T resolve(boolean resolved, T value) {
        return (T)Helpers.resolve(resolved, value, null);
    }

    public static Object resolve(boolean resolved, Object leftist, Object rightist) {
        return resolved ? leftist : rightist;
    }

    public static <T> T coalesce(T ... instances) {
        for (T instance : instances) {
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    public static <K, V> Map<K, V> trim(Map<K, V> values) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : values.entrySet()) {
            if (!Strings.isNotEmpty(entry.getValue())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static int toInt(String value, int beginIndex, int endIndex) {
        return Helpers.toInt(10, value, beginIndex, endIndex);
    }

    public static int toInt(int radix, String value, int beginIndex, int endIndex) {
        return Integer.parseInt(value.substring(beginIndex, endIndex), radix);
    }

    public static int hashCode(Object instance) {
        return instance == null ? 0 : instance.hashCode();
    }

    public static boolean equals(Object source, Object target) {
        return source == target || source != null && source.equals(target);
    }

    public static String getStackTrace(Throwable cause) {
        if (cause == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        cause.printStackTrace(new PrintWriter((Writer)writer, true));
        return writer.getBuffer().toString();
    }

    public static <K, V> List<Map.Entry<K, V>> sortByKey(Map<K, V> instances) {
        return Helpers.sortByKey(instances.entrySet());
    }

    public static <K, V> List<Map.Entry<K, V>> sortByKey(Set<Map.Entry<K, V>> instances) {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>();
        for (Map.Entry<K, V> entry : instances) {
            entries.add(entry);
        }
        Collections.sort(entries, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> other, Map.Entry<K, V> another) {
                return Helpers.compare(other.getKey(), another.getKey());
            }
        });
        return entries;
    }

    public static <K, V> List<Map.Entry<K, V>> sortByValue(Map<K, V> instances) {
        return Helpers.sortByValue(instances.entrySet());
    }

    public static <K, V> List<Map.Entry<K, V>> sortByValue(Set<Map.Entry<K, V>> instances) {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>();
        for (Map.Entry<K, V> entry : instances) {
            entries.add(entry);
        }
        Collections.sort(entries, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> other, Map.Entry<K, V> another) {
                return Helpers.compare(other.getValue(), another.getValue());
            }
        });
        return entries;
    }

    public static <T> List<T> sort(List<T> instances) {
        Collections.sort(instances, new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return Helpers.compare(a, b);
            }
        });
        return instances;
    }

    public static boolean isUrl(String url) {
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public static boolean isEmail(String email) {
        return Strings.isNotEmpty(email) && Pattern.matches("^(\\w+([-.][A-Za-z0-9]+)*){3,18}@\\w+([-.][A-Za-z0-9]+)*\\.\\w+([-.][A-Za-z0-9]+)*$", email);
    }

    public static String getRuntimeProcess() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }

    public static String getCPUID() {
        String result = "";
        String systemName = System.getProperty("os.name");
        if (Strings.containsIgnoreCase(systemName, "Windows")) {
            result = Helpers.run("wmic cpu get ProcessorId", 2);
        } else if (Strings.containsIgnoreCase(systemName, "Linux")) {
            result = Helpers.run("dmidecode | grep \"ID\"", "ID");
            if (Strings.isNotEmpty(result)) {
                result = result.substring(result.indexOf(":") + 1);
            }
        } else if (Strings.containsIgnoreCase(systemName, "Mac") && Strings.isNotEmpty(result = Helpers.run("system_profiler SPHardwareDataType", "Hardware UUID"))) {
            result = result.substring(result.indexOf(":") + 1);
        }
        return Strings.empty(result);
    }

    public static String getHDID() {
        String result = "";
        String systemName = System.getProperty("os.name");
        if (Strings.containsIgnoreCase(systemName, "Windows")) {
            result = Helpers.run("wmic path win32_physicalmedia get serialnumber", 2);
        } else if (Strings.containsIgnoreCase(systemName, "Linux")) {
            result = Helpers.run("dmidecode | grep \"Serial Number\"", "Serial Number");
            if (Strings.isNotEmpty(result) && !": Not Specified".equals(result)) {
                result = result.substring(result.indexOf(":") + 1);
            } else {
                result = Helpers.run("dmidecode | grep \"UUID\"", "UUID");
                if (Strings.isNotEmpty(result)) {
                    result = result.substring(result.indexOf(":") + 1);
                }
            }
        } else if (Strings.containsIgnoreCase(systemName, "Mac") && Strings.isNotEmpty(result = Helpers.run("system_profiler SPStorageDataType", "Volume UUID"))) {
            result = result.substring(result.indexOf(":") + 1);
        }
        return Strings.empty(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String run(String cmd, int line) {
        StringBuffer buffer;
        Scanner scanner;
        block8: {
            String string;
            block7: {
                scanner = null;
                buffer = new StringBuffer();
                try {
                    Process process = Runtime.getRuntime().exec(cmd);
                    process.getOutputStream().close();
                    scanner = new Scanner(process.getInputStream());
                    int amount = 0;
                    while (scanner.hasNextLine()) {
                        ++amount;
                        String pending = Strings.empty(scanner.nextLine());
                        if (line <= 0) {
                            buffer.append(pending).append("\r\n");
                            continue;
                        }
                        if (amount != line) continue;
                        string = pending;
                        break block7;
                    }
                    break block8;
                }
                catch (Exception exception) {
                    Files.close(scanner);
                    return buffer.toString();
                    catch (Throwable throwable) {
                        Files.close(scanner);
                        throw throwable;
                    }
                }
            }
            Files.close(scanner);
            return string;
        }
        Files.close(scanner);
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String run(String cmd, String regex) {
        Scanner scanner;
        block6: {
            String string;
            block5: {
                scanner = null;
                try {
                    Process process = Runtime.getRuntime().exec(cmd);
                    process.getOutputStream().close();
                    scanner = new Scanner(process.getInputStream());
                    while (scanner.hasNextLine()) {
                        String pending = Strings.empty(scanner.nextLine());
                        if (!Strings.isNotEmpty(pending) || !Strings.containsIgnoreCase(pending, regex)) continue;
                        string = pending;
                        break block5;
                    }
                    break block6;
                }
                catch (Exception exception) {
                    Files.close(scanner);
                    return null;
                }
                catch (Throwable throwable) {
                    Files.close(scanner);
                    throw throwable;
                }
            }
            Files.close(scanner);
            return string;
        }
        Files.close(scanner);
        return null;
    }

    static {
        UUID_LOCKED = new Object();
        uuidSearial = 0;
        CODES = CODE_RADIX.toCharArray();
        CODES_LIMITS = new int[][]{{0, 10}, {10, 26}, {36, 26}, {0, 16}, {0, 36}, {10, 52}, {0, 62}};
        MAX_RADIX = CODES.length;
        LOG = LoggerFactory.getLogger(Helpers.class);
        CACHE_PROPERTIES = new HashMap<String, Properties>();
        DIGIT_INDECES = new HashMap<Character, Integer>();
        for (int i = 0; i < MAX_RADIX; ++i) {
            DIGIT_INDECES.put(Character.valueOf(CODES[i]), i);
        }
        GSON_CONTEXT = new ThreadLocal();
        GSON = new GsonBuilder().addSerializationExclusionStrategy(new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes attrs) {
                Ignore ignore = (Ignore)attrs.getAnnotation(Ignore.class);
                Sensitive sensitive = (Sensitive)attrs.getAnnotation(Sensitive.class);
                Map context = (Map)GSON_CONTEXT.get();
                return attrs.hasModifier(208) || sensitive != null && Helpers.toBoolean(context.get("desensitization")) || ignore != null && (ignore.mode() == Ignore.Mode.EXCLUDE || !ignore.serialize());
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }
        }).registerTypeAdapter(Class.class, (Object)new ClassAdapter()).setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).setDateFormat(Dates.getPattern(1)).create();
    }

    private static class ClassAdapter
    implements JsonSerializer<Class<?>>,
    JsonDeserializer<Class<?>> {
        private ClassAdapter() {
        }

        public Class<?> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return json == null ? null : Reflects.getClass(json.getAsString());
        }

        public JsonElement serialize(Class<?> instance, Type type, JsonSerializationContext context) {
            return new JsonPrimitive(instance == null ? "" : instance.getName());
        }
    }
}

