/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util;

import java.io.Closeable;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.isger.util.Asserts;
import net.isger.util.Decoder;
import net.isger.util.Encoder;
import net.isger.util.Files;
import net.isger.util.Helpers;
import net.isger.util.Reflects;
import net.isger.util.Strings;
import net.isger.util.reflect.Converter;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class Https {
    private Https() {
    }

    public static SSLContext createContext() throws NoSuchAlgorithmException, KeyManagementException {
        return Https.createContext("SSLv3");
    }

    public static SSLContext createContext(String version) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext context = SSLContext.getInstance(version);
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        context.init(null, new TrustManager[]{trustManager}, null);
        return context;
    }

    public static HttpClientConnectionManager createManager() {
        try {
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(Https.createContext(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
            return new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        }
        catch (Exception e) {
            throw Asserts.state("Failure to create http/https client connection manager - {}", e.getMessage(), e.getCause());
        }
    }

    public static HttpClientBuilder createBuilder() {
        return HttpClients.custom().setConnectionManager(Https.createManager());
    }

    public static String post(String url) {
        return Https.post(url, null, null, null);
    }

    public static String post(String url, Object content) {
        return Https.post(url, Reflects.toMap(content));
    }

    public static String post(String url, Map<String, Object> content) {
        return Https.post(url, Https.format(content));
    }

    public static String post(String url, String content) {
        return Https.post(url, null, content, null);
    }

    public static String post(String url, Map<String, String> headers, String content, String token) {
        String result = null;
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        try {
            client = Https.createBuilder().build();
            HttpPost post = new HttpPost(url);
            post.setHeader("Content-type", "application/x-www-form-urlencoded");
            if (Strings.isNotEmpty(token)) {
                post.setHeader("Authorization", token);
            }
            post.setHeader("User-Agent", "Brick/1.0.0");
            if (headers != null) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    post.setHeader(header.getKey(), header.getValue());
                }
            }
            StringEntity requestEntity = new StringEntity(content);
            requestEntity.setContentType("application/json");
            post.setEntity((HttpEntity)requestEntity);
            response = client.execute((HttpUriRequest)post);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                result = EntityUtils.toString((HttpEntity)responseEntity);
            }
            EntityUtils.consume((HttpEntity)responseEntity);
        }
        catch (Exception e) {
            try {
                throw Asserts.state("Failure to request [%s] - %s", url, e.getMessage(), e.getCause());
            }
            catch (Throwable throwable) {
                Files.close(response);
                Files.close((Closeable)client);
                throw throwable;
            }
        }
        Files.close((Closeable)response);
        Files.close((Closeable)client);
        return result;
    }

    public static String put(String url) {
        return Https.put(url, null, null, null);
    }

    public static String put(String url, String content) {
        return Https.put(url, null, content, null);
    }

    public static String put(String url, Map<String, String> headers, String content, String token) {
        String result = null;
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        try {
            client = Https.createBuilder().build();
            HttpPut put = new HttpPut(url);
            put.setHeader("Content-type", "application/x-www-form-urlencoded");
            if (Strings.isNotEmpty(token)) {
                put.setHeader("Authorization", token);
            }
            put.setHeader("User-Agent", "Brick/1.0.0");
            if (headers != null) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    put.setHeader(header.getKey(), header.getValue());
                }
            }
            StringEntity requestEntity = new StringEntity(content);
            requestEntity.setContentType("application/json");
            put.setEntity((HttpEntity)requestEntity);
            response = client.execute((HttpUriRequest)put);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                result = EntityUtils.toString((HttpEntity)responseEntity);
            }
            EntityUtils.consume((HttpEntity)responseEntity);
        }
        catch (Exception e) {
            try {
                throw Asserts.state("Failure to request [%s] - %s", url, e.getMessage(), e.getCause());
            }
            catch (Throwable throwable) {
                Files.close(response);
                Files.close((Closeable)client);
                throw throwable;
            }
        }
        Files.close((Closeable)response);
        Files.close((Closeable)client);
        return result;
    }

    public static String get(String url) {
        return Https.get(url, null, null, null);
    }

    public static String get(String url, String content) {
        return Https.get(url, null, content, null);
    }

    public static String get(String url, Map<String, String> headers, String content, String token) {
        String result = null;
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        try {
            HttpEntity responseEntity;
            client = Https.createBuilder().build();
            HttpGet get = new HttpGet(url + "?" + content);
            get.setHeader("Content-type", "application/x-www-form-urlencoded");
            if (Strings.isNotEmpty(token)) {
                get.setHeader("Authorization", token);
            }
            get.setHeader("User-Agent", "Brick/1.0.0");
            if (headers != null) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    get.setHeader(header.getKey(), header.getValue());
                }
            }
            if ((responseEntity = (response = client.execute((HttpUriRequest)get)).getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)responseEntity, (String)"UTF-8");
            }
            EntityUtils.consume((HttpEntity)responseEntity);
        }
        catch (Exception e) {
            try {
                throw Asserts.state("Failure to request [%s] - %s", url, e.getMessage(), e.getCause());
            }
            catch (Throwable throwable) {
                Files.close(response);
                Files.close((Closeable)client);
                throw throwable;
            }
        }
        Files.close((Closeable)response);
        Files.close((Closeable)client);
        return result;
    }

    public static String format(Map<String, Object> parameters) {
        return Https.format(parameters, null);
    }

    public static String format(Map<String, Object> parameters, Encoder encoder) {
        if (encoder == null) {
            encoder = new Encoder(){

                @Override
                public byte[] encode(Object content) {
                    return Strings.empty(content == null ? null : Converter.convert(String.class, content)).getBytes();
                }
            };
        }
        StringBuffer buffer = new StringBuffer(512);
        for (Map.Entry<String, Object> entry : Helpers.sortByKey(parameters)) {
            String value;
            String key = Strings.empty(entry.getKey());
            if (Strings.isEmpty(key) || Strings.isEmpty(value = new String(encoder.encode(entry.getValue())))) continue;
            buffer.append(key).append("=").append(value).append("&");
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public static Map<String, Object> parse(String content) {
        return Https.parse(content, null);
    }

    public static Map<String, Object> parse(String content, Decoder decoder) {
        if (decoder == null) {
            decoder = new Decoder(){

                @Override
                public Object decode(InputStream is) {
                    return null;
                }

                @Override
                public Object decode(byte[] content) {
                    return new String(content);
                }
            };
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (String parameter : content.split("[&]")) {
            String[] entry = parameter.split("[=]", 2);
            parameters.put(entry[0], decoder.decode(entry[1].getBytes()));
        }
        return parameters;
    }
}

