/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import net.isger.util.Asserts;
import net.isger.util.Callable;
import net.isger.util.Extendable;
import net.isger.util.Helpers;
import net.isger.util.Strings;
import net.isger.util.anno.Ignore;
import net.isger.util.reflect.AssemblerAdapter;
import net.isger.util.reflect.BoundField;
import net.isger.util.reflect.BoundMethod;
import net.isger.util.reflect.ClassAssembler;
import net.isger.util.reflect.Constructor;
import net.isger.util.reflect.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reflects {
    public static final Object UNKNOWN = new Object();
    private static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    public static final String KEY_CLASS = "class";
    private static final Map<Class<?>, Class<?>> WRAP_TYPES = new HashMap();
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TYPES;
    private static final Logger LOG;
    private static final Map<Class<?>, Map<String, List<BoundField>>> FIELDS;
    private static final Map<Class<?>, Map<String, List<BoundMethod>>[]> METHODS;

    private Reflects() {
    }

    public static String getName(Type type) {
        return type instanceof Class ? ((Class)type).getName() : type.toString();
    }

    public static GenericArrayType newArrayType(Type componentType) {
        return new GenericArrayTypeImpl(componentType);
    }

    public static ParameterizedType newParamType(Type ownerType, Type rawType, Type ... arguments) {
        return new ParameterizedTypeImpl(ownerType, rawType, arguments);
    }

    public static WildcardType newUpperType(Type boundType) {
        return new WildcardTypeImpl(new Type[]{boundType}, EMPTY_TYPE_ARRAY);
    }

    public static WildcardType newLowerType(Type boundType) {
        return new WildcardTypeImpl(new Type[]{Object.class}, new Type[]{boundType});
    }

    public static <T> T getAnnotation(Object instance, Class<T> clazz) {
        Annotation[] annos;
        if (instance instanceof Class) {
            annos = ((Class)instance).getDeclaredAnnotations();
        } else if (instance instanceof Method) {
            annos = ((Method)instance).getDeclaredAnnotations();
        } else if (instance instanceof AnnotatedElement) {
            annos = ((AnnotatedElement)instance).getAnnotations();
        } else if (instance != null) {
            annos = instance.getClass().getDeclaredAnnotations();
        } else {
            return null;
        }
        for (Annotation anno : annos) {
            if (!clazz.isInstance(anno)) continue;
            return (T)anno;
        }
        return null;
    }

    public static Type toCanonicalize(Type type) {
        if (type instanceof Class) {
            Class pending = (Class)type;
            return pending.isArray() ? new GenericArrayTypeImpl(Reflects.toCanonicalize(pending.getComponentType())) : pending;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pending = (ParameterizedType)type;
            return new ParameterizedTypeImpl(pending.getOwnerType(), pending.getRawType(), pending.getActualTypeArguments());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType pending = (GenericArrayType)type;
            return new GenericArrayTypeImpl(pending.getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            WildcardType pending = (WildcardType)type;
            return new WildcardTypeImpl(pending.getUpperBounds(), pending.getLowerBounds());
        }
        return type;
    }

    public static Type getResolveType(Type contextType, Class<?> rawClass, Type resolveType) {
        Type original;
        while (resolveType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)resolveType;
            if ((resolveType = Reflects.getResolveType(contextType, rawClass, typeVariable)) != typeVariable) continue;
            return resolveType;
        }
        if (resolveType instanceof Class && ((Class)resolveType).isArray()) {
            Type newComponentType;
            original = (Class)resolveType;
            Class<?> componentType = ((Class)original).getComponentType();
            return componentType == (newComponentType = Reflects.getResolveType(contextType, rawClass, componentType)) ? original : Reflects.newArrayType(newComponentType);
        }
        if (resolveType instanceof GenericArrayType) {
            Type newComponentType;
            original = (GenericArrayType)resolveType;
            Type componentType = original.getGenericComponentType();
            return componentType == (newComponentType = Reflects.getResolveType(contextType, rawClass, componentType)) ? original : Reflects.newArrayType(newComponentType);
        }
        if (resolveType instanceof ParameterizedType) {
            original = (ParameterizedType)resolveType;
            Type ownerType = original.getOwnerType();
            Type newOwnerType = Reflects.getResolveType(contextType, rawClass, ownerType);
            boolean changed = newOwnerType != ownerType;
            Type[] args = original.getActualTypeArguments();
            int length = args.length;
            for (int t = 0; t < length; ++t) {
                Type resolvedTypeArgument = Reflects.getResolveType(contextType, rawClass, args[t]);
                if (resolvedTypeArgument == args[t]) continue;
                if (!changed) {
                    args = (Type[])args.clone();
                    changed = true;
                }
                args[t] = resolvedTypeArgument;
            }
            return changed ? Reflects.newParamType(newOwnerType, original.getRawType(), args) : original;
        }
        if (resolveType instanceof WildcardType) {
            Type upperBound;
            original = (WildcardType)resolveType;
            Type[] originalLowerBound = original.getLowerBounds();
            Type[] originalUpperBound = original.getUpperBounds();
            if (originalLowerBound.length == 1) {
                Type lowerBound = Reflects.getResolveType(contextType, rawClass, originalLowerBound[0]);
                if (lowerBound != originalLowerBound[0]) {
                    return Reflects.newLowerType(lowerBound);
                }
            } else if (originalUpperBound.length == 1 && (upperBound = Reflects.getResolveType(contextType, rawClass, originalUpperBound[0])) != originalUpperBound[0]) {
                return Reflects.newUpperType(upperBound);
            }
            return original;
        }
        return resolveType;
    }

    private static Type getResolveType(Type contextType, Class<?> rawClass, TypeVariable<?> resolveType) {
        Object declaring = resolveType.getGenericDeclaration();
        if (!(declaring instanceof Class)) {
            return resolveType;
        }
        if ((contextType = Reflects.getSuperType(contextType, rawClass, (Class)declaring)) instanceof ParameterizedType) {
            int index = Helpers.getIndex(declaring.getTypeParameters(), resolveType);
            Asserts.throwArgument(index != -1, "No such %s", resolveType);
            return ((ParameterizedType)contextType).getActualTypeArguments()[index];
        }
        return resolveType;
    }

    public static Type getSuperType(Type contextType, Class<?> rawClass, Class<?> resolveClass) {
        if (resolveClass == rawClass) {
            return contextType;
        }
        if (resolveClass.isInterface()) {
            Class<?>[] interfaces = rawClass.getInterfaces();
            int length = interfaces.length;
            for (int i = 0; i < length; ++i) {
                if (interfaces[i] == resolveClass) {
                    return rawClass.getGenericInterfaces()[i];
                }
                if (!resolveClass.isAssignableFrom(interfaces[i])) continue;
                return Reflects.getSuperType(rawClass.getGenericInterfaces()[i], interfaces[i], resolveClass);
            }
        }
        if (!rawClass.isInterface()) {
            while (rawClass != Object.class) {
                Class<?> rawSuper = rawClass.getSuperclass();
                if (rawSuper == resolveClass) {
                    return rawClass.getGenericSuperclass();
                }
                if (resolveClass.isAssignableFrom(rawSuper)) {
                    return Reflects.getSuperType(rawClass.getGenericSuperclass(), rawSuper, resolveClass);
                }
                rawClass = rawSuper;
            }
        }
        return resolveClass;
    }

    public static Type getComponentType(Type type) {
        return type instanceof GenericArrayType ? ((GenericArrayType)type).getGenericComponentType() : ((Class)type).getComponentType();
    }

    public static Type getActualType(Type type) {
        return type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : Reflects.getRawClass(type);
    }

    public static Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            Asserts.isInstance(Class.class, rawType);
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(Reflects.getRawClass(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return Reflects.getRawClass(((WildcardType)type).getUpperBounds()[0]);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw Asserts.argument("Expected a Class, ParameterizedType, or GenericArrayType, but [%s] is of class [%s]", type, className);
    }

    public static boolean isClass(String name) {
        return Reflects.getClass(name) != null;
    }

    public static boolean isAbstract(Class<?> rawClass) {
        return Modifier.isAbstract(rawClass.getModifiers());
    }

    public static boolean isAbstract(Method method) {
        return Modifier.isAbstract(method.getModifiers());
    }

    public static boolean isGeneral(Class<?> rawClass) {
        boolean general;
        boolean bl = general = Reflects.getPrimitiveClass(rawClass) != null || Object.class == rawClass;
        if (!general && rawClass != null) {
            general = CharSequence.class.isAssignableFrom(rawClass) || Date.class.isAssignableFrom(rawClass) || Map.class.isAssignableFrom(rawClass) || Collection.class.isAssignableFrom(rawClass) || rawClass.isArray();
        }
        return general;
    }

    public static Class<?> getClass(Object instance) {
        Class<?> raw = null;
        if (instance instanceof String) {
            raw = Reflects.getClass((String)instance);
        } else if (instance instanceof Class) {
            raw = (Class<?>)instance;
        } else if (instance != null) {
            raw = instance.getClass();
        }
        return raw;
    }

    public static Class<?> getClass(String name) {
        return Reflects.getClass(name, null);
    }

    public static Class<?> getClass(String name, ClassLoader loader) {
        if (loader == null) {
            loader = Reflects.getClassLoader();
        }
        Class<?> rawClass = null;
        try {
            String[] form = name.split("[ ]", 2);
            name = form.length > 1 ? form[1] : form[0];
            rawClass = loader != null ? loader.loadClass(name) : Class.forName(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rawClass;
    }

    public static Class<?> getWrapClass(Class<?> primitiveClass) {
        Class<?> wrap = WRAP_TYPES.get(primitiveClass);
        if (wrap == null) {
            wrap = primitiveClass;
        }
        return wrap;
    }

    public static Class<?> getPrimitiveClass(Class<?> wrapClass) {
        if (wrapClass.isPrimitive()) {
            return wrapClass;
        }
        return PRIMITIVE_TYPES.get(wrapClass);
    }

    public static Class<?>[] getInterfaces(Class<?> rawClass) {
        ArrayList interfaces = new ArrayList();
        Reflects.appendInterfaces(interfaces, rawClass);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    private static void appendInterfaces(List<Class<?>> container, Class<?> rawClass) {
        if (rawClass != null && !container.contains(rawClass)) {
            if (rawClass.isInterface()) {
                container.add(rawClass);
            }
            for (Class<?> interfaceClass : rawClass.getInterfaces()) {
                if (container.contains(interfaceClass)) continue;
                Reflects.appendInterfaces(container, interfaceClass);
            }
            Reflects.appendInterfaces(container, rawClass.getSuperclass());
        }
    }

    public static ClassLoader getClassLoader(Object source) {
        Class<?> clazz;
        if (source == null || (clazz = Reflects.getClass(source)) == null) {
            return Reflects.getClassLoader();
        }
        ClassLoader loader = clazz.getClassLoader();
        if (loader == null) {
            loader = Reflects.getClassLoader();
        }
        return loader;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                return classLoader;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        classLoader = Reflects.class.getClassLoader();
        if (classLoader == null) {
            try {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return classLoader;
    }

    public static InputStream getResourceAsStream(String name) {
        ClassLoader classLoader = Reflects.getClassLoader();
        InputStream stream = classLoader.getResourceAsStream(name);
        if (stream == null) {
            stream = Reflects.class.getClassLoader().getResourceAsStream(name);
        }
        return stream;
    }

    public static List<URL> getResources(String name) {
        return Reflects.getResources(null, name);
    }

    public static List<URL> getResources(Object source, String name) {
        ArrayList<URL> resources = new ArrayList<URL>();
        ClassLoader loader = Reflects.getClassLoader(source);
        try {
            Enumeration<URL> pending = loader.getResources(name);
            if (pending != null || loader != ClassLoader.getSystemClassLoader() && (pending = ClassLoader.getSystemClassLoader().getResources(name)) != null) {
                while (pending.hasMoreElements()) {
                    resources.add(pending.nextElement());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resources;
    }

    public static URL getResource(String name) {
        return Reflects.getResource(null, name);
    }

    public static URL getResource(Object source, String name) {
        URL resource;
        ClassLoader loader = Reflects.getClassLoader(source);
        try {
            resource = loader.getResource(name);
            if (resource == null && loader != ClassLoader.getSystemClassLoader()) {
                resource = ClassLoader.getSystemClassLoader().getResource(name);
            }
        }
        catch (Exception e) {
            resource = null;
        }
        return resource;
    }

    public static Map<String, List<BoundField>> getBoundFields(Class<?> rawClass) {
        Map<String, List<BoundField>> result = FIELDS.get(rawClass);
        if (result != null || rawClass.isInterface() || !Object.class.isAssignableFrom(rawClass)) {
            return result;
        }
        result = new LinkedHashMap<String, List<BoundField>>();
        for (Class<?> pending = rawClass; pending != null && pending != Object.class; pending = pending.getSuperclass()) {
            Ignore.Mode ignoreMode = Reflects.getIgnoreMode(pending);
            for (Field field : pending.getDeclaredFields()) {
                BoundField boundField = Reflects.createBoundField(field, ignoreMode);
                if (boundField == null) continue;
                Helpers.toAppend(result, boundField.getName(), boundField);
            }
        }
        result = Helpers.toUnmodifiable(result);
        FIELDS.put(rawClass, result);
        return result;
    }

    public static BoundField getBoundField(Class<?> rawClass, String fieldName) {
        Map<String, List<BoundField>> boundFields = Reflects.getBoundFields(rawClass);
        List<BoundField> bounds = boundFields.get(fieldName);
        if (bounds != null && bounds.size() > 0) {
            return bounds.get(0);
        }
        return null;
    }

    private static BoundField createBoundField(Field field, Ignore.Mode mode) {
        int mod = field.getModifiers();
        if (Modifier.isStatic(mod) || Modifier.isFinal(mod) || Modifier.isTransient(mod) || Modifier.isVolatile(mod)) {
            return null;
        }
        Ignore ignore = field.getAnnotation(Ignore.class);
        if (Ignore.Mode.EXCLUDE.equals((Object)Reflects.getIgnoreMode(ignore, mode))) {
            return null;
        }
        return new BoundField(field);
    }

    public static Map<String, List<BoundMethod>> getBoundMethods(Class<?> rawClass, boolean overall) {
        Map<String, List<BoundMethod>>[] result = METHODS.get(rawClass);
        if (result != null || !Object.class.isAssignableFrom(rawClass)) {
            return result[overall ? 1 : 0];
        }
        result = new Map[]{new LinkedHashMap(), new LinkedHashMap()};
        for (Class<?> type = rawClass; type != null && type != Object.class; type = type.getSuperclass()) {
            Ignore.Mode ignoreMode = Reflects.getIgnoreMode(type);
            for (Method method : type.getDeclaredMethods()) {
                String name;
                BoundMethod boundMethod = Reflects.createBoundMethod(method, ignoreMode);
                if (boundMethod == null || !Helpers.toAppend(result[0], name = method.getName(), boundMethod)) continue;
                Helpers.toAppend(result[1], name, boundMethod);
                name = boundMethod.getAliasName();
                if (Strings.isNotEmpty(name)) {
                    Helpers.toAppend(result[1], name, boundMethod);
                }
                Helpers.toAppend(result[1], boundMethod.getMethodDesc(), boundMethod);
            }
        }
        result = new Map[]{Helpers.toUnmodifiable(result[0]), Helpers.toUnmodifiable(result[1])};
        METHODS.put(rawClass, result);
        return result[overall ? 1 : 0];
    }

    public static BoundMethod getBoundMethod(Class<?> rawClass, String name, boolean overall) {
        List<BoundMethod> bounds = Reflects.getBoundMethods(rawClass, overall).get(name);
        return bounds == null || bounds.size() == 0 ? null : bounds.get(0);
    }

    public static <T extends Annotation> List<BoundMethod> getBoundMethods(Class<?> rawClass, Class<T> annoClass, boolean overall) {
        ArrayList<BoundMethod> result = new ArrayList<BoundMethod>();
        for (List<BoundMethod> bounds : Reflects.getBoundMethods(rawClass, overall).values()) {
            result.addAll(Reflects.getBoundMethods(bounds, annoClass));
        }
        return result;
    }

    private static <T extends Annotation> List<BoundMethod> getBoundMethods(List<BoundMethod> bounds, Class<T> annoClass) {
        ArrayList<BoundMethod> methods = new ArrayList<BoundMethod>();
        for (BoundMethod bound : bounds) {
            if (bound.getAnnotation(annoClass) == null) continue;
            methods.add(bound);
        }
        return methods;
    }

    public static <T extends Annotation> BoundMethod getBoundMethod(Class<?> rawClass, Class<T> annoClass, boolean overall) {
        List<BoundMethod> bounds;
        BoundMethod method = null;
        Iterator<List<BoundMethod>> iterator = Reflects.getBoundMethods(rawClass, overall).values().iterator();
        while (iterator.hasNext() && (method = Reflects.getBoundMethod(bounds = iterator.next(), annoClass)) == null) {
        }
        return method;
    }

    public static <T extends Annotation> BoundMethod getBoundMethod(Class<?> rawClass, String name, Class<T> annoClass, boolean overall) {
        List<BoundMethod> bounds = Reflects.getBoundMethods(rawClass, overall).get(name);
        if (bounds != null) {
            return Reflects.getBoundMethod(bounds, annoClass);
        }
        return null;
    }

    private static <T extends Annotation> BoundMethod getBoundMethod(List<BoundMethod> bounds, Class<T> anno) {
        for (BoundMethod bound : bounds) {
            if (bound.getAnnotation(anno) == null) continue;
            return bound;
        }
        return null;
    }

    private static BoundMethod createBoundMethod(Method method, Ignore.Mode mode) {
        int mod = method.getModifiers();
        if (Modifier.isStatic(mod)) {
            return null;
        }
        Ignore ignore = method.getAnnotation(Ignore.class);
        if (Ignore.Mode.EXCLUDE.equals((Object)Reflects.getIgnoreMode(ignore, mode))) {
            return null;
        }
        return new BoundMethod(method);
    }

    private static Ignore.Mode getIgnoreMode(Class<?> rawClass) {
        Ignore ignore = rawClass.getAnnotation(Ignore.class);
        Ignore.Mode mode = Reflects.getIgnoreMode(ignore, null);
        if (mode != null) {
            return mode;
        }
        String name = rawClass.getSimpleName();
        String path = rawClass.getName().replaceAll("[.]", "/");
        path = path.substring(0, path.length() - name.length());
        Properties props = new Properties();
        String p = "";
        if (path.length() > 0) {
            for (String n : path.split("[/]")) {
                p = p + n + "/";
                Helpers.load(props, false, p + ".ignoreMode");
            }
        }
        Helpers.load(props, false, p + name + ".ignoreMode");
        String modeName = props.getProperty("this");
        mode = "exclude".equals(modeName) ? Ignore.Mode.EXCLUDE : Ignore.Mode.INCLUDE;
        return mode;
    }

    private static Ignore.Mode getIgnoreMode(Ignore ignore, Ignore.Mode mode) {
        Ignore.Mode result = mode;
        if (ignore != null && (result = ignore.mode()) == null) {
            result = mode;
        }
        return result;
    }

    public static Object newInstance(Map<String, ? extends Object> params, String namespace) {
        return Reflects.newInstance(Helpers.getMap(params, namespace));
    }

    public static <T> T newInstance(Class<T> rawClass, Map<String, ? extends Object> params, String namespace) {
        return Reflects.newInstance(rawClass, params, namespace, null);
    }

    public static Object newInstance(String name) {
        return Reflects.newInstance(name, null);
    }

    public static Object newInstance(String name, ClassAssembler assembler) {
        return Reflects.newInstance(name, null, assembler);
    }

    public static Object newInstance(String name, Map<String, ? extends Object> params, ClassAssembler assembler) {
        return Reflects.newInstance(Asserts.isNotNull(Reflects.getClass(name), "Unable to instantiate class %s", name), params, assembler);
    }

    public static Object newInstance(Map<String, ? extends Object> params) {
        return Reflects.newInstance(params, (ClassAssembler)null);
    }

    public static Object newInstance(Map<String, ? extends Object> params, ClassAssembler assembler) {
        Object className = params.get(KEY_CLASS);
        if (Strings.isEmpty(className)) {
            return params;
        }
        params.remove(KEY_CLASS);
        Class<?> clazz = className instanceof Class ? (Class<?>)className : Reflects.getClass(className.toString());
        Asserts.isNotNull(clazz, "Cannot instantiation class %s", className);
        return Reflects.newInstance(clazz, params, assembler);
    }

    public static <T> T newInstance(Class<T> rawClass, Map<String, ? extends Object> params) {
        return Reflects.newInstance(rawClass, params, (ClassAssembler)null);
    }

    public static <T> T newInstance(Class<T> clazz, Map<String, ? extends Object> params, String namespace, ClassAssembler assembler) {
        return Reflects.newInstance(clazz, Helpers.getMap(params, namespace), assembler);
    }

    public static <T> T newInstance(Class<T> rawClass, Map<String, ? extends Object> params, ClassAssembler assembler) {
        T instance = Reflects.newInstance(rawClass, assembler);
        if (params != null && params.size() > 0) {
            Reflects.toInstance(instance, params, assembler);
        }
        return instance;
    }

    public static <T> T newInstance(Class<? extends T> rawClass) {
        return Reflects.newInstance(rawClass, (ClassAssembler)null);
    }

    public static <T> T newInstance(Class<? extends T> rawClass, ClassAssembler assembler) {
        Class<?> pending;
        if (assembler != null && (pending = assembler.assemble(rawClass)) != null) {
            rawClass = pending;
        }
        if (Reflects.isAbstract(rawClass)) {
            if (Collection.class.isAssignableFrom(rawClass)) {
                if (SortedSet.class.isAssignableFrom(rawClass)) {
                    return (T)new TreeSet();
                }
                if (Set.class.isAssignableFrom(rawClass)) {
                    return (T)new LinkedHashSet();
                }
                if (Queue.class.isAssignableFrom(rawClass)) {
                    return (T)new LinkedList();
                }
                return (T)new ArrayList();
            }
            if (Map.class.isAssignableFrom(rawClass)) {
                if (SortedMap.class.isAssignableFrom(rawClass)) {
                    return (T)new LinkedHashMap();
                }
                return (T)new HashMap();
            }
        }
        Asserts.isNotNull(rawClass, "Cannot instantiation class", new Object[0]);
        return Constructor.construct(rawClass, new Object[0]);
    }

    public static <T> T toInstance(T instance, Map<String, Object> params) {
        return Reflects.toInstance(instance, params, null);
    }

    public static <T> T toInstance(T instance, Map<String, ? extends Object> params, ClassAssembler assembler) {
        if (instance instanceof Map) {
            ((Map)instance).putAll(params);
            return instance;
        }
        final Map<String, ? extends Object> data = Helpers.toHierarchical(params);
        Map<String, List<BoundField>> fields = Reflects.getBoundFields(instance.getClass());
        assembler = assembler == null ? new AssemblerAdapter() : new AssemblerAdapter(assembler){

            @Override
            public Object assemble(BoundField field, Object instance, Object value, Object ... args) {
                return super.assemble(field, instance, value, (Object[])Helpers.newArray((Object)args, data));
            }
        };
        for (Map.Entry<String, List<BoundField>> entry : fields.entrySet()) {
            String key = entry.getKey();
            BoundField field = entry.getValue().get(0);
            if (field.isBatch()) {
                field.setValue(instance, Reflects.getValues(data, key, field.getAlias()), assembler);
                continue;
            }
            Object value = Reflects.getValue(data, key, field.getAlias());
            if (value != null) {
                field.setValue(instance, value, assembler);
                continue;
            }
            field.setValue(instance, UNKNOWN, assembler);
        }
        if (instance instanceof Extendable) {
            ((Extendable)instance).setExtends(params);
        }
        return instance;
    }

    private static Object getValues(Map<String, ? extends Object> params, String fieldName, String aliasName) {
        Object value = Helpers.getValues(params, fieldName);
        if (value == null && (value = Helpers.getValues(params, Strings.toFieldName(fieldName))) == null && (value = Helpers.getValues(params, Strings.toColumnName(fieldName))) == null) {
            value = Helpers.getValues(params, aliasName);
        }
        return value;
    }

    private static Object getValue(Map<String, ? extends Object> params, String fieldName, String aliasName) {
        Object value = Helpers.getValue(params, fieldName);
        if (value == null && (value = Helpers.getValue(params, Strings.toFieldName(fieldName))) == null && (value = Helpers.getValue(params, Strings.toColumnName(fieldName))) == null) {
            value = Helpers.getValue(params, aliasName);
        }
        return value;
    }

    public static void toField(Object instance, String name, Object value) {
        Class<?> rawClass = instance.getClass();
        BoundField field = Reflects.getBoundField(rawClass, name);
        if (field == null) {
            throw Asserts.state("Not found field in %s by %s", rawClass, name);
        }
        field.setValue(instance, value);
    }

    public static <T> T toBean(Class<T> clazz, Object[] grid) {
        Object[] values = grid[1] instanceof Object[][] ? ((Object[][])grid[1])[0] : (Object[])grid[1];
        return Reflects.toBean(clazz, (Object[])grid[0], values);
    }

    public static <T> T toBean(Class<T> clazz, Object[] columns, Object[] values) {
        return Reflects.toBean(clazz, columns, values, null);
    }

    public static <T> T toBean(Class<T> clazz, Object[] columns, Object[] values, ClassAssembler assembler) {
        return Reflects.newInstance(clazz, Reflects.toMap(columns, values), assembler);
    }

    public static Map<String, Object> toMap(Object bean) {
        return Reflects.toMap(bean, false, false, true, Object.class);
    }

    public static Map<String, Object> toMap(Object bean, boolean desensitization) {
        return Reflects.toMap(bean, desensitization, false, true, Object.class);
    }

    public static Map<String, Object> toMap(Object bean, boolean desensitization, boolean deep) {
        return Reflects.toMap(bean, desensitization, deep, true, Object.class);
    }

    public static <T> Map<String, T> toMap(Object bean, Class<T> clazz) {
        return Reflects.toMap(bean, false, false, true, clazz);
    }

    public static <T> Map<String, T> toMap(Object bean, boolean desensitization, Class<T> clazz) {
        return Reflects.toMap(bean, desensitization, false, true, clazz);
    }

    public static <T> Map<String, T> toMap(Object bean, boolean desensitization, boolean deep, boolean trim, Class<T> clazz) {
        HashMap<String, Map<String, T>> values;
        block20: {
            Map<String, Object> value;
            block19: {
                boolean translate = bean instanceof String;
                if (translate && Strings.isNotEmpty(value = Helpers.fromJson((String)bean, Map.class))) {
                    bean = value;
                }
                values = new HashMap<String, Map<String, T>>();
                if (!(bean instanceof Map)) break block19;
                for (Map.Entry entry : ((Map)bean).entrySet()) {
                    value = entry.getValue();
                    if (value == null) continue;
                    if (deep && clazz == Object.class) {
                        Map<String, T> pending = Reflects.toMap(value, desensitization, deep, trim, clazz);
                        Object translateValue = pending;
                        if (!pending.isEmpty() || value instanceof String && Strings.isNotEmpty(translateValue = Helpers.fromJson((String)((Object)value)))) {
                            value = translateValue;
                        }
                    } else if (String.class.isAssignableFrom(clazz)) {
                        value = value instanceof String ? (String)((Object)value) : Helpers.toJson(value, desensitization);
                    } else if (value instanceof String && !translate) {
                        value = Strings.empty(Helpers.fromJson((String)((Object)value)), (String)((Object)value));
                    } else if (clazz != Object.class) {
                        value = Converter.convert(clazz, value);
                    }
                    values.put(String.valueOf(entry.getKey()), value);
                }
                break block20;
            }
            if (bean == null || Reflects.isGeneral(bean.getClass())) break block20;
            Map<String, List<BoundField>> fields = Reflects.getBoundFields(bean.getClass());
            for (Map.Entry<String, List<BoundField>> entry : fields.entrySet()) {
                try {
                    value = entry.getValue().get(0).getValue(bean, desensitization);
                    if (deep && clazz == Object.class) {
                        Map<String, T> pending = Reflects.toMap(value, desensitization, deep, trim, clazz);
                        if (!pending.isEmpty()) {
                            value = pending;
                        }
                    } else if (String.class.isAssignableFrom(clazz) && value != null) {
                        value = Helpers.toJson(value, desensitization);
                    } else if (clazz != Object.class) {
                        value = Converter.convert(clazz, value);
                    }
                    values.put(entry.getKey(), value);
                }
                catch (Exception e) {
                    LOG.warn("Failure getting field [{}] value.", (Object)entry.getKey(), (Object)e);
                }
            }
        }
        return trim ? Helpers.trim(values) : values;
    }

    public static Map<String, Object> toMap(Object[] grid) {
        return Reflects.toMap(grid, false);
    }

    public static Map<String, Object> toMap(Object[] grid, boolean form) {
        if (form) {
            HashMap<String, Object> result = new HashMap<String, Object>(grid.length);
            for (Object item : grid) {
                result.put(String.valueOf(((Object[])item)[0]), ((Object[])item)[1]);
            }
            return result;
        }
        return Reflects.toMap((Object[])grid[0], grid[1] instanceof Object[][] ? ((Object[][])grid[1])[0] : (Object[])grid[1]);
    }

    public static Map<String, Object> toMap(Object[] columns, Object[] values) {
        int size = Math.min(columns.length, values.length);
        HashMap<String, Object> result = new HashMap<String, Object>(size);
        for (int i = 0; i < size; ++i) {
            result.put(String.valueOf(columns[i]), values[i]);
        }
        return result;
    }

    public static <T> List<T> toList(Class<T> clazz, Object[] grid) {
        return Reflects.toList(clazz, grid, null);
    }

    public static <T> List<T> toList(Class<T> clazz, Object[] grid, ClassAssembler assembler) {
        ArrayList<T> result = new ArrayList<T>();
        Object[] columns = (Object[])grid[0];
        Object gridValue = grid[1];
        if (gridValue instanceof Object[][]) {
            for (Object[] values : (Object[][])gridValue) {
                result.add(Reflects.toBean(clazz, columns, values, assembler));
            }
        } else if (gridValue instanceof Object[]) {
            result.add(Reflects.toBean(clazz, columns, (Object[])gridValue, assembler));
        }
        return result;
    }

    public static <T> List<T> toList(Class<T> clazz, List<Map<String, Object>> values) {
        return Reflects.toList(clazz, values, new Callable<T>(){

            @Override
            public T call(Object ... args) {
                return args[1];
            }
        });
    }

    public static <T> List<T> toList(Class<T> clazz, List<Map<String, Object>> values, Callable<T> interceptor) {
        int size = values == null ? 0 : values.size();
        ArrayList<T> result = new ArrayList<T>(size);
        if (size > 0) {
            int step = 0;
            for (Map<String, Object> value : values) {
                T instance;
                if ((instance = interceptor.call(step++, Reflects.newInstance(clazz, value), result)) == null) continue;
                result.add(instance);
            }
        }
        return result;
    }

    public static List<Map<String, Object>> toList(Object[] grid) {
        return Reflects.toList((Object[])grid[0], (Object[][])grid[1]);
    }

    public static List<Map<String, Object>> toList(Object[] columns, Object[][] values) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(values.length);
        for (Object[] value : values) {
            result.add(Reflects.toMap(columns, value));
        }
        return result;
    }

    public static boolean equals(Type source, Type target) {
        if (source == target) {
            return true;
        }
        if (source instanceof Class) {
            return source.equals(target);
        }
        if (source instanceof ParameterizedType) {
            if (!(target instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType pa = (ParameterizedType)source;
            ParameterizedType pb = (ParameterizedType)target;
            return Helpers.equals(pa.getOwnerType(), pb.getOwnerType()) && pa.getRawType().equals(pb.getRawType()) && Arrays.equals(pa.getActualTypeArguments(), pb.getActualTypeArguments());
        }
        if (source instanceof GenericArrayType) {
            if (!(target instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType ga = (GenericArrayType)source;
            GenericArrayType gb = (GenericArrayType)target;
            return Reflects.equals(ga.getGenericComponentType(), gb.getGenericComponentType());
        }
        if (source instanceof WildcardType) {
            if (!(target instanceof WildcardType)) {
                return false;
            }
            WildcardType wa = (WildcardType)source;
            WildcardType wb = (WildcardType)target;
            return Arrays.equals(wa.getUpperBounds(), wb.getUpperBounds()) && Arrays.equals(wa.getLowerBounds(), wb.getLowerBounds());
        }
        if (source instanceof TypeVariable) {
            if (!(target instanceof TypeVariable)) {
                return false;
            }
            TypeVariable va = (TypeVariable)source;
            TypeVariable vb = (TypeVariable)target;
            return va.getGenericDeclaration() == vb.getGenericDeclaration() && va.getName().equals(vb.getName());
        }
        return false;
    }

    static {
        WRAP_TYPES.put(Void.TYPE, Void.class);
        WRAP_TYPES.put(Boolean.TYPE, Boolean.class);
        WRAP_TYPES.put(Byte.TYPE, Byte.class);
        WRAP_TYPES.put(Character.TYPE, Character.class);
        WRAP_TYPES.put(Short.TYPE, Short.class);
        WRAP_TYPES.put(Integer.TYPE, Integer.class);
        WRAP_TYPES.put(Long.TYPE, Long.class);
        WRAP_TYPES.put(Float.TYPE, Float.class);
        WRAP_TYPES.put(Double.TYPE, Double.class);
        PRIMITIVE_TYPES = new HashMap();
        PRIMITIVE_TYPES.put(Void.class, Void.TYPE);
        PRIMITIVE_TYPES.put(Boolean.class, Boolean.TYPE);
        PRIMITIVE_TYPES.put(Byte.class, Byte.TYPE);
        PRIMITIVE_TYPES.put(Character.class, Character.TYPE);
        PRIMITIVE_TYPES.put(Short.class, Short.TYPE);
        PRIMITIVE_TYPES.put(Integer.class, Integer.TYPE);
        PRIMITIVE_TYPES.put(Long.class, Long.TYPE);
        PRIMITIVE_TYPES.put(Float.class, Float.TYPE);
        PRIMITIVE_TYPES.put(Double.class, Double.TYPE);
        LOG = LoggerFactory.getLogger(Reflects.class);
        FIELDS = new ConcurrentHashMap();
        METHODS = new ConcurrentHashMap();
    }

    private static final class WildcardTypeImpl
    implements WildcardType,
    Serializable {
        private static final long serialVersionUID = 8303914422137884485L;
        private final Type upperBound;
        private final Type lowerBound;

        public WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
            Asserts.throwArgument(lowerBounds.length <= 1);
            Asserts.throwArgument(upperBounds.length == 1);
            if (lowerBounds.length == 1) {
                Asserts.isNotNull(lowerBounds[0]);
                Asserts.isNotPrimitive(lowerBounds[0]);
                Asserts.throwArgument(upperBounds[0] == Object.class);
                this.lowerBound = Reflects.toCanonicalize(lowerBounds[0]);
                this.upperBound = Object.class;
            } else {
                Asserts.isNotNull(upperBounds[0]);
                Asserts.isNotPrimitive(upperBounds[0]);
                this.lowerBound = null;
                this.upperBound = Reflects.toCanonicalize(upperBounds[0]);
            }
        }

        @Override
        public Type[] getUpperBounds() {
            return new Type[]{this.upperBound};
        }

        @Override
        public Type[] getLowerBounds() {
            Type[] typeArray;
            if (this.lowerBound != null) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = this.lowerBound;
            } else {
                typeArray = EMPTY_TYPE_ARRAY;
            }
            return typeArray;
        }

        public boolean equals(Object other) {
            return other instanceof WildcardType && Reflects.equals(this, (WildcardType)other);
        }

        public int hashCode() {
            return (this.lowerBound != null ? 31 + this.lowerBound.hashCode() : 1) ^ 31 + this.upperBound.hashCode();
        }

        public String toString() {
            if (this.lowerBound != null) {
                return "? super " + Reflects.getName(this.lowerBound);
            }
            if (this.upperBound == Object.class) {
                return "?";
            }
            return "? extends " + Reflects.getName(this.upperBound);
        }
    }

    private static final class GenericArrayTypeImpl
    implements GenericArrayType,
    Serializable {
        private static final long serialVersionUID = -1183771465139410856L;
        private final Type componentType;

        public GenericArrayTypeImpl(Type componentType) {
            this.componentType = Reflects.toCanonicalize(componentType);
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public boolean equals(Object o) {
            return o instanceof GenericArrayType && Reflects.equals(this, (GenericArrayType)o);
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }

        public String toString() {
            return Reflects.getName(this.componentType) + "[]";
        }
    }

    private static final class ParameterizedTypeImpl
    implements ParameterizedType,
    Serializable {
        private static final long serialVersionUID = 5081438518083630676L;
        private final Type ownerType;
        private final Type rawType;
        private final Type[] typeArguments;

        public ParameterizedTypeImpl(Type ownerType, Type rawType, Type ... typeArguments) {
            if (rawType instanceof Class) {
                Class rawClass = (Class)rawType;
                Asserts.throwArgument(ownerType != null || rawClass.getEnclosingClass() == null);
                Asserts.throwArgument(ownerType == null || rawClass.getEnclosingClass() != null);
            }
            this.ownerType = ownerType == null ? null : Reflects.toCanonicalize(ownerType);
            this.rawType = Reflects.toCanonicalize(rawType);
            this.typeArguments = (Type[])typeArguments.clone();
            for (int i = 0; i < this.typeArguments.length; ++i) {
                Asserts.isNotNull(this.typeArguments[i]);
                Asserts.isNotPrimitive(this.typeArguments[i]);
                this.typeArguments[i] = Reflects.toCanonicalize(this.typeArguments[i]);
            }
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        public boolean equals(Object other) {
            return other instanceof ParameterizedType && Reflects.equals(this, (ParameterizedType)other);
        }

        public int hashCode() {
            return Arrays.hashCode(this.typeArguments) ^ this.rawType.hashCode() ^ Helpers.hashCode(this.ownerType);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(30 * (this.typeArguments.length + 1));
            stringBuilder.append(Reflects.getName(this.rawType));
            if (this.typeArguments.length == 0) {
                return stringBuilder.toString();
            }
            stringBuilder.append("<").append(Reflects.getName(this.typeArguments[0]));
            for (int i = 1; i < this.typeArguments.length; ++i) {
                stringBuilder.append(", ").append(Reflects.getName(this.typeArguments[i]));
            }
            return stringBuilder.append(">").toString();
        }
    }
}

