/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.isger.util.Helpers;
import net.isger.util.Reflects;
import net.isger.util.hitch.Director;
import net.isger.util.scan.FileScan;
import net.isger.util.scan.JarScan;
import net.isger.util.scan.Scan;
import net.isger.util.scan.ScanFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scans {
    private static final String KEY_SCANS = "brick.util.scans";
    private static final String SCAN_PATH = "net/isger/util/scan";
    private static final Logger LOG = LoggerFactory.getLogger(Scans.class);
    private static final Scans SCANNER = new Scans();
    private Map<String, Scan> scans = new Hashtable<String, Scan>();

    private Scans() {
    }

    public static void addScan(Scan scan) {
        String name = scan.getClass().getName();
        if (LOG.isDebugEnabled()) {
            LOG.info("Achieve scan [{}]", (Object)name);
        }
        if ((scan = Scans.SCANNER.scans.put(name, scan)) != null && LOG.isDebugEnabled()) {
            LOG.warn("(!) Discard scan [{}]", (Object)scan);
        }
    }

    public static List<String> scan(String name, ScanFilter filter) {
        ArrayList<String> result = new ArrayList<String>();
        for (URL url : Reflects.getResources(SCANNER, name)) {
            Helpers.add(result, Scans.scan(url, filter));
        }
        return result;
    }

    private static List<String> scan(URL url, ScanFilter filter) {
        ArrayList<String> result = new ArrayList<String>();
        for (Scan scan : Scans.SCANNER.scans.values()) {
            Helpers.add(result, scan.scan(url, filter));
        }
        return result;
    }

    static {
        Scans.addScan(new FileScan());
        Scans.addScan(new JarScan());
        new Director(){

            @Override
            protected String directPath() {
                return this.directPath(Scans.KEY_SCANS, Scans.SCAN_PATH);
            }
        }.direct(SCANNER);
    }
}

