/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import net.isger.util.Callable;
import net.isger.util.Dates;
import net.isger.util.Files;
import net.isger.util.Reflects;
import net.isger.util.Strings;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v1CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v1CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class Securities {
    private Securities() {
    }

    public static KeyStore createSuite(String type, String root, String intermediate, String entity, char[] password, String algorithm, String issuer, long period) throws Exception {
        KeyStore store = KeyStore.getInstance(type);
        store.load(null, null);
        KeyPair rkp = Securities.createKeyPair(algorithm);
        X500PrivateCredential rootCredential = Securities.createCredential(root, rkp.getPrivate(), Securities.createRoot("CN=" + root + "," + issuer, period, 1L, rkp));
        KeyPair ikp = Securities.createKeyPair(algorithm);
        X500PrivateCredential interCredential = Securities.createCredential(intermediate, ikp.getPrivate(), Securities.createIntermediate("CN=" + intermediate + "," + issuer, period, 1L, ikp.getPublic(), rootCredential.getPrivateKey(), rootCredential.getCertificate()));
        KeyPair ekp = Securities.createKeyPair(algorithm);
        X500PrivateCredential entityCredential = Securities.createCredential(entity, ekp.getPrivate(), Securities.createEntity("CN=" + entity + "," + issuer, period, 1L, ekp.getPublic(), interCredential.getPrivateKey(), interCredential.getCertificate(), new Extension[0]));
        store.setCertificateEntry(rootCredential.getAlias(), rootCredential.getCertificate());
        store.setKeyEntry(entityCredential.getAlias(), entityCredential.getPrivateKey(), password, new Certificate[]{entityCredential.getCertificate(), interCredential.getCertificate(), rootCredential.getCertificate()});
        return store;
    }

    public static KeyStore createKeyStore(String name, String password, String issuer, long period) throws Exception {
        return Securities.createKeyStore(name, password, issuer, period, Securities.createKeyPair());
    }

    public static KeyStore createKeyStore(String algorithm, String name, String password, String issuer, long period) throws Exception {
        return Securities.createKeyStore(algorithm, name, password, issuer, period, Securities.createKeyPair());
    }

    public static KeyStore createKeyStore(String name, String password, String issuer, long period, KeyPair keyPair) throws Exception {
        return Securities.createKeyStore(name, password, keyPair.getPrivate(), Securities.createRoot(issuer, period, 1L, keyPair));
    }

    public static KeyStore createKeyStore(String algorithm, String name, String password, String issuer, long period, KeyPair keyPair) throws Exception {
        return Securities.createKeyStore(algorithm, name, password, keyPair.getPrivate(), Securities.createRoot(issuer, period, 1L, keyPair));
    }

    public static KeyStore createKeyStore(String name, String password, Key key, Certificate ... certificates) throws Exception {
        return Securities.createKeyStore("PKCS12", name, password, key, certificates);
    }

    public static KeyStore createKeyStore(String algorithm, String name, String password, Key key, Certificate ... certificates) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(algorithm);
        keyStore.load(null, null);
        keyStore.setKeyEntry(name, key, Strings.isEmpty(password) ? null : password.toCharArray(), certificates);
        return keyStore;
    }

    public static KeyStore getKeyStore(String algorithm, String path, char[] password) throws Exception {
        return Securities.getKeyStore(algorithm, Reflects.getResourceAsStream(path), password);
    }

    public static KeyStore getKeyStore(String algorithm, byte[] data, char[] password) throws Exception {
        return Securities.getKeyStore(algorithm, new ByteArrayInputStream(data), password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyStore(String algorithm, InputStream stream, char[] password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(algorithm);
        try {
            keyStore.load(stream, password);
        }
        finally {
            Files.close(stream);
        }
        return keyStore;
    }

    public static X500PrivateCredential createCredential(String name, PrivateKey key, X509Certificate cert) {
        return new X500PrivateCredential(cert, key, name);
    }

    public static X509Certificate createRoot(String issuer, long period, long serial, KeyPair keyPair) throws Exception {
        Date notBefore = new Date();
        JcaX509v1CertificateBuilder builder = new JcaX509v1CertificateBuilder(new X500Name(issuer), BigInteger.valueOf(serial), notBefore, Dates.getDate(notBefore, period), new X500Name(issuer), keyPair.getPublic());
        return Securities.getCertificate(builder.build(Securities.createSigner(keyPair.getPrivate())));
    }

    public static Certificate createRoot(String issuer, long period, AsymmetricCipherKeyPair keyPair) throws Exception {
        Date notBefore = new Date();
        X509v1CertificateBuilder builder = new X509v1CertificateBuilder(new X500Name(issuer), BigInteger.valueOf(1L), notBefore, Dates.getDate(notBefore, period), new X500Name(issuer), SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)keyPair.getPublic()));
        return Securities.getCertificate(builder.build(Securities.createSigner(keyPair)).toASN1Structure().getEncoded());
    }

    public static X509Certificate createIntermediate(String subject, long period, long serial, PublicKey inKey, PrivateKey caKey, X509Certificate caCert) throws Exception {
        Date notBefore = new Date();
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(caCert.getSubjectX500Principal(), BigInteger.valueOf(serial), notBefore, Dates.getDate(notBefore, period), new X500Principal(subject), inKey);
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        builder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(caCert)).addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(inKey)).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(0)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(134));
        return Securities.getCertificate(builder.build(Securities.createSigner(caKey)));
    }

    public static X509Certificate createEntity(String subject, long period, long serail, PublicKey entityKey, PrivateKey caKey, X509Certificate caCert, Extension ... extensions) throws Exception {
        Date notBefore = new Date();
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(caCert.getSubjectX500Principal(), BigInteger.valueOf(serail), notBefore, Dates.getDate(notBefore, period), new X500Principal(subject), entityKey);
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        builder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(caCert)).addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(entityKey)).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(160));
        return Securities.getCertificate(builder.build(Securities.createSigner(caKey)));
    }

    public static X509Certificate getCertificate(X509CertificateHolder holder) throws Exception {
        return new JcaX509CertificateConverter().getCertificate(holder);
    }

    public static X509Certificate getCertificate(byte[] data) throws Exception {
        return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(data));
    }

    public static Certificate getCertificate(String path) throws Exception {
        InputStream is = Reflects.getResourceAsStream(path);
        try {
            X509Certificate x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(is);
            return x509Certificate;
        }
        finally {
            Files.close(is);
        }
    }

    public static PrivateKey getPrivateKey(KeyStore store, String name, String password) throws Exception {
        return (PrivateKey)store.getKey(name, Strings.isEmpty(password) ? null : password.toCharArray());
    }

    public static PublicKey getPublicKey(Certificate certificate) throws Exception {
        return certificate.getPublicKey();
    }

    public static PublicKey createPublicKey(String algorithm, KeySpec keySpec) throws Exception {
        return KeyFactory.getInstance(algorithm).generatePublic(keySpec);
    }

    public static PrivateKey createPrivateKey(String algorithm, KeySpec keySpec) throws Exception {
        return KeyFactory.getInstance(algorithm).generatePrivate(keySpec);
    }

    public static SecretKey createSecretKey() throws Exception {
        return KeyGenerator.getInstance("HmacMD5").generateKey();
    }

    public static SecretKey createSecretKey(String algorithm) throws Exception {
        return KeyGenerator.getInstance(algorithm).generateKey();
    }

    public static SecretKey createSecretKey(byte[] data) throws Exception {
        return Securities.createSecretKey("HmacMD5", data);
    }

    public static SecretKey createSecretKey(String algorithm, byte[] data) throws Exception {
        return new SecretKeySpec(data, algorithm);
    }

    public static KeyPair createKeyPair() throws Exception {
        return Securities.createKeyPair("RSA", 2048);
    }

    public static KeyPair createKeyPair(String algorithm) throws Exception {
        return Securities.createKeyPair(algorithm, 2048);
    }

    public static KeyPair createKeyPair(String algorithm, int keySize) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(algorithm);
        kpg.initialize(keySize, new SecureRandom());
        return kpg.generateKeyPair();
    }

    public static AsymmetricCipherKeyPair createACKeyPair() {
        RSAKeyPairGenerator kpg = new RSAKeyPairGenerator();
        RSAKeyGenerationParameters param = new RSAKeyGenerationParameters(BigInteger.valueOf(3L), new SecureRandom(), 2048, 24);
        kpg.init((KeyGenerationParameters)param);
        return kpg.generateKeyPair();
    }

    public static ContentSigner createSigner(AsymmetricCipherKeyPair keyPair) throws Exception {
        return Securities.createSigner("SHA1withRSA", keyPair);
    }

    public static ContentSigner createSigner(String algorithm, AsymmetricCipherKeyPair keyPair) throws Exception {
        AlgorithmIdentifier sigAlg = new DefaultDigestAlgorithmIdentifierFinder().find(algorithm);
        AlgorithmIdentifier digAlg = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlg);
        return new BcRSAContentSignerBuilder(sigAlg, digAlg).build(keyPair.getPrivate());
    }

    public static ContentSigner createSigner(PrivateKey key) throws Exception {
        return Securities.createSigner("SHA1withRSA", key);
    }

    public static ContentSigner createSigner(String algorithm, PrivateKey key) throws Exception {
        return new JcaContentSignerBuilder(algorithm).build(key);
    }

    public static byte[] toEncrypt(Certificate certificate, byte[] data) throws Exception {
        return Securities.toEncrypt(Securities.getPublicKey(certificate), data);
    }

    public static byte[] toDecrypt(Certificate certificate, byte[] data) throws Exception {
        return Securities.toDecrypt(Securities.getPublicKey(certificate), data);
    }

    public static byte[] toEncrypt(KeyStore keyStore, String name, byte[] data) throws Exception {
        return Securities.toEncrypt(Securities.getPrivateKey(keyStore, name, null), data);
    }

    public static byte[] toEncrypt(KeyStore keyStore, String name, String password, byte[] data) throws Exception {
        return Securities.toEncrypt(Securities.getPrivateKey(keyStore, name, password), data);
    }

    public static byte[] toDecrypt(KeyStore keyStore, String name, String password, byte[] data) throws Exception {
        return Securities.toDecrypt(Securities.getPrivateKey(keyStore, name, password), data);
    }

    public static byte[] toEncrypt(Key key, byte[] data) throws Exception {
        return Securities.toEncrypt(key, data, null);
    }

    public static byte[] toEncrypt(Key key, byte[] data, Callable<Void> initializer) throws Exception {
        return Securities.toCipher(1, key, data, initializer);
    }

    public static byte[] toDecrypt(Key key, byte[] data) throws Exception {
        return Securities.toDecrypt(key, data, null);
    }

    public static byte[] toDecrypt(Key key, byte[] data, Callable<Void> initializer) throws Exception {
        return Securities.toCipher(2, key, data, initializer);
    }

    public static byte[] toCipher(int mode, Key key, byte[] data) throws Exception {
        return Securities.toCipher(mode, key, data, null);
    }

    public static byte[] toCipher(int mode, Key key, byte[] data, Callable<Void> initializer) throws Exception {
        return Securities.toCipher(mode, key, key.getAlgorithm(), data, initializer);
    }

    public static byte[] toCipher(int mode, Key key, String transformation, byte[] data, Callable<Void> initializer) throws Exception {
        Cipher cipher = Cipher.getInstance(transformation);
        if (initializer == null) {
            cipher.init(mode, key);
        } else {
            initializer.call(cipher, mode, key);
        }
        return cipher.doFinal(data);
    }

    public static byte[] toMac(String algorithm, byte[] key, byte[] data) throws Exception {
        SecretKey secretKey = Securities.createSecretKey(algorithm, key);
        Mac mac = Mac.getInstance(secretKey.getAlgorithm());
        mac.init(secretKey);
        return mac.doFinal(data);
    }

    public static byte[] toMac(Key key, byte[] data) throws Exception {
        Mac mac = Mac.getInstance(key.getAlgorithm());
        mac.init(key);
        return mac.doFinal(data);
    }

    public static byte[] toDigest(String algorithm, byte[] data) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        digest.update(data);
        return digest.digest();
    }

    public static byte[] toSign(String algorithm, PrivateKey key, byte[] data) throws Exception {
        Signature signature = Signature.getInstance(algorithm);
        signature.initSign(key);
        signature.update(data);
        return signature.sign();
    }

    public static boolean toVerify(PublicKey key, byte[] data, byte[] sign) throws Exception {
        Signature signature = Signature.getInstance(key.getAlgorithm());
        signature.initVerify(key);
        signature.update(data);
        return signature.verify(sign);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

