/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.isger.util.Helpers;
import net.isger.util.Reflects;
import net.isger.util.Strings;
import net.isger.util.anno.Alias;
import net.isger.util.reflect.BoundField;
import net.isger.util.sql.SqlEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sqls {
    private static final Logger LOG = LoggerFactory.getLogger(Sqls.class);

    public static String toTableName(String tableName) {
        if (!Strings.startWithIgnoreCase(tableName = Strings.toColumnName(tableName), "t[_]")) {
            tableName = "t_" + tableName;
        }
        return tableName;
    }

    public static String getTableName(Class<?> clazz) {
        return Sqls.getTableName(clazz, null);
    }

    public static String getTableName(Class<?> clazz, String mask) {
        String tableName;
        Alias table = clazz.getAnnotation(Alias.class);
        if (table != null && Strings.isNotEmpty(tableName = table.value())) {
            return tableName;
        }
        tableName = clazz.getSimpleName();
        if (Strings.isNotEmpty(mask)) {
            tableName = Strings.replaceIgnoreCase(tableName, mask);
        }
        return Sqls.toTableName(Strings.toLower(tableName));
    }

    public static Object[] getGridData(ResultSet resultSet) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        String[] columns = null;
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int count = metaData.getColumnCount();
            columns = new String[count];
            int i = 0;
            while (i < count) {
                columns[i++] = Strings.toFieldName(Sqls.getColumnName(metaData, i));
            }
            Object[] info = null;
            while (resultSet.next()) {
                info = new Object[count];
                int i2 = 0;
                while (i2 < count) {
                    info[i2++] = resultSet.getObject(i2);
                }
                result.add(info);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        return new Object[]{columns, result.toArray((T[])new Object[result.size()][])};
    }

    public static Object[] getGridData(Object bean) {
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<Object> row = new ArrayList<Object>();
        for (List<BoundField> fields : Reflects.getBoundFields(bean.getClass()).values()) {
            BoundField field = fields.get(0);
            String column = Strings.empty(field.getAlias(), Strings.toColumnName(field.getName()));
            Object value = field.getValue(bean);
            if (value == null) continue;
            columns.add(column);
            row.add(value);
        }
        return new Object[]{columns.toArray(new String[columns.size()]), row.toArray()};
    }

    private static String getColumnName(ResultSetMetaData metaData, int index) throws SQLException {
        String name = metaData.getColumnLabel(index);
        if (Strings.isEmpty(name)) {
            name = metaData.getColumnName(index);
        }
        return name;
    }

    public static Object modify(SqlEntry entry, Connection conn) throws RuntimeException {
        Object result = null;
        for (SqlEntry e : entry) {
            Object[] values = e.getValues();
            if (values instanceof Object[][]) {
                result = Sqls.modify(e.getSql(), (Object[][])values, conn);
                continue;
            }
            result = Sqls.modify(e.getSql(), values, conn);
        }
        return result;
    }

    public static int[] modify(Class<?> clazz, String id, Object[][] values, Connection conn, Object ... args) {
        return Sqls.modify(clazz, null, id, values, conn, args);
    }

    public static int[] modify(Class<?> clazz, String dialectName, String id, Object[][] values, Connection conn, Object ... args) {
        return Sqls.modify(Sqls.getSQL(clazz, dialectName, id, args), values, conn);
    }

    public static int[] modify(String sql, Object[][] values, Connection conn) {
        PreparedStatement stat = Sqls.getStatement(sql, values, conn);
        try {
            int[] nArray = stat.executeBatch();
            return nArray;
        }
        catch (SQLException e) {
            throw new IllegalStateException(sql, e);
        }
        finally {
            Sqls.close(stat);
        }
    }

    public static int modify(Class<?> clazz, String id, Object[] values, Connection conn, Object ... args) {
        return Sqls.modify(Sqls.getSQL(clazz, id, args), values, conn);
    }

    public static int modify(String sql, Connection conn) {
        return Sqls.modify(sql, (Object[])null, conn);
    }

    public static int modify(String sql, Object[] values, Connection conn) {
        PreparedStatement stat = Sqls.getStatement(sql, values, conn);
        try {
            int n = stat.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new IllegalStateException(sql, e);
        }
        finally {
            Sqls.close(stat);
        }
    }

    public static Object[] query(SqlEntry entry, Connection conn) throws RuntimeException {
        List<SqlEntry> entries = entry.getEntries();
        int size = entries.size() - 1;
        for (int i = 0; i < size; ++i) {
            Sqls.modify(entries.get(i), conn);
        }
        SqlEntry lastEntry = entries.get(size);
        return Sqls.query(entry.getSql(lastEntry), entry.getValues(lastEntry), conn);
    }

    public static Object[] query(Class<?> clazz, String id, Object[] values, Connection conn, Object ... args) {
        return Sqls.query(clazz, null, id, values, conn, args);
    }

    public static Object[] query(Class<?> clazz, String dialectName, String id, Object[] values, Connection conn, Object ... args) {
        return Sqls.query(Sqls.getSQL(clazz, dialectName, id, args), values, conn);
    }

    public static Object[] query(String sql, Connection conn) {
        return Sqls.query(sql, null, conn);
    }

    public static Object[] query(String sql, Object[] values, Connection conn) {
        PreparedStatement stat = Sqls.getStatement(sql, values, conn);
        ResultSet resultSet = null;
        try {
            resultSet = stat.executeQuery();
            Object[] objectArray = Sqls.getGridData(resultSet);
            return objectArray;
        }
        catch (SQLException e) {
            throw new IllegalStateException(sql, e);
        }
        finally {
            Sqls.close(resultSet);
            Sqls.close(stat);
        }
    }

    private static PreparedStatement getStatement(String sql, Object[] values, Connection conn) {
        if (LOG.isDebugEnabled()) {
            LOG.info("Preparing statement: {}", (Object)sql);
        }
        try {
            return Sqls.prepare(conn.prepareStatement(sql), values);
        }
        catch (SQLException e) {
            throw new IllegalStateException(sql, e);
        }
    }

    private static PreparedStatement getStatement(String sql, Object[][] values, Connection conn) {
        if (LOG.isDebugEnabled()) {
            LOG.info("Preparing batch statement: {}", (Object)sql);
        }
        try {
            PreparedStatement stat = conn.prepareStatement(sql);
            if (values != null) {
                for (Object[] batch : values) {
                    Sqls.prepare(stat, batch).addBatch();
                }
            }
            return stat;
        }
        catch (SQLException e) {
            throw new IllegalStateException(sql, e);
        }
    }

    private static PreparedStatement prepare(PreparedStatement stat, Object[] values) throws SQLException {
        int size = values == null ? 0 : values.length;
        try {
            size = Math.min(size, stat.getParameterMetaData().getParameterCount());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (LOG.isDebugEnabled() && size > 0) {
            StringBuffer format = new StringBuffer(20 + 4 * size);
            format.append("Preparing parameter: [{}");
            for (int i = 1; i < size; ++i) {
                format.append(", {}");
            }
            format.append("]");
            LOG.info(format.toString(), values);
        }
        int amount = 0;
        while (amount < size) {
            Object value;
            if ((value = values[amount++]) instanceof Date) {
                stat.setObject(amount, new Timestamp(((Date)value).getTime()));
                continue;
            }
            if (value instanceof Number || value instanceof Boolean || value instanceof String || value == null) {
                stat.setObject(amount, value);
                continue;
            }
            stat.setObject(amount, Helpers.toJson(value));
        }
        return stat;
    }

    public static void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void close(Statement stat) {
        if (stat != null) {
            try {
                stat.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static String getSQL(Class<?> clazz, String id, Object ... args) {
        return Sqls.getSQL(clazz, null, id, args);
    }

    public static String getSQL(Class<?> clazz, String dialect, String id, Object ... args) {
        return Helpers.getProperty("sql", clazz, dialect, id, args);
    }
}

