/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.isger.util.Callable;
import net.isger.util.Helpers;

public class Strings {
    private static final String REGEX_HIERARCHY = "\\[(.*?)]";
    private static final Pattern PATTERN_HIERARCHY = Pattern.compile("\\[(.*?)]");

    private Strings() {
    }

    public static boolean isEmpty(Object value) {
        return value == null || value.toString().matches("^[\\s\u00a0]*$");
    }

    public static boolean isNotEmpty(Object value) {
        return value != null && !value.toString().matches("^[\\s\u00a0]*$");
    }

    public static String trim(Object value) {
        if (value instanceof String) {
            return ((String)value).replaceFirst("^[\\s\u00a0]+", "").replaceFirst("[\\s\u00a0]+$", "");
        }
        return Strings.empty(value);
    }

    public static String empty(Object value) {
        return Strings.empty(value, "");
    }

    public static String empty(Object value, String def) {
        return Strings.isEmpty(value) ? def : Strings.trim((Object)value.toString());
    }

    public static boolean matchsIgnoreCase(String value, String regex) {
        return Pattern.compile(regex, 2).matcher(value).matches();
    }

    public static boolean containsIgnoreCase(String value, String regex) {
        return Strings.matchsIgnoreCase(value, "^.*(" + regex + ").*$");
    }

    public static int count(String source, String target) {
        int count = 0;
        int index = 0;
        while ((index = source.indexOf(target, index)) != -1) {
            ++count;
            index += target.length();
        }
        return count;
    }

    public static boolean startWithIgnoreCase(String value, String regex) {
        return Strings.matchsIgnoreCase(value, "^(" + regex + ").*$");
    }

    public static boolean endWithIgnoreCase(String value, String regex) {
        return Strings.matchsIgnoreCase(value, "^.*(" + regex + ")$");
    }

    public static boolean equals(byte[] source, byte[] target) {
        return new String(source).equals(new String(target));
    }

    public static boolean equalsTolerant(String source, String target) {
        return Strings.isEmpty(source) || Strings.isEmpty(target) || source.equals(target);
    }

    public static boolean equalsIgnoreCase(String source, Object ... targets) {
        if (source != null && targets != null) {
            for (Object target : targets) {
                if (target == null || !source.equalsIgnoreCase(String.valueOf(target))) continue;
                return true;
            }
        }
        return false;
    }

    public static String replaceIgnoreCase(String value, String regex) {
        return Strings.replaceIgnoreCase(value, regex, "");
    }

    public static String replaceIgnoreCase(String value, String regex, String content) {
        Pattern pattern = Pattern.compile(regex, 2);
        return pattern.matcher(value).replaceAll(content);
    }

    public static String toCharset(byte[] data, String sourceCharset, String targetCharset) throws UnsupportedEncodingException {
        if (Strings.isEmpty(sourceCharset) || sourceCharset.equals(targetCharset)) {
            return new String(data, targetCharset);
        }
        return new String(Charset.forName(targetCharset).encode(Charset.forName(sourceCharset).decode(ByteBuffer.wrap(data))).array(), targetCharset);
    }

    public static String toUpper(String value) {
        int len = value.length();
        if (len > 0) {
            char[] cs = value.toCharArray();
            cs[0] = Character.toUpperCase(cs[0]);
            value = new String(cs);
        }
        return value;
    }

    public static String toLower(String value) {
        int len = value.length();
        if (len > 0) {
            char[] cs = value.toCharArray();
            cs[0] = Character.toLowerCase(cs[0]);
            value = new String(cs);
        }
        return value;
    }

    public static String toFieldName(Enum<?> item) {
        return item == null ? null : Strings.toFieldName(item.name());
    }

    public static String toFieldName(String columnName) {
        if (Strings.isEmpty(columnName)) {
            return null;
        }
        char[] chs = columnName.toLowerCase().toCharArray();
        StringBuffer fieldName = new StringBuffer(chs.length);
        boolean hasUpper = false;
        for (char ch : chs) {
            if (ch == '_') {
                hasUpper = true;
                continue;
            }
            if (hasUpper) {
                ch = Character.toUpperCase(ch);
                hasUpper = false;
            }
            fieldName.append(ch);
        }
        return fieldName.toString();
    }

    public static String toColumnName(String fieldName) {
        char[] chs = Strings.toLower(fieldName.replaceAll("[_]", "")).toCharArray();
        StringBuffer columnName = new StringBuffer(chs.length + 16);
        for (char ch : chs) {
            if (Character.isUpperCase(ch)) {
                columnName.append('_');
            }
            columnName.append(Character.toLowerCase(ch));
        }
        return columnName.toString();
    }

    public static String toHierarchy(String value) {
        Matcher matcher = PATTERN_HIERARCHY.matcher(value);
        StringBuffer buffer = new StringBuffer(value.length());
        int beginIndex = 0;
        int endIndex = 0;
        while (matcher.find()) {
            endIndex = matcher.start();
            if (beginIndex < endIndex) {
                buffer.append(Strings.empty(value.substring(beginIndex, matcher.start())));
                buffer.append(".");
            }
            buffer.append(matcher.group(1)).append(".");
            beginIndex = matcher.end();
        }
        if (beginIndex < value.length()) {
            buffer.append(value.substring(beginIndex));
        }
        return buffer.toString().replaceAll("[.]{2,}", ".").replaceAll("(^[.]+)|([.]+$)", "");
    }

    public static Object[] each(String value, String token, Callable<Object> callable) {
        return Strings.each(new StringTokenizer(value, token), callable);
    }

    public static Object[] each(StringTokenizer tokenizer, Callable<Object> callable) {
        ArrayList<Object> result = new ArrayList<Object>();
        while (tokenizer.hasMoreTokens()) {
            result.add(callable.call(tokenizer.nextToken()));
        }
        return result.toArray();
    }

    public static String format(String message, Object ... args) {
        try {
            return String.format(message, args);
        }
        catch (Exception e) {
            return message;
        }
    }

    public static String join(Collection<?> values) {
        return Strings.join(false, values);
    }

    public static String join(boolean isCompact, Collection<?> values) {
        return Strings.join(isCompact, null, values);
    }

    public static String join(boolean isCompact, String separator, Collection<?> values) {
        return Strings.join(isCompact, separator, null, values);
    }

    public static String join(boolean isCompact, String separator, String seal, Collection<?> values) {
        return Strings.join(isCompact, separator, seal, seal, values);
    }

    public static String join(boolean isCompact, String separator, String beginSeal, String endSeal, Collection<?> values) {
        return Strings.join(isCompact, separator, beginSeal, endSeal, values == null ? null : values.toArray());
    }

    public static String join(String ... values) {
        return Strings.join(false, (Object[])values);
    }

    public static String join(boolean isCompact, Object[] values) {
        return Strings.join(isCompact, values, 0);
    }

    public static String join(boolean isCompact, String separator, Object[] values) {
        return Strings.join(isCompact, separator, values, 0);
    }

    public static String join(boolean isCompact, String separator, String seal, Object[] values) {
        return Strings.join(isCompact, separator, seal, values, 0);
    }

    public static String join(boolean isCompact, String separator, String beginSeal, String endSeal, Object[] values) {
        return Strings.join(isCompact, separator, beginSeal, endSeal, values, 0, values.length);
    }

    public static String join(boolean isCompact, Object[] values, int beginIndex) {
        return Strings.join(isCompact, "", values, beginIndex);
    }

    public static String join(boolean isCompact, String separator, Object[] values, int beginIndex) {
        return Strings.join(isCompact, separator, "", values, beginIndex);
    }

    public static String join(boolean isCompact, String separator, String seal, Object[] values, int beginIndex) {
        return Strings.join(isCompact, separator, seal, seal, values, beginIndex, values == null ? -1 : values.length);
    }

    public static String join(boolean isCompact, String separator, String beginSeal, String endSeal, Object[] values, int beginIndex, int count) {
        separator = Helpers.coalesce(separator, "");
        beginSeal = Helpers.coalesce(beginSeal, "");
        endSeal = Helpers.coalesce(endSeal, "");
        if ((beginIndex = Math.max(beginIndex, 0)) < (count = Math.min(beginIndex + count, values == null ? -1 : values.length))) {
            StringBuffer buffer = new StringBuffer(count-- * 32);
            int amount = beginIndex - 1;
            while (++amount < count) {
                if (Strings.isEmpty(values[amount])) {
                    if (isCompact) continue;
                    buffer.append("null");
                } else {
                    buffer.append(beginSeal).append(values[amount]).append(endSeal);
                }
                buffer.append(separator);
            }
            if (values[amount] == null) {
                if (isCompact) {
                    if (buffer.length() > 0) {
                        buffer.setLength(buffer.length() - separator.length());
                    }
                } else {
                    buffer.append("null");
                }
            } else {
                buffer.append(beginSeal).append(values[amount]).append(endSeal);
            }
            return buffer.toString();
        }
        return null;
    }

    public static String chain(Map<?, ?> values) {
        return Strings.chain(values, false);
    }

    public static String chain(Map<?, ?> values, boolean sorted) {
        Set<Map.Entry<?, ?>> entries = sorted ? new TreeMap(values).entrySet() : values.entrySet();
        return Strings.join(true, "&", (Object[])Helpers.each(entries, new Callable<String>(){

            @Override
            public String call(Object ... args) {
                Map.Entry entry = (Map.Entry)args[1];
                return Strings.join(true, "=", Helpers.wraps(entry.getKey(), entry.getValue()));
            }
        }, new Object[0]));
    }

    public static Map<String, String> chain(String value) {
        HashMap<String, String> values = new HashMap<String, String>();
        for (String v : value.split("[&]")) {
            String[] pair = v.split("[=]", 2);
            values.put((String)Helpers.getElement((Object)pair, 0), (String)Helpers.getElement((Object)pair, 1));
        }
        return values;
    }

    public static String[] trim(String ... values) {
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = Strings.trim((Object)values[i]);
            }
        }
        return values;
    }
}

