/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util.hitch;

import java.io.File;
import net.isger.brick.blue.ClassSeal;
import net.isger.brick.blue.Compiler;
import net.isger.brick.blue.Marks;
import net.isger.brick.blue.MethodSeal;
import net.isger.util.Reflects;
import net.isger.util.Scans;
import net.isger.util.scan.ScanFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hitcher
extends ClassLoader {
    private static final String HITCH_STATION = "HitchStation";
    private static final String HITCH_METHOD = "hitch";
    private static final String HITCH_SUFFIX = "Hitch.class";
    private static final Logger LOG = LoggerFactory.getLogger(Hitcher.class);
    private static final ScanFilter FILTER = new ScanFilter(){

        @Override
        public boolean isDeep(File root, File path) {
            return false;
        }

        @Override
        public boolean accept(String name) {
            return name.endsWith(Hitcher.HITCH_SUFFIX);
        }
    };
    private Class<?> station;
    private int amount;

    protected Hitcher() {
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return Reflects.getClassLoader(this).loadClass(name);
    }

    public Hitcher(String path) {
        ClassSeal cs = ClassSeal.create((int)Marks.VERSION.V0104.value, (int)Marks.ACCESS.PUBLIC.value, (String)HITCH_STATION, (String)Marks.TYPE.OBJECT.name, (String[])new String[0]);
        MethodSeal ms = cs.makeMethod(Marks.ACCESS.PUBLIC.value, "void", "<init>", new String[0]);
        ms.coding("this", "super()", new String[0]);
        ms = cs.makeMethod(Marks.ACCESS.PUBLIC.value | Marks.ACCESS.STATIC.value, Marks.TYPE.BOOLEAN.name, HITCH_METHOD, new String[]{Marks.TYPE.OBJECT.name});
        String className = null;
        String hitchOperate = null;
        for (String name : Scans.scan(path, FILTER)) {
            className = (path + name.replaceFirst("[.]class$", "")).replaceAll("[\\\\/]", ".");
            hitchOperate = className + ".hitch(obj)";
            if (ms.getOperateMark(hitchOperate) != null) {
                LOG.warn("(!) Multiple to hitching {}", (Object)className);
                continue;
            }
            ms.markOperate(hitchOperate, className, Marks.OPCODES.INVOKESTATIC.value, Marks.TYPE.VOID.name, HITCH_METHOD, new String[]{Marks.TYPE.OBJECT.name});
            ms.coding(null, hitchOperate, new String[]{Marks.MISC.arg((int)0)});
            ++this.amount;
        }
        ms.markConst("true", (Object)true);
        ms.coding("return", null, new String[]{"true"});
        byte[] code = Compiler.compile((ClassSeal)cs);
        try {
            this.station = this.defineClass(HITCH_STATION, code, 0, code.length);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failure create hitch station for " + path, e);
        }
    }

    public boolean hitch(Object source) {
        boolean isHitch;
        boolean bl = isHitch = this.amount == 0;
        if (!isHitch) {
            try {
                isHitch = (Boolean)this.station.getMethod(HITCH_METHOD, Object.class).invoke(this.station, source);
            }
            catch (Exception e) {
                LOG.warn("Failure to hitch resource", (Throwable)e);
                isHitch = false;
            }
        }
        return isHitch;
    }
}

