/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util.load;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.isger.util.Asserts;
import net.isger.util.Reflects;
import net.isger.util.Strings;
import net.isger.util.anno.Ignore;
import net.isger.util.load.Loader;
import net.isger.util.reflect.ClassAssembler;
import net.isger.util.reflect.Converter;

@Ignore
public class BaseLoader
implements Loader {
    public static final String PARAM_CLASS = "class";
    private static final Loader LOADER = new BaseLoader(Object.class);
    private Class<?> targetClass;

    public BaseLoader() {
    }

    public BaseLoader(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    public static Object toLoad(Object res) {
        return BaseLoader.toLoad(res, null);
    }

    public static Object toLoad(Object res, ClassAssembler assembler) {
        try {
            return LOADER.load(res, assembler);
        }
        catch (Exception e) {
            return res;
        }
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public Class<?> getImplementClass() {
        return this.getTargetClass();
    }

    public Class<?> getImplementClass(Map<String, Object> res) {
        Class<?> clazz;
        String className;
        Class<?> targetClass = this.getTargetClass();
        if (res != null && Strings.isNotEmpty(className = (String)res.get(PARAM_CLASS))) {
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw Asserts.argument("Not found class %s", className);
            }
        } else {
            clazz = this.getImplementClass();
        }
        Asserts.isAssignable(targetClass, clazz);
        return clazz;
    }

    @Override
    public final Object load(Object res, ClassAssembler assembler) {
        Object result = res instanceof String ? this.load((String)res, assembler) : (res instanceof Collection ? this.load((Collection)res, assembler) : (res instanceof Map ? this.load((Map)res, assembler) : this.create(res, assembler)));
        return result;
    }

    protected Object load(String res, ClassAssembler assembler) {
        return this.create(res, assembler);
    }

    protected Object load(Collection<?> res, ClassAssembler assembler) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object config : res) {
            Object instance;
            Object object = instance = config instanceof Collection ? this.create(config, assembler) : this.load(config, assembler);
            if (instance instanceof Collection) {
                result.addAll((Collection)instance);
                continue;
            }
            result.add(instance);
        }
        return result;
    }

    protected Object load(Map<String, Object> res, ClassAssembler assembler) {
        return this.create(this.getImplementClass(res), res, assembler);
    }

    protected Object create(Class<?> clazz, Map<String, Object> res, ClassAssembler assembler) {
        return clazz == Object.class ? res : Reflects.newInstance(clazz, res, assembler);
    }

    protected Object create(Object res, ClassAssembler assembler) {
        Class<?> implementClass = this.getImplementClass();
        Asserts.isAssignable(this.getTargetClass(), implementClass);
        return Converter.convert(implementClass, res, assembler);
    }
}

