/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import net.isger.util.Asserts;
import net.isger.util.Helpers;
import net.isger.util.Reflects;
import net.isger.util.Strings;
import net.isger.util.anno.Affix;
import net.isger.util.anno.Alias;
import net.isger.util.anno.Infect;
import net.isger.util.anno.Sensitive;
import net.isger.util.reflect.ClassAssembler;
import net.isger.util.reflect.Converter;
import net.isger.util.reflect.FieldAssembler;
import net.isger.util.reflect.TypeToken;

public class BoundField {
    private TypeToken<?> token;
    private Field field;
    private String name;
    private String alias;
    private String affix;
    private boolean sensitive;
    private boolean inject;
    private boolean infect;
    private boolean batch;

    public BoundField(Field field) {
        Alias alias;
        TypeToken<?> declaring = TypeToken.get(field.getDeclaringClass());
        this.token = TypeToken.get(Reflects.getResolveType(declaring.getType(), declaring.getRawClass(), field.getGenericType()));
        this.field = field;
        this.field.setAccessible(true);
        this.name = field.getName();
        Affix affix = field.getAnnotation(Affix.class);
        if (affix != null) {
            this.affix = Strings.empty(affix.value());
        }
        if ((alias = field.getAnnotation(Alias.class)) != null) {
            this.alias = Strings.empty(alias.value());
        } else if (Strings.isNotEmpty(this.affix)) {
            try {
                Map config = (Map)Helpers.fromJson(this.affix);
                this.alias = Strings.toFieldName((String)config.get("name"));
            }
            catch (Exception config) {
                // empty catch block
            }
        }
        this.sensitive = field.getAnnotation(Sensitive.class) != null;
        this.inject = field.getAnnotation(Inject.class) != null;
        this.infect = field.getAnnotation(Infect.class) != null;
        Type resolveType = this.token.getType();
        Class<?> rawClass = this.token.getRawClass();
        this.batch = resolveType instanceof GenericArrayType || Collection.class.isAssignableFrom(rawClass);
    }

    public TypeToken<?> getToken() {
        return this.token;
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getAffix() {
        return this.affix;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public boolean isInject() {
        return this.inject;
    }

    public boolean isInfect() {
        return this.infect;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public void setValue(Object instance, Object value) {
        this.setValue(instance, value, null);
    }

    public void setValue(Object instance, Object value, ClassAssembler assembler) {
        block7: {
            try {
                FieldAssembler fieldAssembler;
                FieldAssembler fieldAssembler2 = fieldAssembler = assembler == null ? null : assembler.getFieldAssembler();
                if (this.isInfect() && fieldAssembler != null) {
                    value = fieldAssembler.assemble(this, instance, value, new Object[0]);
                }
                if (value == Reflects.UNKNOWN) break block7;
                Class<?> rawClass = this.token.getRawClass();
                if (rawClass.isInstance(value)) {
                    value = this.resolve(rawClass, this.token.getType(), value, assembler);
                } else {
                    try {
                        value = Converter.convert(this.token.getType(), value, assembler);
                    }
                    catch (Exception e) {
                        value = Converter.defaultValue(this.token.getType());
                    }
                }
                this.field.set(instance, value);
            }
            catch (Throwable e) {
                throw Asserts.state("Failure to setting field '%s' of %s: %s", this.getName(), this.field.getDeclaringClass(), value, e);
            }
        }
    }

    private Object resolve(Class<?> rawClass, Type resolveType, Object value, ClassAssembler assembler) {
        if (resolveType instanceof GenericArrayType) {
            resolveType = Reflects.getComponentType(resolveType);
            rawClass = Reflects.getRawClass(resolveType);
            int size = Array.getLength(value);
            Object array = Array.newInstance(rawClass, size);
            for (int i = 0; i < size; ++i) {
                Array.set(array, i, this.resolve(rawClass, resolveType, Array.get(value, i), assembler));
            }
            value = array;
        } else if (Collection.class.isAssignableFrom(rawClass) && value instanceof Collection) {
            ParameterizedType paramType = (ParameterizedType)resolveType;
            Collection resolve = (Collection)Reflects.newInstance(rawClass, assembler);
            resolveType = paramType.getActualTypeArguments()[0];
            rawClass = Reflects.getClass(resolveType);
            for (Object instance : (Collection)value) {
                resolve.add(this.resolve(rawClass, paramType.getActualTypeArguments()[0], instance, assembler));
            }
            value = resolve;
        } else if (resolveType instanceof Class && !((Class)resolveType).isInstance(value)) {
            value = Converter.convert((Class)resolveType, value);
        }
        return value;
    }

    public Object getValue(Object instance) {
        return this.getValue(instance, false);
    }

    public Object getValue(Object instance, boolean desensitization) {
        try {
            return desensitization && this.isSensitive() ? null : this.field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw Asserts.state("Can not to access field %s", this.getName(), e);
        }
    }

    public boolean match(String name) {
        return name.equals(this.name) || name.equals(this.alias);
    }

    public String toString() {
        int mod = this.field.getModifiers();
        return (mod == 0 ? "" : Modifier.toString(mod) + " ") + this.token + " " + Reflects.getName(this.field.getDeclaringClass()) + "." + this.getName();
    }
}

