/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import net.isger.brick.blue.Marks;
import net.isger.util.Asserts;
import net.isger.util.Reflects;
import net.isger.util.Strings;
import net.isger.util.anno.Affix;
import net.isger.util.anno.Alias;

public class BoundMethod {
    private Method method;
    private String name;
    private String aliasName;
    private String methodDesc;
    private String affix;

    public BoundMethod(Method method) {
        this.method = method;
        this.method.setAccessible(true);
        this.name = method.getName();
        Alias alias = method.getAnnotation(Alias.class);
        if (alias != null) {
            this.aliasName = Strings.empty(alias.value());
        }
        this.methodDesc = BoundMethod.makeMethodDesc(method);
        Affix affix = method.getAnnotation(Affix.class);
        if (affix != null) {
            this.affix = Strings.empty(affix.value());
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public String getName() {
        return this.name;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public String getMethodDesc() {
        return this.methodDesc;
    }

    public String getAffix() {
        return this.affix;
    }

    public boolean isAbstract() {
        return Reflects.isAbstract(this.method);
    }

    public <T extends Annotation> T getAnnotation(Class<T> anno) {
        return this.method.getAnnotation(anno);
    }

    public Object invoke(Object instance, Object ... args) {
        try {
            return this.method.invoke(instance, args);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw Asserts.state("Failure to invoke method %s", this.getName(), cause);
        }
    }

    public static String makeMethodDesc(Method method) {
        return BoundMethod.makeMethodDesc(method.getName(), method.getReturnType(), method.getParameterTypes());
    }

    public static String makeMethodDesc(String name) {
        return BoundMethod.makeMethodDesc(name, Void.TYPE, new Class[0]);
    }

    public static String makeMethodDesc(String name, Class<?> resultType, Class<?> ... argTypes) {
        if (resultType == null || resultType == Void.class) {
            resultType = Void.TYPE;
        }
        return BoundMethod.isMethodDesc(name) ? name : name + Marks.TYPE.getMethDesc(resultType, (Class[])argTypes);
    }

    public static boolean matches(String methodName, String name) {
        return methodName.matches(name + Marks.TYPE.REGEX_METH);
    }

    public static boolean isMethodDesc(String methodName) {
        return Strings.endWithIgnoreCase(methodName, Marks.TYPE.REGEX_METH);
    }

    public static String getName(String methodName) {
        int index = methodName.lastIndexOf("(");
        if (index > 0) {
            methodName = methodName.substring(0, index);
        }
        return methodName;
    }
}

