/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util.reflect;

import java.util.Hashtable;
import java.util.Map;
import net.isger.util.Asserts;
import net.isger.util.hitch.Director;
import net.isger.util.reflect.Construction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constructor {
    private static final String KEY_CONSTRUCTIONS = "brick.util.reflect.constructions";
    private static final String CONSTRUCTION_PATH = "net/isger/util/reflect/construction";
    private static final Logger LOG = LoggerFactory.getLogger(Constructor.class);
    private static final Constructor CONSTRUCTOR = new Constructor();
    private Map<String, Construction> constructions = new Hashtable<String, Construction>();

    private Constructor() {
    }

    public void addConstruction(Construction construction) {
        String name = construction.getClass().getName();
        if (LOG.isDebugEnabled()) {
            LOG.info("Achieve construction [{}]", (Object)construction);
        }
        if ((construction = this.constructions.put(name, construction)) != null && LOG.isDebugEnabled()) {
            LOG.warn("(!) Discard construction [{}]", (Object)construction);
        }
    }

    public static boolean isSupport(Class<?> rawClass) {
        for (Construction construction : Constructor.CONSTRUCTOR.constructions.values()) {
            if (!construction.isSupport(rawClass)) continue;
            return true;
        }
        return false;
    }

    public static <T> T construct(Class<? extends T> rawClass, Object ... args) {
        for (Construction construction : Constructor.CONSTRUCTOR.constructions.values()) {
            if (!construction.isSupport(rawClass)) continue;
            try {
                return construction.construct(rawClass, args);
            }
            catch (Exception exception) {
            }
        }
        try {
            java.lang.reflect.Constructor<T> cons = rawClass.getDeclaredConstructor(new Class[0]);
            if (cons != null) {
                cons.setAccessible(true);
                return cons.newInstance(new Object[0]);
            }
        }
        catch (Exception cons) {
            // empty catch block
        }
        try {
            return rawClass.newInstance();
        }
        catch (Exception e) {
            throw Asserts.state("Unsupported construct %s", rawClass, e);
        }
    }

    static {
        new Director(){

            @Override
            protected String directPath() {
                return this.directPath(Constructor.KEY_CONSTRUCTIONS, Constructor.CONSTRUCTION_PATH);
            }
        }.direct(CONSTRUCTOR);
    }
}

