/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.isger.util.Asserts;
import net.isger.util.Helpers;
import net.isger.util.Reflects;
import net.isger.util.Strings;
import net.isger.util.hitch.Director;
import net.isger.util.reflect.ClassAssembler;
import net.isger.util.reflect.conversion.Conversion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Converter {
    private static final String KEY_CONVERSIONS = "brick.util.reflect.conversions";
    private static final String CONVERSION_PATH = "net/isger/util/reflect/conversion";
    private static final Logger LOG = LoggerFactory.getLogger(Converter.class);
    private static final Converter CONVERTER = new Converter();
    private Map<String, Conversion> conversions = new Hashtable<String, Conversion>();

    private Converter() {
    }

    public static boolean contains(Conversion conversion) {
        return Converter.CONVERTER.conversions.containsValue(conversion);
    }

    public static void addConversion(Conversion conversion) {
        if (Converter.contains(conversion)) {
            return;
        }
        String name = conversion.getClass().getName();
        if (LOG.isDebugEnabled()) {
            LOG.info("Achieve conversion [{}]", (Object)conversion);
        }
        if ((conversion = Converter.CONVERTER.conversions.put(name, conversion)) != null && LOG.isDebugEnabled()) {
            LOG.warn("(!) Discard conversion [{}]", (Object)conversion);
        }
    }

    public static Conversion getConversion(String name) {
        return Converter.CONVERTER.conversions.get(name);
    }

    public static boolean isSupport(Class<?> clazz) {
        for (Conversion conversion : Converter.CONVERTER.conversions.values()) {
            if (!conversion.isSupport(clazz)) continue;
            return true;
        }
        return false;
    }

    public static Object convert(Type type, Object value) {
        return Converter.convert(type, value, null);
    }

    public static Object convert(Type type, Object value, ClassAssembler assembler) {
        if (value == null) {
            return Converter.defaultValue(type);
        }
        Class<?> rawClass = Reflects.getRawClass(type);
        for (Conversion conversion : Converter.CONVERTER.conversions.values()) {
            if (!conversion.isSupport(type)) continue;
            try {
                return conversion.convert(type, value, assembler);
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.warn("Failure to convert [{}] to [{}]", new Object[]{value, rawClass, e});
            }
        }
        Class<?> srcClass = value.getClass();
        if (rawClass.isAssignableFrom(srcClass)) {
            return value;
        }
        if (value instanceof Collection) {
            value = ((Collection)value).toArray();
            srcClass = value.getClass();
        }
        if (!rawClass.isArray() && !Collection.class.isAssignableFrom(rawClass) && srcClass.isArray()) {
            if (Array.getLength(value) == 0) {
                return Converter.defaultValue(rawClass);
            }
            return Converter.convert(rawClass, Array.get(value, 0));
        }
        if (value instanceof String) {
            if (Strings.isEmpty(value)) {
                return Converter.defaultValue(type);
            }
            Class<?> clazz = Reflects.getClass((String)value);
            if (clazz != null) {
                return Reflects.newInstance(clazz, assembler);
            }
            value = Helpers.fromJson((String)value);
        }
        if (rawClass == String.class) {
            return Helpers.toJson(value).replaceFirst("^[\"]+", "").replaceFirst("[\"]$", "");
        }
        if (value instanceof Map) {
            HashMap config = (HashMap)value;
            if (!config.containsKey("class")) {
                config = new HashMap(config);
                config.put("class", rawClass);
            }
            return Reflects.newInstance((Map<String, ? extends Object>)config, assembler);
        }
        throw Asserts.state("Unsupported convert to %s from %s", Reflects.getName(rawClass), srcClass.getName());
    }

    public static Object defaultValue(Type type) {
        Class<?> rawClass = Reflects.getRawClass(type);
        if (rawClass.isPrimitive() && rawClass != Void.TYPE) {
            if (Boolean.TYPE == rawClass) {
                return false;
            }
            return 0;
        }
        return null;
    }

    static {
        new Director(){

            @Override
            protected String directPath() {
                return this.directPath(Converter.KEY_CONVERSIONS, Converter.CONVERSION_PATH);
            }
        }.direct(CONVERTER);
    }
}

