/*
 * Decompiled with CFR 0.152.
 */
package net.isger.util.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.isger.brick.blue.ClassSeal;
import net.isger.brick.blue.Compiler;
import net.isger.brick.blue.Marks;
import net.isger.brick.blue.MethodSeal;
import net.isger.util.Asserts;
import net.isger.util.Reflects;

public abstract class Standin<T>
extends ClassLoader {
    private static final String CLASS_STANDIN = "Standin";
    private static final String FIELD_STANDIN = "Brick$util$reflect$standin";
    private static final String FIELD_METHODS = "Brick$util$reflect$methods";
    private T source;

    public Standin(Class<T> clazz) {
        super(Reflects.getClassLoader(clazz));
        Constructor<?>[] constructors;
        ClassSeal cs;
        if (clazz.isInterface()) {
            cs = ClassSeal.create((int)Marks.VERSION.V0104.value, (int)Marks.ACCESS.PUBLIC.value, (String)CLASS_STANDIN, (String)Marks.TYPE.OBJECT.name, (String[])new String[]{clazz.getName()});
            constructors = Object.class.getDeclaredConstructors();
        } else {
            cs = ClassSeal.create((int)Marks.VERSION.V0104.value, (int)Marks.ACCESS.PUBLIC.value, (String)CLASS_STANDIN, (String)clazz.getName(), (String[])new String[0]);
            constructors = clazz.getDeclaredConstructors();
        }
        Method[] methods = clazz.getMethods();
        this.makeFields(cs);
        this.makeConstructors(cs, constructors);
        this.makeMethods(cs, methods);
        byte[] code = Compiler.compile((ClassSeal)cs);
        try {
            this.source = this.defineClass(CLASS_STANDIN, code, 0, code.length).newInstance();
            Field field = this.source.getClass().getField(FIELD_STANDIN);
            field.set(this.source, this);
            field = this.source.getClass().getField(FIELD_METHODS);
            field.set(this.source, methods);
        }
        catch (Throwable e) {
            throw Asserts.state("Failure create stand-in for %s", clazz, e);
        }
    }

    private void makeFields(ClassSeal cs) {
        cs.makeField(Marks.ACCESS.PUBLIC.value, Standin.class.getName(), FIELD_STANDIN);
        cs.makeField(Marks.ACCESS.PUBLIC.value, Marks.TYPE.METHODS.name, FIELD_METHODS);
    }

    private void makeConstructors(ClassSeal cs, Constructor<?>[] constructors) {
        for (Constructor<?> constructor : constructors) {
            int mod = constructor.getModifiers();
            if (!Modifier.isProtected(mod) && !Modifier.isPublic(mod)) continue;
            String[] argTypeNames = Marks.TYPE.getArgTypeNames((Class[])constructor.getParameterTypes());
            MethodSeal ms = cs.makeMethod(Marks.ACCESS.PUBLIC.value, "void", "<init>", argTypeNames);
            ms.markOperate("super(" + ms.hashCode() + ")", constructor.getDeclaringClass().getName(), Marks.OPCODES.INVOKESPECIAL.value, Marks.TYPE.VOID.name, "<init>", argTypeNames);
            ms.coding("this", "super(" + ms.hashCode() + ")", Marks.MISC.args((int)argTypeNames.length));
        }
    }

    private void makeMethods(ClassSeal cs, Method[] methods) {
        int size = methods.length;
        for (int i = 0; i < size; ++i) {
            Method method = methods[i];
            int mod = method.getModifiers();
            if (Modifier.isFinal(mod) || Modifier.isStatic(mod) || Modifier.isPrivate(mod)) continue;
            String[] argTypeNames = Marks.TYPE.getArgTypeNames((Class[])method.getParameterTypes());
            MethodSeal ms = cs.makeMethod(Marks.ACCESS.PUBLIC.value, method.getReturnType().getName(), method.getName(), argTypeNames);
            if (Modifier.isAbstract(mod)) {
                ms.markOperate("action(Method, Object[])", Standin.class.getName(), Marks.OPCODES.INVOKEVIRTUAL.value, Marks.TYPE.OBJECT.name, "action", new String[]{Marks.TYPE.METHOD.name, Marks.TYPE.OBJECTS.name});
                ms.markRefer("methods", cs.getName(), Marks.OPCODES.GETFIELD.value, Marks.TYPE.METHODS.name, FIELD_METHODS);
                ms.markCoding("methods[" + i + "]", "array", (Object)i, new String[]{"methods"});
                ms.markCoding("args", "array", Marks.TYPE.OBJECTS.name, Marks.MISC.args((int)argTypeNames.length));
                ms.coding(FIELD_STANDIN, "action(Method, Object[])", new String[]{"methods[" + i + "]", "args"});
                continue;
            }
            ms.markOperate("super.method()", method.getDeclaringClass().getName(), Marks.OPCODES.INVOKESPECIAL.value, method.getReturnType().getName(), method.getName(), argTypeNames);
            ms.coding("this", "super.method()", Marks.MISC.args((int)argTypeNames.length));
        }
    }

    public T getSource() {
        return this.source;
    }

    public abstract Object action(Method var1, Object[] var2);
}

